/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.controllers.impl;

import com.simba.common.command.ICommand;
import com.simba.common.command.SQLCommandExecutor;
import com.simba.common.command.WebCommandExecutor;
import com.simba.common.log.LogUtil;
import com.simba.server.commands.CommandCreator;
import com.simba.server.components.SlotManager;
import com.simba.server.components.SortProtocolCreator;
import com.simba.server.components.data.SlotInfo;
import com.simba.server.controllers.ISlotPackController;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Logger;

public class DepponSlotPackController
implements ISlotPackController {
    private static final Logger logger = Logger.getLogger(DepponSlotPackController.class);

    @Override
    public void onSlotPackMessage(SlotInfo slotInfo) {
        Boolean res = false;
        try {
            slotInfo.setLockStatus(1);
            SlotManager.getInstance().setSlotSoftLockStatus(slotInfo);
            SlotManager.getInstance().sendSlotSoftLockToPLC(slotInfo);
            Timestamp lockedTime = SortProtocolCreator.getInstance().createCurrentTimeStamp();
            slotInfo.setLockTimeStamp(lockedTime);
            this.printSlotPackPoint("start", slotInfo);
            SlotManager.getInstance().doSendSlotStatus(slotInfo, 1);
            res = SlotManager.getInstance().checkSlotIsTrash(slotInfo.getSlotId());
            if (res.booleanValue()) {
                return;
            }
            String boxCode = slotInfo.getBoxInfo().getBoxCode();
            String strSlotId = slotInfo.getSlotId();
            if (slotInfo.getBoxInfo().getMailCount() == 0) {
                LogUtil.LogDebug(logger, "Query Packet Off Count is Zero : slot:[" + strSlotId + "]");
                return;
            }
            String operateTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
            slotInfo.getBoxInfo().setOperateTime(operateTime);
            ICommand command = CommandCreator.getInstance().createCommand("WebPrintChuteCheckCmd", slotInfo);
            res = WebCommandExecutor.getInstance().executeCmd(command);
            if (res.booleanValue()) {
                Timestamp createTime = SortProtocolCreator.getInstance().createCurrentTimeStamp();
                slotInfo.getBoxInfo().setCreateTime(createTime.toString());
                command = CommandCreator.getInstance().createCommand("RecordBoxPackCmd", slotInfo);
                res = SQLCommandExecutor.getInstance().executeCmd(command);
                if (!res.booleanValue()) {
                    LogUtil.LogDebug(logger, "Insert Slot Pack Record In DepponSlotPackController Failed ! slot:[" + strSlotId + "]");
                    SlotManager.getInstance().offerSlotPackToRestore(slotInfo);
                    return;
                }
                this.printSlotPackPoint("end", slotInfo);
                slotInfo.resetBoxInfo();
            }
        }
        catch (Exception ex) {
            LogUtil.LogError(logger, "Handle Deppon Slot Pack Message In DepponSlotPackController Error -- Exception : " + ex);
        }
    }

    private void printSlotPackPoint(String point, SlotInfo slotInfo) {
        StringBuilder boxInfoBuilder = new StringBuilder(50);
        boxInfoBuilder.append("[DepponSlotPackController.onSlotPackMessage] Slot:[");
        boxInfoBuilder.append(slotInfo.getChuteCode());
        boxInfoBuilder.append("],Pack Box Code:[");
        boxInfoBuilder.append(slotInfo.getBoxInfo().getBoxCode());
        boxInfoBuilder.append("],mailCount:[");
        boxInfoBuilder.append(slotInfo.getBoxInfo().getMailCount());
        boxInfoBuilder.append("],point:[");
        boxInfoBuilder.append(point);
        boxInfoBuilder.append("]");
        LogUtil.LogDebug(logger, boxInfoBuilder.toString());
    }
}

