/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.controllers.impl;

import com.simba.common.command.ICommand;
import com.simba.common.command.SQLCommandExecutor;
import com.simba.common.jsonserver.JsonChannelManager;
import com.simba.common.log.LogUtil;
import com.simba.server.commands.CommandCreator;
import com.simba.server.components.PlatInstance;
import com.simba.server.components.PlatManager;
import com.simba.server.components.SortProtocolCreator;
import com.simba.server.components.data.PacketOnInfo;
import com.simba.server.controllers.IPacketOnController;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.Channel;
import org.json.JSONObject;

public class DepponPacketOnController
implements IPacketOnController {
    private static final Logger logger = Logger.getLogger(DepponPacketOnController.class);
    private static final int PACKET_ON_MODE_SCANNED = 3;

    @Override
    public void onPacketOnMessage(PacketOnInfo packetOnInfo) {
        try {
            int modeBinary = packetOnInfo.getPlatModeValue();
            String platId = packetOnInfo.getPlatId();
            String carId = packetOnInfo.getCarId();
            String barcode = packetOnInfo.getBarcode();
            String mode = packetOnInfo.getPlatMode();
            byte[] content = packetOnInfo.getContent();
            if (modeBinary == 3) {
                PlatInstance platInstance = PlatManager.getInstance().getPlatById(platId);
                if (platInstance == null) {
                    return;
                }
                platInstance.handlePacketOnCommand(packetOnInfo);
                this.restorePacketOnInfo(packetOnInfo);
            } else {
                PlatManager.getInstance().addPacketOnInfo(carId, packetOnInfo);
            }
            this.sendPacketOnInfoToClient(carId, platId, mode, barcode);
            this.sendPacketEchoToPlc(content);
        }
        catch (Exception ex) {
            LogUtil.LogError(logger, "Handle JD Packet On Message In JDPacketOn Handler Error -- Exception : " + ex);
        }
    }

    private void restorePacketOnInfo(PacketOnInfo packetOnInfo) {
        ICommand command = CommandCreator.getInstance().createCommand("RecordPacketOnCmd", packetOnInfo);
        SQLCommandExecutor.getInstance().executeCmd(command);
    }

    private void sendPacketEchoToPlc(byte[] content) {
        SortProtocolCreator.getInstance().sendContentEchoToPLC(content);
    }

    private void sendPacketOnInfoToClient(String carId, String platId, String mode, String barcode) {
        try {
            JSONObject sortInfoObj = new JSONObject();
            sortInfoObj.put("ServieName", "PacketOnInfo");
            sortInfoObj.put("carId", carId);
            sortInfoObj.put("platId", platId);
            sortInfoObj.put("platMode", mode);
            sortInfoObj.put("barcode", barcode);
            String sortInfoStr = sortInfoObj.toString();
            for (Channel channel : JsonChannelManager.getInstance().getChannelList()) {
                JsonChannelManager.getInstance().commitResponse(channel, sortInfoStr.getBytes(), false);
            }
        }
        catch (Exception ex) {
            LogUtil.LogError(logger, "[DepponPacketOnController.sendPacketOnInfoToClient],[Packet on info send to remote logger error : " + ex.getMessage() + "]");
        }
    }
}

