/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.controllers.impl;

import com.simba.common.command.ICommand;
import com.simba.common.command.SQLCommandExecutor;
import com.simba.common.command.WebCommandExecutor;
import com.simba.common.log.LogUtil;
import com.simba.server.ServerManager;
import com.simba.server.commands.CommandCreator;
import com.simba.server.components.SlotManager;
import com.simba.server.components.data.SlotInfo;
import com.simba.server.components.data.SortInfo;
import com.simba.server.controllers.IPacketOffController;
import java.util.Calendar;
import org.apache.log4j.Logger;

public class DepponPacketOffController
implements IPacketOffController {
    private static final Logger logger = Logger.getLogger(DepponPacketOffController.class);

    @Override
    public void onPacketOffMessage(SortInfo sortInfo) {
        try {
            this.offerSortResult(sortInfo);
            this.restorePacketOff(sortInfo);
            this.handleAutoSlot(sortInfo);
        }
        catch (Exception ex) {
            LogUtil.LogError(logger, "[DepponPacketOffController.onPacketOffMessage] Handle Deppon PacketOff Message Error -- Exception : " + ex);
        }
    }

    private void handleAutoSlot(SortInfo sortInfo) {
        try {
            int droppedSlotId = sortInfo.getDroppedSlotId();
            String slotId = String.valueOf(droppedSlotId);
            SlotInfo slotInfo = SlotManager.getInstance().getSlotInfo(slotId);
            if (slotInfo == null) {
                return;
            }
            Calendar calendar = Calendar.getInstance();
            int curHour = calendar.get(11);
            if (slotInfo.getCurHour() < 0 || slotInfo.getCurHour() != curHour) {
                slotInfo.setCurHour(curHour);
                slotInfo.setLastHourPacketOff(slotInfo.getCurHourPacketOff());
                slotInfo.setCurHourPacketOff(0);
            }
            slotInfo.setCurHourPacketOff(slotInfo.getCurHourPacketOff() + 1);
            Boolean res = SlotManager.getInstance().checkSlotIsTrash(slotInfo.getSlotId());
            if (res.booleanValue()) {
                return;
            }
            int mailCount = slotInfo.getBoxInfo().getMailCount();
            slotInfo.getBoxInfo().setMailCount(++mailCount);
        }
        catch (Exception ex) {
            LogUtil.LogError(logger, "[DepponPacketOffController.handleAutoSlot] handle AutoSlot Error -- Exception : " + ex);
        }
    }

    private Boolean offerSortResult(SortInfo sortInfo) {
        Boolean ret = false;
        try {
            int droppedSlotId = sortInfo.getDroppedSlotId();
            String slotId = String.valueOf(droppedSlotId);
            SlotInfo slotInfo = SlotManager.getInstance().getSlotInfo(slotId);
            if (slotInfo == null) {
                return ret;
            }
            int uploadNum = sortInfo.getUploadNum() + 1;
            ICommand command = CommandCreator.getInstance().createCommand("WebPacketOffCmd", sortInfo);
            ret = WebCommandExecutor.getInstance().executeCmd(command);
            if (ret.booleanValue()) {
                sortInfo.setUploadFlag(1);
            } else {
                sortInfo.setUploadFlag(0);
            }
            slotInfo.getBoxInfo().getBarcodeList().add(sortInfo.getBarcode());
            sortInfo.setUploadNum(uploadNum);
        }
        catch (Exception ex) {
            LogUtil.LogError(logger, "Handle Deppon PacketOff Message In uploadSortInfo Handler Error -- Exception : " + ex);
            ret = false;
        }
        return ret;
    }

    private void restorePacketOff(SortInfo sortInfo) {
        try {
            ICommand command = CommandCreator.getInstance().createCommand("RecordPacketOffCmd", sortInfo);
            Boolean ret = SQLCommandExecutor.getInstance().executeCmd(command);
            if (!ret.booleanValue()) {
                ServerManager.getInstance().getDataRestoreTask().offerRestoreDataToQueue(sortInfo);
            }
        }
        catch (Exception ex) {
            LogUtil.LogError(logger, "Handle Deppon PacketOff Message In restorePacketOff Handler Error -- Exception : " + ex);
        }
    }
}

