/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.controllers.impl;

import com.simba.common.command.ICommand;
import com.simba.common.command.SQLCommandExecutor;
import com.simba.server.commands.CommandCreator;
import com.simba.server.components.PrinterInfoManager;
import com.simba.server.components.ScreenInfoManager;
import com.simba.server.components.SlotManager;
import com.simba.server.components.data.EmergencyStopInfo;
import com.simba.server.components.data.PrinterInfo;
import com.simba.server.components.data.SlotInfo;
import com.simba.server.controllers.IEmergencyStopController;
import com.simba.server.controllers.impl.DepponPacketOnController;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class DepponEmergencyStopController
implements IEmergencyStopController {
    private static final Logger logger = Logger.getLogger(DepponPacketOnController.class);

    @Override
    public void onEmergencyStopMessage(EmergencyStopInfo emergencyStopInfo) {
        int newlen;
        Map<String, Integer> existStopSites = ScreenInfoManager.getInstance().getStopIds();
        HashMap<String, Integer> stopSites = new HashMap<String, Integer>();
        if (emergencyStopInfo.getStopPanelStatus() != 0) {
            stopSites.put("\u9762\u677f", emergencyStopInfo.getStopPanelStatus());
        }
        if (emergencyStopInfo.getStopOneStatus() != 0) {
            stopSites.put("1", emergencyStopInfo.getStopOneStatus());
        }
        if (emergencyStopInfo.getStopTwoStatus() != 0) {
            stopSites.put("2", emergencyStopInfo.getStopTwoStatus());
        }
        if (emergencyStopInfo.getStopThreeStatus() != 0) {
            stopSites.put("3", emergencyStopInfo.getStopThreeStatus());
        }
        if (emergencyStopInfo.getStopFourStatus() != 0) {
            stopSites.put("4", emergencyStopInfo.getStopFourStatus());
        }
        if (emergencyStopInfo.getStopFiveStatus() != 0) {
            stopSites.put("5", emergencyStopInfo.getStopFiveStatus());
        }
        if ((newlen = stopSites.size()) <= 0) {
            existStopSites.clear();
            List<SlotInfo> slots = this.getListSlotInfo();
            ScreenInfoManager.getInstance().handleSlotStaticStatus(slots);
        }
        int oldLen = existStopSites.size();
        int sum = 0;
        if (oldLen > 0 && oldLen == newlen) {
            for (String key : stopSites.keySet()) {
                if (existStopSites.get(key) != stopSites.get(key)) continue;
                ++sum;
            }
        }
        if (sum == newlen) {
            return;
        }
        ScreenInfoManager.getInstance().setStopIds(stopSites);
        ScreenInfoManager.getInstance().handleEmergency(stopSites);
    }

    private List<SlotInfo> getListSlotInfo() {
        LinkedList<SlotInfo> slots = new LinkedList<SlotInfo>();
        LinkedList<Integer> lockedSlots = new LinkedList<Integer>();
        ICommand command = CommandCreator.getInstance().createCommand("FetchSlotInfoCmd", slots);
        Boolean ret = SQLCommandExecutor.getInstance().executeCmd(command);
        if (ret.booleanValue()) {
            for (SlotInfo slotTmp : slots) {
                PrinterInfo printerInfo;
                String slotId = slotTmp.getSlotId();
                String printerMasterId = slotTmp.getMasterPrinterId();
                String printerSlaveId = slotTmp.getSlavePrinterId();
                int slotDistrict = slotTmp.getSlotDistrict();
                SlotInfo slotInfo = SlotManager.getInstance().getSlotInfo(slotId);
                if (slotInfo == null) continue;
                if (slotInfo.getLockStatus() > 0) {
                    lockedSlots.add(Integer.parseInt(slotId));
                }
                if ((printerInfo = PrinterInfoManager.getInstance().getPrinterInfo(printerMasterId)) != null) {
                    slotInfo.setMasterPrinterId(printerInfo.getPrinterId());
                    slotInfo.setMasterPrinterIp(printerInfo.getPrinterIp());
                }
                if ((printerInfo = PrinterInfoManager.getInstance().getPrinterInfo(printerSlaveId)) != null) {
                    slotInfo.setSlavePrinterId(printerInfo.getPrinterId());
                    slotInfo.setSlavePrinterIp(printerInfo.getPrinterIp());
                }
                slotInfo.setSlotDistrict(slotDistrict);
            }
        }
        if (lockedSlots.size() > 0) {
            ScreenInfoManager.getInstance().handleSlotLockStatus(lockedSlots);
        }
        return slots;
    }
}

