/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.components.data;

import com.simba.common.command.ICommand;
import com.simba.common.command.SQLCommandExecutor;
import com.simba.common.jsonserver.JsonChannelManager;
import com.simba.common.log.LogUtil;
import com.simba.server.commands.CommandCreator;
import com.simba.server.components.data.IRecordData;
import java.sql.Timestamp;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.Channel;
import org.json.JSONObject;

public class SortInfo
implements IRecordData {
    protected static final Logger logger = Logger.getLogger(SortInfo.class);
    private String userCode;
    private String packageNo;
    private String complementCode;
    private String endCameraCode;
    private String sortTime;
    private double weight;
    private double volume;
    private String turnNumber;
    private String lineCode;
    private String scanTime;
    private String cameraCode;
    private String layer;
    private String errCode;
    private String sortSource;
    private double wblWeight;
    private String barcode;
    private final List<String> siteCodeList = new LinkedList<String>();
    private final List<String> barcodeList = new LinkedList<String>();
    private String boxCode;
    private String carId;
    private final List<String> chuteCodeList = new LinkedList<String>();
    private int droppedSlotId;
    private int errorCodePLC;
    private int errorCodeSVR;
    private int obr;
    private String platId;
    private String platMode;
    private String plcId;
    private String scannedMode;
    private String scannedPlatType;
    private String siteCode;
    private int siteCodeValue;
    private int slotDistrict;
    private final List<Integer> slotsList = new LinkedList<Integer>();
    private String sortingId;
    private String sortMode;
    private int sortResultId;
    private String timePacketOff;
    private String timeScanned;
    private Timestamp timestampComplement;
    private Timestamp timestampPacketOff;
    private Timestamp timestampPacketOn;
    private Timestamp timestampScanned;
    private int uploadFlag;
    private int uploadNum;
    private int webJDCode;
    private String WblCode;
    private int isNeedVideoCoding;
    private String errorCode = "";
    private int originalErrorCode = 0;
    private String depId;
    private int length;
    private int width;
    private int height;
    private String uuid;

    public String getLineCode() {
        return this.lineCode;
    }

    public String getScanTime() {
        return this.scanTime;
    }

    public String getCameraCode() {
        return this.cameraCode;
    }

    public String getLayer() {
        return this.layer;
    }

    public String getErrCode() {
        return this.errCode;
    }

    public String getSortSource() {
        return this.sortSource;
    }

    public double getWblWeight() {
        return this.wblWeight;
    }

    public String getBarcode() {
        return this.barcode;
    }

    public List<String> getBarcodeList() {
        return this.barcodeList;
    }

    public String getBoxCode() {
        return this.boxCode;
    }

    public String getCarId() {
        return this.carId;
    }

    public List<String> getChuteCodeList() {
        return this.chuteCodeList;
    }

    public int getDroppedSlotId() {
        return this.droppedSlotId;
    }

    public int getErrorCodePLC() {
        return this.errorCodePLC;
    }

    public int getErrorCodeSVR() {
        return this.errorCodeSVR;
    }

    public int getObr() {
        return this.obr;
    }

    public String getPlatId() {
        return this.platId;
    }

    public String getPlatMode() {
        return this.platMode;
    }

    public String getPlcId() {
        return this.plcId;
    }

    @Override
    public String getRecordDataName() {
        return "Sort-Info-Restore-Data";
    }

    public String getScannedMode() {
        return this.scannedMode;
    }

    public String getScannedPlatType() {
        return this.scannedPlatType;
    }

    public String getSiteCode() {
        return this.siteCode;
    }

    public int getSiteCodeValue() {
        return this.siteCodeValue;
    }

    public int getSlotDistrict() {
        return this.slotDistrict;
    }

    public List<Integer> getSlotsList() {
        return this.slotsList;
    }

    public String getSortingId() {
        return this.sortingId;
    }

    public String getSortMode() {
        return this.sortMode;
    }

    public int getSortResultId() {
        return this.sortResultId;
    }

    public String getTimePacketOff() {
        return this.timePacketOff;
    }

    public String getTimeScanned() {
        return this.timeScanned;
    }

    public Timestamp getTimestampComplement() {
        return this.timestampComplement;
    }

    public Timestamp getTimestampPacketOff() {
        return this.timestampPacketOff;
    }

    public Timestamp getTimestampPacketOn() {
        return this.timestampPacketOn;
    }

    public Timestamp getTimestampScanned() {
        return this.timestampScanned;
    }

    public int getUploadFlag() {
        return this.uploadFlag;
    }

    public int getUploadNum() {
        return this.uploadNum;
    }

    public int getWebJDCode() {
        return this.webJDCode;
    }

    public String getUserCode() {
        return this.userCode;
    }

    public String getPackageNo() {
        return this.packageNo;
    }

    public String getComplementCode() {
        return this.complementCode;
    }

    public String getEndCameraCode() {
        return this.endCameraCode;
    }

    public String getSortTime() {
        return this.sortTime;
    }

    public double getWeight() {
        return this.weight;
    }

    public double getVolume() {
        return this.volume;
    }

    public String getTurnNumber() {
        return this.turnNumber;
    }

    public String getWblCode() {
        return this.WblCode;
    }

    @Override
    public void restoreData() {
        try {
            LogUtil.LogDebug(logger, "[SortInfo.restoreData] Try Restore Packet Off Again. [Barcode:" + this.barcode + "]");
            ICommand command = CommandCreator.getInstance().createCommand("RecordPacketOffCmd", this);
            SQLCommandExecutor.getInstance().executeCmd(command);
        }
        catch (Exception ex) {
            LogUtil.LogError(logger, "Restore PacketOff Message In Sort Info Error -- Exception : " + ex);
        }
    }

    public void sendPacketOffToClient() {
        try {
            JSONObject sortInfoObj = new JSONObject();
            sortInfoObj.put("ServiceName", "SortResult");
            sortInfoObj.put("droppedSlot", this.getDroppedSlotId());
            sortInfoObj.put("barcode", this.getBarcode());
            sortInfoObj.put("trunNumber", this.getTurnNumber());
            sortInfoObj.put("carId", this.getCarId());
            sortInfoObj.put("boxCode", this.getBoxCode());
            sortInfoObj.put("slotsList", this.getSlotsList());
            String sortInfoStr = sortInfoObj.toString();
            for (Channel channel : JsonChannelManager.getInstance().getChannelList()) {
                JsonChannelManager.getInstance().commitResponse(channel, sortInfoStr.getBytes(), false);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void sendSortInfoToClient() {
        try {
            JSONObject sortInfoObj = new JSONObject();
            sortInfoObj.put("ServiceName", "SortInfo");
            sortInfoObj.put("Barcode", this.getBarcode());
            sortInfoObj.put("trunNumber", this.getTurnNumber());
            sortInfoObj.put("carId", this.getCarId());
            sortInfoObj.put("boxCode", this.getBoxCode());
            sortInfoObj.put("slotList", this.getSlotsList());
            sortInfoObj.put("obrNumber", this.obr);
            String sortInfoStr = sortInfoObj.toString();
            for (Channel channel : JsonChannelManager.getInstance().getChannelList()) {
                JsonChannelManager.getInstance().commitResponse(channel, sortInfoStr.getBytes(), false);
            }
        }
        catch (Exception ex) {
            LogUtil.LogError(logger, "[Method]:[sendRequestSortIntoToRemoteLogger] ,[Message]:[sort info send to remote logger error : " + ex.getMessage() + "]");
        }
    }

    public void setBarcode(String mailBarcode) {
        this.barcode = mailBarcode;
    }

    public void setBoxCode(String boxCode) {
        this.boxCode = boxCode;
    }

    public void setCarId(String carId) {
        this.carId = carId;
    }

    public void setDroppedSlotId(int droppedSlotId) {
        this.droppedSlotId = droppedSlotId;
    }

    public void setErrorCodePLC(int errorCodePLC) {
        this.errorCodePLC = errorCodePLC;
    }

    public void setErrorCodeSVR(int errorCode) {
        this.errorCodeSVR = errorCode;
    }

    public void setObr(int obr) {
        this.obr = obr;
    }

    public void setPlatId(String providePlatId) {
        this.platId = providePlatId;
    }

    public void setPlatMode(String supplyMode) {
        this.platMode = supplyMode;
    }

    public void setPlcId(String plcId) {
        this.plcId = plcId;
    }

    public void setScannedMode(String scannedMode) {
        this.scannedMode = scannedMode;
    }

    public void setScannedPlatType(String scannedPlatType) {
        this.scannedPlatType = scannedPlatType;
    }

    public void setSiteCode(String siteCode) {
        this.siteCode = siteCode;
    }

    public void setSiteCodeValue(int siteCodeValue) {
        this.siteCodeValue = siteCodeValue;
    }

    public void setSlotDistrict(int slotDistrict) {
        this.slotDistrict = slotDistrict;
    }

    public void setSortingId(String sortingId) {
        this.sortingId = sortingId;
    }

    public void setSortMode(String sortMode) {
        this.sortMode = sortMode;
    }

    public void setSortResultId(int sortResultId) {
        this.sortResultId = sortResultId;
    }

    public void setTimePacketOff(String packetOffTime) {
        this.timePacketOff = packetOffTime;
    }

    public void setTimeScanned(String timeScanned) {
        this.timeScanned = timeScanned;
    }

    public void setTimestampComplement(Timestamp timestampComplement) {
        this.timestampComplement = timestampComplement;
    }

    public void setTimestampPacketOff(Timestamp timestampPacketOff) {
        this.timestampPacketOff = timestampPacketOff;
    }

    public void setTimestampPacketOn(Timestamp timestampPacketOn) {
        this.timestampPacketOn = timestampPacketOn;
    }

    public void setTimestampScanned(Timestamp timestampScanned) {
        this.timestampScanned = timestampScanned;
    }

    public void setUploadFlag(int uploadFlag) {
        this.uploadFlag = uploadFlag;
    }

    public void setUploadNum(int uploadNum) {
        this.uploadNum = uploadNum;
    }

    public void setVolume(int volume) {
        this.volume = volume;
    }

    public void setWebJDCode(int webJDCode) {
        this.webJDCode = webJDCode;
    }

    public void setWeight(int weight) {
        this.weight = weight;
    }

    public void setUserCode(String userCode) {
        this.userCode = userCode;
    }

    public void setPackageNo(String packageNo) {
        this.packageNo = packageNo;
    }

    public void setComplementCode(String complementCode) {
        this.complementCode = complementCode;
    }

    public void setEndCameraCode(String endCameraCode) {
        this.endCameraCode = endCameraCode;
    }

    public void setSortTime(String sortTime) {
        this.sortTime = sortTime;
    }

    public void setWeight(double weight) {
        this.weight = weight;
    }

    public void setVolume(double volume) {
        this.volume = volume;
    }

    public void setTurnNumber(String turnNumber) {
        this.turnNumber = turnNumber;
    }

    public void setLineCode(String lineCode) {
        this.lineCode = lineCode;
    }

    public void setScanTime(String scanTime) {
        this.scanTime = scanTime;
    }

    public void setCameraCode(String cameraCode) {
        this.cameraCode = cameraCode;
    }

    public void setLayer(String layer) {
        this.layer = layer;
    }

    public void setErrCode(String errCode) {
        this.errCode = errCode;
    }

    public void setSortSource(String sortSource) {
        this.sortSource = sortSource;
    }

    public void setWblWeight(double wblWeight) {
        this.wblWeight = wblWeight;
    }

    public void setWblCode(String wblCode) {
        this.WblCode = wblCode;
    }

    public List<String> getSiteCodeList() {
        return this.siteCodeList;
    }

    public int getIsNeedVideoCoding() {
        return this.isNeedVideoCoding;
    }

    public void setIsNeedVideoCoding(int isNeedVideoCoding) {
        this.isNeedVideoCoding = isNeedVideoCoding;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public int getOriginalErrorCode() {
        return this.originalErrorCode;
    }

    public void setOriginalErrorCode(int originalErrorCode) {
        this.originalErrorCode = originalErrorCode;
    }

    public String getDepId() {
        return this.depId;
    }

    public void setDepId(String depId) {
        this.depId = depId;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }
}

