/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.components.data;

import com.simba.common.command.ICommand;
import com.simba.common.command.SQLCommandExecutor;
import com.simba.common.log.LogUtil;
import com.simba.server.commands.CommandCreator;
import com.simba.server.components.SlotManager;
import com.simba.server.components.SortProtocolCreator;
import com.simba.server.components.data.BoxInfo;
import com.simba.server.components.data.IRecordData;
import java.sql.Timestamp;
import org.apache.log4j.Logger;

public class SlotInfo
implements IRecordData {
    private static final Logger logger = Logger.getLogger(SlotInfo.class);
    private Boolean allocBoxInfo = false;
    private final BoxInfo boxInfo = new BoxInfo();
    private String chuteCode;
    private int lockStatus;
    private String masterPrinterId;
    private String masterPrinterIp;
    private String slavePrinterId;
    private String slavePrinterIp;
    private int slotDistrict;
    private String destName;
    private String sortCodetype;
    private String complementCode;
    private String slotId;
    private String lineCode;
    private String sortCode;
    private String operateTime;
    private String beginCode;
    private String beginName;
    private String destCode;
    private String destnation;
    private String packageNo;
    private String packagePcs;
    private String screenIp;
    private String screenId;
    private Timestamp lockTimeStamp;
    private int lastHourPacketOff = 0;
    private int curHourPacketOff = 0;
    private int curHour = -1;

    public void cloneSlotInfo(SlotInfo toSlotInfo) {
        this.slotDistrict = toSlotInfo.getSlotDistrict();
        this.slotId = toSlotInfo.getSlotId();
        this.chuteCode = toSlotInfo.getChuteCode();
        this.masterPrinterId = toSlotInfo.getMasterPrinterId();
        this.masterPrinterIp = toSlotInfo.getMasterPrinterIp();
        this.slavePrinterId = toSlotInfo.getSlavePrinterId();
        this.slavePrinterIp = toSlotInfo.getSlavePrinterIp();
        this.boxInfo.setBoxCode(toSlotInfo.getBoxInfo().getBoxCode());
        this.boxInfo.setBoxType(toSlotInfo.getBoxInfo().getBoxType());
        this.boxInfo.setReceiveSiteCode(toSlotInfo.getBoxInfo().getReceiveSiteCode());
        this.boxInfo.setReceiveSiteName(toSlotInfo.getBoxInfo().getReceiveSiteName());
        this.boxInfo.setCreateSiteName(toSlotInfo.getBoxInfo().getCreateSiteName());
        this.boxInfo.setMailCount(toSlotInfo.getBoxInfo().getMailCount());
        this.boxInfo.setMixBoxTypeText(toSlotInfo.getBoxInfo().getMixBoxTypeText());
        this.boxInfo.setCategoryText(toSlotInfo.getBoxInfo().getCategoryText());
        this.boxInfo.setRouter(toSlotInfo.getBoxInfo().getRouter());
        this.boxInfo.setRouterNum(toSlotInfo.getBoxInfo().getRouterNum());
        this.boxInfo.setUploadFlag(0);
        this.boxInfo.setUploadNum(0);
    }

    public Boolean getAllocBoxInfo() {
        return this.allocBoxInfo;
    }

    public BoxInfo getBoxInfo() {
        return this.boxInfo;
    }

    public String getChuteCode() {
        return this.chuteCode;
    }

    public int getLockStatus() {
        return this.lockStatus;
    }

    public String getMasterPrinterId() {
        return this.masterPrinterId;
    }

    public String getMasterPrinterIp() {
        return this.masterPrinterIp;
    }

    @Override
    public String getRecordDataName() {
        return "Slot-Pack-Restore-Info";
    }

    public String getSlavePrinterId() {
        return this.slavePrinterId;
    }

    public String getSlavePrinterIp() {
        return this.slavePrinterIp;
    }

    public int getSlotDistrict() {
        return this.slotDistrict;
    }

    public String getSlotId() {
        return this.slotId;
    }

    public String getLineCode() {
        return this.lineCode;
    }

    public String getSortCode() {
        return this.sortCode;
    }

    public String getOperateTime() {
        return this.operateTime;
    }

    public String getBeginCode() {
        return this.beginCode;
    }

    public String getBeginName() {
        return this.beginName;
    }

    public String getDestCode() {
        return this.destCode;
    }

    public String getDestnation() {
        return this.destnation;
    }

    public String getPackageNo() {
        return this.packageNo;
    }

    public String getPackagePcs() {
        return this.packagePcs;
    }

    public String getDestName() {
        return this.destName;
    }

    public String getSortCodetype() {
        return this.sortCodetype;
    }

    public String getComplementCode() {
        return this.complementCode;
    }

    public void resetBoxInfo() {
        this.allocBoxInfo = false;
        this.boxInfo.setId(0);
        this.boxInfo.setBoxCode("");
        this.boxInfo.setBoxType("");
        this.boxInfo.setReceiveSiteCode("");
        this.boxInfo.setReceiveSiteName("");
        this.boxInfo.setCreateSiteName("");
        this.boxInfo.setMailCount(0);
        this.boxInfo.setTotalWeight(0.0);
        this.boxInfo.setMixBoxTypeText("");
        this.boxInfo.setCategoryText("");
        this.boxInfo.setRouter("");
        this.boxInfo.setRouterNum("");
        this.boxInfo.setUploadFlag(0);
        this.boxInfo.setUploadNum(0);
    }

    @Override
    public void restoreData() {
        Boolean res = false;
        try {
            LogUtil.LogDebug(logger, "[SlotInfo.restoreData] Try Restore Slot Pack Again. [BoxCode:" + this.boxInfo.getBoxCode() + "]");
            res = SlotManager.getInstance().checkSlotIsTrash(this.getSlotId());
            if (res.booleanValue()) {
                return;
            }
            String boxCode = this.getBoxInfo().getBoxCode();
            if (boxCode == null || boxCode.equals("")) {
                LogUtil.LogDebug(logger, "Slot Box Code Is Null : [" + this.getSlotId() + "]");
                return;
            }
            ICommand command = CommandCreator.getInstance().createCommand("FetchPacketCountCmd", this);
            res = SQLCommandExecutor.getInstance().executeCmd(command);
            if (!res.booleanValue()) {
                LogUtil.LogDebug(logger, "Query Packet Off Count In SlotInfo Failed ");
                return;
            }
            if (this.getBoxInfo().getMailCount() == 0) {
                LogUtil.LogDebug(logger, "Query Packet Off Count is Zero");
                return;
            }
            Timestamp createTime = SortProtocolCreator.getInstance().createCurrentTimeStamp();
            this.getBoxInfo().setCreateTime(createTime.toString());
            command = CommandCreator.getInstance().createCommand("RecordBoxPackCmd", this);
            res = SQLCommandExecutor.getInstance().executeCmd(command);
            if (!res.booleanValue()) {
                LogUtil.LogDebug(logger, "Insert Slot Pack Record In SlotInfo Failed ");
                return;
            }
            this.resetBoxInfo();
        }
        catch (Exception ex) {
            LogUtil.LogError(logger, "Handle Slot Pack Message In SlotInfo Error -- Exception : " + ex);
        }
    }

    public void setAllocBoxInfo(Boolean status) {
        this.allocBoxInfo = status;
    }

    public void setChuteCode(String chuteCode) {
        this.chuteCode = chuteCode;
    }

    public void setLockStatus(int lockStatus) {
        this.lockStatus = lockStatus;
    }

    public void setMasterPrinterId(String masterPrinterId) {
        this.masterPrinterId = masterPrinterId;
    }

    public void setMasterPrinterIp(String masterPrinterIp) {
        this.masterPrinterIp = masterPrinterIp;
    }

    public void setSlavePrinterId(String slavePrinterId) {
        this.slavePrinterId = slavePrinterId;
    }

    public void setSlavePrinterIp(String slavePrinterIp) {
        this.slavePrinterIp = slavePrinterIp;
    }

    public void setSlotDistrict(int slotDistrict) {
        this.slotDistrict = slotDistrict;
    }

    public void setSlotId(String slotId) {
        this.slotId = slotId;
    }

    public void setDestName(String destName) {
        this.destName = destName;
    }

    public void setSortCodetype(String sortCodetype) {
        this.sortCodetype = sortCodetype;
    }

    public void setComplementCode(String complementCode) {
        this.complementCode = complementCode;
    }

    public void setLineCode(String lineCode) {
        this.lineCode = lineCode;
    }

    public void setSortCode(String sortCode) {
        this.sortCode = sortCode;
    }

    public void setOperateTime(String operateTime) {
        this.operateTime = operateTime;
    }

    public void setBeginCode(String beginCode) {
        this.beginCode = beginCode;
    }

    public void setBeginName(String beginName) {
        this.beginName = beginName;
    }

    public void setDestCode(String destCode) {
        this.destCode = destCode;
    }

    public void setDestnation(String destnation) {
        this.destnation = destnation;
    }

    public void setPackageNo(String packageNo) {
        this.packageNo = packageNo;
    }

    public void setPackagePcs(String packagePcs) {
        this.packagePcs = packagePcs;
    }

    public String getScreenIp() {
        return this.screenIp;
    }

    public void setScreenIp(String screenIp) {
        this.screenIp = screenIp;
    }

    public String getScreenId() {
        return this.screenId;
    }

    public void setScreenId(String screenId) {
        this.screenId = screenId;
    }

    public Timestamp getLockTimeStamp() {
        return this.lockTimeStamp;
    }

    public void setLockTimeStamp(Timestamp lockTimeStamp) {
        this.lockTimeStamp = lockTimeStamp;
    }

    public int getLastHourPacketOff() {
        return this.lastHourPacketOff;
    }

    public void setLastHourPacketOff(int lastHourPacketOff) {
        this.lastHourPacketOff = lastHourPacketOff;
    }

    public int getCurHourPacketOff() {
        return this.curHourPacketOff;
    }

    public void setCurHourPacketOff(int curHourPacketOff) {
        this.curHourPacketOff = curHourPacketOff;
    }

    public int getCurHour() {
        return this.curHour;
    }

    public void setCurHour(int curHour) {
        this.curHour = curHour;
    }
}

