/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.components;

import com.simba.common.jsonserver.JsonChannelManager;
import com.simba.common.log.Log4jLogger;
import com.simba.common.log.LogTask;
import com.simba.common.log.LoggerExecutor;
import com.simba.server.components.BarcodeManager;
import com.simba.server.components.PlatManager;
import com.simba.server.components.SlotManager;
import com.simba.server.components.SortProtocolCreator;
import com.simba.server.components.data.SortInfo;
import com.simba.server.components.data.VideoClient;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.Channel;
import org.json.JSONObject;

public class SortInfoManager {
    protected static final Logger logger = Logger.getLogger(SortInfoManager.class);
    private static int curAssignTask = 0;
    private final ConcurrentHashMap<String, Integer> siteCodeMap = new ConcurrentHashMap();
    private final AtomicInteger siteCodeSerial = new AtomicInteger(0);
    private final ConcurrentHashMap<String, SortInfo> sortInfoList = new ConcurrentHashMap();

    public static SortInfoManager getInstance() {
        return SortManagerHolder.INSTANCE;
    }

    private SortInfoManager() {
    }

    public void addSortInfo(SortInfo sortInfo) {
        if (sortInfo != null) {
            this.sortInfoList.put(sortInfo.getCarId(), sortInfo);
        }
    }

    public void clearSiteCodeMap() {
        this.siteCodeSerial.set(0);
        this.siteCodeMap.clear();
    }

    public void clearSortInfoList() {
        this.sortInfoList.clear();
    }

    public boolean containsSortInfo(String key) {
        return this.sortInfoList.containsKey(key);
    }

    public void createSiteCodeValue(SortInfo sortInfo) {
        String siteCode = sortInfo.getSiteCode();
        if (siteCode == null || siteCode.equals("")) {
            return;
        }
        int siteCodeValue = 0;
        if (this.siteCodeMap.containsKey(siteCode)) {
            siteCodeValue = this.siteCodeMap.get(siteCode);
        } else {
            siteCodeValue = this.siteCodeSerial.incrementAndGet();
            this.siteCodeMap.put(siteCode, siteCodeValue);
        }
        sortInfo.setSiteCodeValue(siteCodeValue);
    }

    public SortInfo createSortInfo() {
        SortInfo sortInfo = new SortInfo();
        sortInfo.setSortingId(this.createSortingId());
        return sortInfo;
    }

    public void doHandleNoSlotInfo(SortInfo sortInfo) {
        sortInfo.getSlotsList().clear();
        List<Integer> slots = SlotManager.getInstance().getNoInfoTrashSlots();
        sortInfo.getSlotsList().addAll(slots);
    }

    public void doHandlePacketOverBoarder(SortInfo sortInfo) {
        sortInfo.getSlotsList().clear();
        List<Integer> slots = SlotManager.getInstance().getNoInfoTrashSlots();
        sortInfo.getSlotsList().addAll(slots);
    }

    public void doHandleComplementOverTimeAndOverMaxTimes(SortInfo sortInfo) {
        sortInfo.getSlotsList().clear();
        List<Integer> slots = SlotManager.getInstance().getNoInfoTrashSlots();
        sortInfo.getSlotsList().addAll(slots);
    }

    public void doHandleSlotLockAndOverMaxTimes(SortInfo sortInfo) {
        sortInfo.getSlotsList().clear();
        List<Integer> slots = SlotManager.getInstance().getNoInfoTrashSlots();
        sortInfo.getSlotsList().addAll(slots);
    }

    public void doHandleWarnSumAndOverMaxTimes(SortInfo sortInfo) {
        sortInfo.getSlotsList().clear();
        List<Integer> slots = SlotManager.getInstance().getNoInfoTrashSlots();
        sortInfo.getSlotsList().addAll(slots);
    }

    public void doHandleWarnWeightAndOverMaxTimes(SortInfo sortInfo) {
        sortInfo.getSlotsList().clear();
        List<Integer> slots = SlotManager.getInstance().getNoInfoTrashSlots();
        sortInfo.getSlotsList().addAll(slots);
    }

    public void doHandleNotDepponWayBill(SortInfo sortInfo) {
        sortInfo.setSiteCode("trashSlot");
        sortInfo.setSortSource("3");
        sortInfo.getSlotsList().clear();
        List<Integer> slots = SlotManager.getInstance().getInvalidCodeTrashSlots();
        sortInfo.getSlotsList().addAll(slots);
    }

    public void doHandleInvalidCode(SortInfo sortInfo) {
        sortInfo.setSortSource("3");
        sortInfo.getSlotsList().clear();
        List<Integer> slots = SlotManager.getInstance().getInvalidCodeTrashSlots();
        sortInfo.getSlotsList().addAll(slots);
    }

    public void doHandleMultiCode(SortInfo sortInfo) {
        sortInfo.getSlotsList().clear();
        List<Integer> slots = SlotManager.getInstance().getMultiCodeTrashSlots();
        sortInfo.getSlotsList().addAll(slots);
    }

    public void doHandleNoRead(SortInfo sortInfo) {
        sortInfo.setSiteCode("trashSlot");
        sortInfo.setSortSource("3");
        sortInfo.getSlotsList().clear();
        List<Integer> slots = SlotManager.getInstance().getNoReadTrashSlots();
        sortInfo.getSlotsList().addAll(slots);
    }

    public SortInfo getSortInfo(String key) {
        return this.sortInfoList.get(key.toLowerCase());
    }

    public int getSortInfoCount() {
        return this.sortInfoList.size();
    }

    public SortInfo[] getSortInfoList() {
        return this.sortInfoList.values().toArray(new SortInfo[0]);
    }

    public void handleSortInfoResult(SortInfo sortInfo) {
        int errorCode = sortInfo.getErrorCodeSVR();
        if (errorCode == 200) {
            this.doHandleSuccess(sortInfo);
        } else {
            this.doHandleNoPlan(sortInfo);
        }
    }

    public void postInitProcess() {
    }

    public SortInfo removeSortInfo(String key) {
        return this.sortInfoList.remove(key);
    }

    private String createSortingId() {
        UUID uuid = UUID.randomUUID();
        long now = System.currentTimeMillis();
        String timeInfo = String.valueOf(now);
        String uuidStr = uuid.toString() + "-" + timeInfo;
        return uuidStr;
    }

    private void doHandleEXP120(SortInfo sortInfo) {
        sortInfo.getSlotsList().clear();
        List<Integer> slots = SlotManager.getInstance().getEXP120TrashSlots();
        sortInfo.getSlotsList().addAll(slots);
    }

    private void doHandleEXP130(SortInfo sortInfo) {
        sortInfo.getSlotsList().clear();
        List<Integer> slots = SlotManager.getInstance().getEXP130TrashSlots();
        sortInfo.getSlotsList().addAll(slots);
    }

    private void doHandleNoInfo(SortInfo sortInfo) {
        sortInfo.getSlotsList().clear();
        List<Integer> slots = SlotManager.getInstance().getNoInfoTrashSlots();
        sortInfo.getSlotsList().addAll(slots);
        SortInfoManager.getInstance().createSiteCodeValue(sortInfo);
    }

    private void doHandleNoPlan(SortInfo sortInfo) {
        sortInfo.getSlotsList().clear();
        List<Integer> slots = SlotManager.getInstance().getNoPlanTrashSlots();
        sortInfo.getSlotsList().addAll(slots);
        String siteCode = String.valueOf("NoPlan");
        sortInfo.setSiteCode(siteCode);
        SortInfoManager.getInstance().createSiteCodeValue(sortInfo);
    }

    public void doHandleOverTime(SortInfo sortInfo) {
        sortInfo.getSlotsList().clear();
        List<Integer> slots = SlotManager.getInstance().getOverTimeTrashSlots();
        sortInfo.getSlotsList().addAll(slots);
    }

    private void doHandleParamsError(SortInfo sortInfo) {
        sortInfo.getSlotsList().clear();
        List<Integer> slots = SlotManager.getInstance().getJDSvrErrorTrashSlots();
        sortInfo.getSlotsList().addAll(slots);
    }

    private void doHandleSuccess(SortInfo sortInfo) {
        SortInfoManager.getInstance().createSiteCodeValue(sortInfo);
    }

    public void taskAssign(SortInfo sortInfo) {
        try {
            int nChannelCount;
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "task assin barcode=" + sortInfo.getBarcode(), 1));
            ArrayList<Channel> channels = new ArrayList<Channel>();
            String strPlat = "";
            for (Map.Entry<String, VideoClient> entry : PlatManager.getInstance().getVideoClients().entrySet()) {
                Channel channel = entry.getValue().getChannel();
                if (channel == null || !channel.isConnected()) {
                    strPlat = entry.getKey();
                    continue;
                }
                channels.add(channel);
            }
            if (!strPlat.equalsIgnoreCase("")) {
                PlatManager.getInstance().removeVideoClient(strPlat);
            }
            if ((nChannelCount = channels.size()) == 0) {
                LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "video channel count 0", 2));
                curAssignTask = 0;
                return;
            }
            if (curAssignTask >= nChannelCount) {
                curAssignTask = 0;
            }
            Thread.sleep(1000L);
            this.sendTask(sortInfo, (Channel)channels.get(curAssignTask));
            BarcodeManager.getInstance().getVideoSortInfos().put(sortInfo.getBarcode(), sortInfo);
            ++curAssignTask;
        }
        catch (Exception EX) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "taskAssign error" + EX.getMessage(), 2));
        }
    }

    private void sendTask(SortInfo sortInfo, Channel channel) {
        byte[] content = this.createTaskContent(sortInfo);
        LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "send task " + channel.getLocalAddress(), 1));
        JsonChannelManager.getInstance().commitResponse(channel, content, false);
    }

    public byte[] createTaskContent(SortInfo sortInfo) {
        JSONObject responObj = new JSONObject();
        try {
            Timestamp nowTime = SortProtocolCreator.getInstance().createCurrentTimeStamp();
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String time = nowTime.toString();
            responObj.put("ServiceName", "VideoCoding");
            responObj.put("barcode", sortInfo.getBarcode());
            responObj.put("platId", "7");
            responObj.put("time", time);
            String carID = sortInfo.getCarId();
            String strNewCarid = SlotManager.getInstance().getSortCode(Integer.parseInt(carID));
            responObj.put("carID", strNewCarid);
            responObj.put("obr", String.valueOf(sortInfo.getObr()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return responObj.toString().getBytes();
    }

    private static class SortManagerHolder {
        private static final SortInfoManager INSTANCE = new SortInfoManager();

        private SortManagerHolder() {
        }
    }
}

