/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.components;

import com.simba.common.command.ICommand;
import com.simba.common.command.SQLCommandExecutor;
import com.simba.common.log.LogUtil;
import com.simba.server.commands.CommandCreator;
import com.simba.server.components.data.PrinterInfo;
import java.util.LinkedList;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

public class PrinterInfoManager {
    protected static final Logger logger = Logger.getLogger(PrinterInfoManager.class);
    private final ConcurrentHashMap<String, PrinterInfo> printerInfoMap = new ConcurrentHashMap();

    public static PrinterInfoManager getInstance() {
        return PrinterManagerHolder.INSTANCE;
    }

    private PrinterInfoManager() {
    }

    public void addPrinterInfo(PrinterInfo printerInfo) {
        if (printerInfo == null || printerInfo.getPrinterId() == null) {
            return;
        }
        this.printerInfoMap.put(printerInfo.getPrinterId(), printerInfo);
    }

    public PrinterInfo getPrinterInfo(String printerId) {
        if (printerId == null || printerId.equals("")) {
            return null;
        }
        return this.printerInfoMap.get(printerId);
    }

    public PrinterInfo[] getPrinterInfos() {
        return this.printerInfoMap.values().toArray(new PrinterInfo[0]);
    }

    public void loadPrinters() {
        try {
            this.printerInfoMap.clear();
            LinkedList printerInfos = new LinkedList();
            ICommand command = CommandCreator.getInstance().createCommand("FetchPrinterInfoCmd", printerInfos);
            SQLCommandExecutor.getInstance().executeCmd(command);
            for (PrinterInfo printerInfo : printerInfos) {
                this.addPrinterInfo(printerInfo);
            }
        }
        catch (Exception ex) {
            LogUtil.LogError(logger, "[PrinterManager.initPrinters] Init printers info error: " + ex);
        }
    }

    public PrinterInfo removePrinterInfo(String printerId) {
        return this.printerInfoMap.remove(printerId);
    }

    private static class PrinterManagerHolder {
        private static final PrinterInfoManager INSTANCE = new PrinterInfoManager();

        private PrinterManagerHolder() {
        }
    }
}

