/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.commands.impl;

import com.simba.common.command.ICommand;
import com.simba.common.command.WebCommandExecutor;
import com.simba.common.log.LogUtil;
import com.simba.server.components.SortProtocolCreator;
import com.simba.server.components.SorterParams;
import com.simba.server.components.data.SortInfo;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.json.JSONObject;

public class WebSortCodeCmd
implements ICommand {
    public static final String NAME = "WebSortCodeCmd";
    private static final Logger logger = Logger.getLogger("WebSortCodeCmd");
    private final SortInfo sortInfo;

    public WebSortCodeCmd(SortInfo sortInfo) {
        this.sortInfo = sortInfo;
    }

    @Override
    public String getName() {
        return NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean run(Object params) {
        Boolean ret = false;
        String urlPostFix = "/AutoSort/Sort";
        String serverHost = SorterParams.getInstance().getServerHost();
        String serverPort = SorterParams.getInstance().getServerPort();
        if (!SorterParams.getInstance().isNeedDataUpload()) {
            serverHost = SorterParams.getInstance().getDebugServerHost();
            serverPort = SorterParams.getInstance().getDebugServerPort();
        }
        String url = "http://" + serverHost + ":" + serverPort + urlPostFix;
        HttpPost postRequest = new HttpPost(url);
        String content = SortProtocolCreator.getInstance().createSortInfo(this.sortInfo);
        StringEntity contentEntity = new StringEntity(content, "UTF-8");
        LogUtil.LogDebug(logger, "query sort code:" + content);
        contentEntity.setContentEncoding("UTF-8");
        contentEntity.setContentType("application/json");
        postRequest.setEntity(contentEntity);
        CloseableHttpResponse response = null;
        try {
            JSONObject responseObj;
            int code;
            response = WebCommandExecutor.getInstance().doHttpServiceByPost(postRequest);
            HttpEntity entity = response.getEntity();
            byte[] contentBuffer = EntityUtils.toByteArray(entity);
            content = new String(contentBuffer, "UTF-8");
            LogUtil.LogDebug(logger, "response sort code:" + content);
            if (content.contains("400 Bad Request")) {
                LogUtil.LogError(logger, "Catch 400 error:response msg is" + content);
            }
            if ((code = (responseObj = new JSONObject(content)).getInt("Code")) == 200) {
                String barCode = responseObj.getString("Barcode");
                this.sortInfo.setBarcode(barCode);
                int chuteCode = responseObj.getInt("ChuteCode");
                String siteCode = "";
                this.sortInfo.getSlotsList().add(chuteCode);
                this.sortInfo.getChuteCodeList().add(String.valueOf(chuteCode));
                siteCode = String.valueOf(chuteCode);
                this.sortInfo.setSiteCode(siteCode);
                String message = "";
                Object obj = responseObj.get("Message");
                if (message != null) {
                    message = obj.toString();
                }
                this.sortInfo.setErrorCodeSVR(code);
                ret = true;
            } else if (code > 0) {
                this.sortInfo.setErrorCodeSVR(code);
            }
        }
        catch (Exception ex) {
            this.sortInfo.setErrorCodeSVR(990);
            LogUtil.LogError(logger, "Catch IO Exception when get sort code , Request Content:[" + content + "] Exception Message:" + ex.getMessage());
            ret = false;
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException ex) {
                    LogUtil.LogError(logger, "Catch an exception when close a http response :" + ex.getMessage());
                }
            }
        }
        return ret;
    }
}

