/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.commands.impl;

import com.simba.common.command.ICommand;
import com.simba.common.command.WebCommandExecutor;
import com.simba.common.log.LogUtil;
import com.simba.server.components.SortProtocolCreator;
import com.simba.server.components.SorterParams;
import com.simba.server.components.data.SlotInfo;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.json.JSONObject;

public class WebPrintChuteCheckCmd
implements ICommand {
    public static final String NAME = "WebPrintChuteCheckCmd";
    private static final Logger logger = Logger.getLogger(WebPrintChuteCheckCmd.class);
    private final SlotInfo slotInfo;

    public WebPrintChuteCheckCmd(SlotInfo slotInfo) {
        this.slotInfo = slotInfo;
    }

    @Override
    public String getName() {
        return NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean run(Object params) {
        Boolean ret = false;
        String urlPostFix = "/AutoSort/ChutePrint";
        String serverHost = SorterParams.getInstance().getServerHost();
        String serverPort = SorterParams.getInstance().getServerPort();
        if (!SorterParams.getInstance().isNeedBoxInfo()) {
            serverHost = SorterParams.getInstance().getDebugServerHost();
            serverPort = SorterParams.getInstance().getDebugServerPort();
        }
        String url = "http://" + serverHost + ":" + serverPort + urlPostFix;
        HttpPost postRequest = new HttpPost(url);
        String content = SortProtocolCreator.getInstance().createPrintChuteContent(this.slotInfo);
        LogUtil.LogDebug(logger, "ChutePrint send content:" + content);
        StringEntity contentEntity = new StringEntity(content, "UTF-8");
        contentEntity.setContentEncoding("UTF-8");
        contentEntity.setContentType("application/json");
        postRequest.setEntity(contentEntity);
        CloseableHttpResponse response = null;
        try {
            JSONObject responseObj;
            int status;
            response = WebCommandExecutor.getInstance().doHttpServiceByPost(postRequest);
            HttpEntity entity = response.getEntity();
            byte[] contentBuffer = EntityUtils.toByteArray(entity);
            content = new String(contentBuffer, "UTF-8");
            LogUtil.LogDebug(logger, "ChutePrint response conten:" + content);
            if (content.contains("400 Bad Request")) {
                LogUtil.LogError(logger, "Catch 400 error:response msg is" + content);
            }
            if ((status = (responseObj = new JSONObject(content)).getInt("Code")) == 200) {
                ret = true;
                String strMsg = responseObj.getString("Message");
                if (strMsg != null && !strMsg.equals(null) && strMsg.length() > 0) {
                    this.slotInfo.getBoxInfo().setDestnation(strMsg);
                }
                if (ret.booleanValue()) {
                    this.printSlotCheckSuccessInfo();
                }
            } else {
                this.printSlotPrintCheckFailed(status);
                ret = false;
            }
        }
        catch (IOException ex) {
            LogUtil.LogError(logger, "Catch IO Exception when request box info , Request Content:[" + content + "] Exception Message:" + ex.getMessage());
            ret = false;
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException ex) {
                    LogUtil.LogError(logger, "Catch an exception when close a http response :" + ex.getMessage());
                }
            }
        }
        return ret;
    }

    private void printSlotPrintCheckFailed(int status) {
        StringBuilder boxInfoBuilder = new StringBuilder(50);
        boxInfoBuilder.append("Slot:[");
        boxInfoBuilder.append(this.slotInfo.getChuteCode());
        boxInfoBuilder.append("],check print Failed:[");
        boxInfoBuilder.append(status);
        boxInfoBuilder.append("]");
        LogUtil.LogDebug(logger, boxInfoBuilder.toString());
    }

    private void printSlotCheckSuccessInfo() {
        StringBuilder boxInfoBuilder = new StringBuilder(50);
        boxInfoBuilder.append("Slot:[");
        boxInfoBuilder.append(this.slotInfo.getChuteCode());
        boxInfoBuilder.append("],check print success:[");
        boxInfoBuilder.append(this.slotInfo.getBoxInfo().getBoxCode());
        boxInfoBuilder.append("]");
        LogUtil.LogDebug(logger, boxInfoBuilder.toString());
    }
}

