/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.commands.impl;

import com.simba.common.command.ICommand;
import com.simba.common.command.WebCommandExecutor;
import com.simba.common.log.LogUtil;
import com.simba.server.components.ScreenInfoManager;
import com.simba.server.components.data.DisplayInfo;
import com.simba.server.components.data.ScreenInfo;
import java.io.IOException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.log4j.Logger;

public class WebColorLightCmd
implements ICommand {
    public static final String NAME = "WebColorLightCmd";
    private static final Logger logger = Logger.getLogger(WebColorLightCmd.class);
    private final DisplayInfo disPlayInfo;

    public WebColorLightCmd(DisplayInfo displayInfo) {
        this.disPlayInfo = displayInfo;
    }

    @Override
    public String getName() {
        return NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean run(Object params) {
        Boolean ret = false;
        if (this.disPlayInfo == null) {
            return ret;
        }
        String displayID = this.disPlayInfo.getDisPlayID();
        ScreenInfo screenInfo = ScreenInfoManager.getInstance().getScreenInfo(displayID);
        String url = screenInfo.getScreenIp();
        url = "http://" + url + "/api/program/Multi-Line.vsn";
        HttpPost postRequest = new HttpPost(url);
        String content = this.disPlayInfo.getDisPlayMessage();
        StringEntity contentEntity = new StringEntity(content, "UTF-8");
        contentEntity.setContentEncoding("UTF-8");
        contentEntity.setContentType("application/json;charset=UTF-8");
        postRequest.setEntity(contentEntity);
        CloseableHttpResponse response = null;
        try {
            response = WebCommandExecutor.getInstance().doHttpServiceByPost(postRequest);
        }
        catch (IOException ex) {
            LogUtil.LogError(logger, "Catch IO Exception when offer slot pack info , Request Content:[" + content + "] Exception Message:" + ex.getMessage());
            ret = false;
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException ex) {
                    LogUtil.LogError(logger, "Catch an exception when close a http response :" + ex.getMessage());
                }
            }
        }
        return ret;
    }
}

