/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.commands.impl;

import com.simba.common.command.ICommand;
import com.simba.common.command.WebCommandExecutor;
import com.simba.common.log.LogUtil;
import com.simba.server.components.MachineParams;
import com.simba.server.components.SlotManager;
import com.simba.server.components.SortProtocolCreator;
import com.simba.server.components.SorterParams;
import com.simba.server.components.data.TrashSlotInfo;
import com.simba.server.components.data.VideoSortInfo;
import com.simba.server.task.RSAEncrypt;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class WebBasicConfigCmd
implements ICommand {
    public static final String NAME = "WebBasicConfigCmd";
    protected static final Logger logger = Logger.getLogger(WebBasicConfigCmd.class);
    private final TrashSlotInfo trashSlotInfo;

    public WebBasicConfigCmd(TrashSlotInfo trashSlotInfo) {
        this.trashSlotInfo = trashSlotInfo;
    }

    @Override
    public String getName() {
        return NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean run(Object params) {
        Boolean ret = false;
        String urlPostFix = "/tads-sort-itf/expressSort/getLineInfo";
        String serverHost = SorterParams.getInstance().getServerHost();
        String serverPort = SorterParams.getInstance().getServerPort();
        if (!SorterParams.getInstance().isNeedDataUpload()) {
            serverHost = SorterParams.getInstance().getDebugServerHost();
            serverPort = SorterParams.getInstance().getDebugServerPort();
        }
        String url = "http://" + serverHost + ":" + serverPort + urlPostFix;
        HttpPost postRequest = new HttpPost(url);
        String content = SortProtocolCreator.getInstance().createGetBasicConfig();
        StringEntity contentEntity = new StringEntity(content, "UTF-8");
        contentEntity.setContentEncoding("UTF-8");
        contentEntity.setContentType("application/json");
        postRequest.addHeader("Token", RSAEncrypt.getToken());
        postRequest.setEntity(contentEntity);
        CloseableHttpResponse response = null;
        try {
            response = WebCommandExecutor.getInstance().doHttpServiceByPost(postRequest);
            HttpEntity entity = response.getEntity();
            byte[] contentBuffer = EntityUtils.toByteArray(entity);
            content = new String(contentBuffer, "UTF-8");
            JSONObject responseObj = new JSONObject(content);
            int status = Integer.parseInt(responseObj.getString("status"));
            if (status == 1) {
                JSONObject dataObj = responseObj.getJSONObject("data");
                String maxTimes = dataObj.getString("maxTimes");
                MachineParams.getInstance().setMaxTimes(maxTimes);
                String warnWeight = dataObj.getString("warnWeight");
                MachineParams.getInstance().setWarnWeight(warnWeight);
                String warnSum = dataObj.getString("warnSum");
                MachineParams.getInstance().setWarnSum(warnSum);
                JSONArray sortInfosArr = dataObj.getJSONArray("sortInfos");
                int length = sortInfosArr.length();
                if (length == 0) {
                    LogUtil.LogError(logger, "sortInfos size 0");
                }
                StringBuilder strBuilder = new StringBuilder();
                for (int i = 0; i < length; ++i) {
                    JSONObject itemObj = sortInfosArr.getJSONObject(i);
                    strBuilder.append(itemObj.toString());
                    String sortCode = itemObj.getString("sortCode");
                    String destName = "";
                    if (itemObj.has("destOrgName") && !itemObj.isNull("destOrgName")) {
                        destName = itemObj.getString("destOrgName");
                    }
                    String sortCodetype = itemObj.getString("sortCodetype");
                    String complementCode = itemObj.getString("complementCode");
                    if (sortCodetype.contains("\u5f02\u5e38")) {
                        LogUtil.LogDebug(logger, "exception sort code:" + sortCode);
                        int trashSlotId = Integer.parseInt(sortCode);
                        this.trashSlotInfo.getTrashSlots().add(trashSlotId);
                    }
                    VideoSortInfo videoSortInfo = new VideoSortInfo();
                    videoSortInfo.setSortCode(sortCode);
                    videoSortInfo.setDestName(destName);
                    videoSortInfo.setSortCodetype(sortCodetype);
                    videoSortInfo.setComplementCode(complementCode);
                    SlotManager.getInstance().getVideoSortInfos().put(complementCode, videoSortInfo);
                }
                LogUtil.LogDebug(logger, strBuilder.toString());
                ret = true;
            }
        }
        catch (IOException ex) {
            LogUtil.LogError(logger, "Catch IO Exception when request machineParams , Response Content:[" + content + "] Exception Message:" + ex.getMessage());
            ret = false;
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException ex) {
                    LogUtil.LogError(logger, "Catch an exception when close a http response :" + ex.getMessage());
                }
            }
        }
        return ret;
    }
}

