/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.commands.impl;

import com.simba.common.command.ICommand;
import com.simba.common.command.WebCommandExecutor;
import com.simba.common.log.LogUtil;
import com.simba.server.components.BarcodeManager;
import com.simba.server.components.SorterParams;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.json.JSONObject;

public class WebBarRuleCmd
implements ICommand {
    public static final String NAME = "WebBarRuleCmd";
    private static final Logger logger = Logger.getLogger(WebBarRuleCmd.class);
    private final String configName;

    public WebBarRuleCmd(String configName) {
        this.configName = configName;
    }

    @Override
    public String getName() {
        return NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean run(Object params) {
        Boolean ret = false;
        String urlPostFix = "/sysconfig/findConfigContentByConfigName/";
        String serverHost = SorterParams.getInstance().getServerHost();
        String serverPort = SorterParams.getInstance().getServerPort();
        String url = "http://" + serverHost + ":" + serverPort + urlPostFix + this.configName;
        HttpGet configRegexRequest = new HttpGet(url);
        CloseableHttpResponse response = null;
        String content = "None";
        try {
            response = WebCommandExecutor.getInstance().doHttpServiceByGet(configRegexRequest);
            HttpEntity entity = response.getEntity();
            byte[] contentBuffer = EntityUtils.toByteArray(entity);
            content = new String(contentBuffer, "UTF-8");
            JSONObject responseObj = new JSONObject(content);
            int status = responseObj.getInt("code");
            if (status == 200) {
                ret = true;
                String configContent = responseObj.getString("configContent");
                if (this.configName.equals("boxCode")) {
                    BarcodeManager.getInstance().setWebBoxRegex(configContent);
                } else if (this.configName.equals("packageCode")) {
                    BarcodeManager.getInstance().setWebPackageRegex(configContent);
                }
            } else {
                ret = false;
            }
        }
        catch (IOException ex) {
            LogUtil.LogError(logger, "Catch IO Exception when request barcode regex info , Response Content:[" + content + "] Exception Message:" + ex.getMessage());
            ret = false;
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException ex) {
                    LogUtil.LogError(logger, "Catch an exception when close a http response :" + ex.getMessage());
                }
            }
        }
        return ret;
    }
}

