/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.commands.impl;

import com.simba.common.command.ICommand;
import com.simba.common.command.WebCommandExecutor;
import com.simba.common.log.LogUtil;
import com.simba.server.commands.impl.WebLineCodeCmd;
import com.simba.server.components.SortProtocolCreator;
import com.simba.server.components.SorterParams;
import java.io.IOException;
import java.sql.Timestamp;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.json.JSONObject;

public class WebAsyncTimeCmd
implements ICommand {
    public static final String NAME = "WebAsyncTimeCmd";
    private final String lineCode;

    public WebAsyncTimeCmd(String lineCode) {
        this.lineCode = lineCode;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Boolean run(Object params) {
        Boolean ret = false;
        String urlPostFix = "/tads-sort-itf/expressSort/asyncTime";
        String serverHost = SorterParams.getInstance().getServerHost();
        String serverPort = SorterParams.getInstance().getServerPort();
        if (!SorterParams.getInstance().isNeedDataUpload()) {
            serverHost = SorterParams.getInstance().getDebugServerHost();
            serverPort = SorterParams.getInstance().getDebugServerPort();
        }
        String url = "http://" + serverHost + ":" + serverPort + urlPostFix;
        HttpPost postRequest = new HttpPost(url);
        String content = SortProtocolCreator.getInstance().createAsynTimeContent(this.lineCode);
        StringEntity contentEntity = new StringEntity(content, "UTF-8");
        contentEntity.setContentEncoding("UTF-8");
        contentEntity.setContentType("application/json");
        postRequest.setEntity(contentEntity);
        CloseableHttpResponse response = null;
        try {
            Timestamp currentTime = SortProtocolCreator.getInstance().createCurrentTimeStamp();
            LogUtil.LogDebug(WebLineCodeCmd.logger, "asyn time current machine time:" + currentTime);
            response = WebCommandExecutor.getInstance().doHttpServiceByPost(postRequest);
            HttpEntity entity = response.getEntity();
            byte[] contentBuffer = EntityUtils.toByteArray(entity);
            content = new String(contentBuffer, "UTF-8");
            JSONObject responseObj = new JSONObject(content);
            int status = responseObj.getInt("status");
            if (status == 1) {
                JSONObject dataObj = responseObj.getJSONObject("data");
                String resTime = dataObj.getString("time");
                LogUtil.LogDebug(WebLineCodeCmd.logger, "remote machine time:" + resTime);
            }
            ret = true;
        }
        catch (IOException ex) {
            LogUtil.LogError(WebLineCodeCmd.logger, "Catch IO Exception when request lineCode , Response Content:[" + content + "] Exception Message:" + ex.getMessage());
            ret = false;
        }
        return ret;
    }
}

