/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.commands.impl;

import com.simba.common.command.ICommand;
import com.simba.common.database.DbOperator;
import com.simba.server.components.data.SortPlanItem;
import java.util.List;

public class RecordSortPlanCmd
implements ICommand {
    public static final String NAME = "RecordSortPlanCmd";
    private final List<SortPlanItem> sortPlanItems;
    private final String sql = "insert into tt_sort_plan_info(planName, planId, siteName, sortMode, siteNo, itemId, pkgLableName, boxSiteCode, currChuteCode, siteCode, subType, chuteCode1) values (?,?,?,?,?,?,?,?,?,?,?,?)";

    public RecordSortPlanCmd(List<SortPlanItem> sortPlanItems) {
        this.sortPlanItems = sortPlanItems;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Boolean run(Object params) {
        Boolean ret = false;
        if (!(params instanceof DbOperator)) {
            return ret;
        }
        if (this.sortPlanItems == null || this.sortPlanItems.size() == 0) {
            return ret;
        }
        try {
            DbOperator dbOperator = (DbOperator)params;
            dbOperator.clearParameters();
            dbOperator.prepareStatement(this.sql);
            dbOperator.setAutoCommit(false);
            for (SortPlanItem itemInfo : this.sortPlanItems) {
                dbOperator.setString(1, itemInfo.getName());
                dbOperator.setInt(2, itemInfo.getPlanId());
                dbOperator.setString(3, itemInfo.getSiteName());
                dbOperator.setString(4, itemInfo.getSortMode());
                dbOperator.setString(5, itemInfo.getSiteNo());
                dbOperator.setInt(6, itemInfo.getItemId());
                dbOperator.setString(7, itemInfo.getPkgLabelName());
                dbOperator.setString(8, itemInfo.getBoxSiteCode());
                dbOperator.setString(9, itemInfo.getCurrChuteCode());
                dbOperator.setString(10, itemInfo.getSiteCode());
                dbOperator.setString(11, itemInfo.getSubType());
                dbOperator.setString(12, itemInfo.getChuteCode1());
                dbOperator.addBatch();
            }
            int[] rs = dbOperator.executeBatch();
            if (rs == null || rs.length <= 0) {
                return ret;
            }
            dbOperator.commit();
            dbOperator.setAutoCommit(true);
            ret = true;
        }
        catch (Exception ex) {
            ret = false;
        }
        return ret;
    }
}

