/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.commands.impl;

import com.simba.common.command.ICommand;
import com.simba.common.database.DbOperator;
import com.simba.server.components.SortProtocolCreator;
import com.simba.server.components.data.SortInfo;
import java.sql.Timestamp;

public class RecordPlatScannedCmd
implements ICommand {
    public static final String NAME = "RecordPlatScannedCmd";
    private final SortInfo sortInfo;
    private final String sql = "insert into tt_scanned_info(barcode,platId,platMode,workerNo,scannedMode,scannedPlatType,scannedTime) values(?,?,?,?,?,?,?);";

    public RecordPlatScannedCmd(SortInfo sortInfo) {
        this.sortInfo = sortInfo;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Boolean run(Object params) {
        Boolean ret = false;
        if (!(params instanceof DbOperator)) {
            return ret;
        }
        try {
            DbOperator dbOperator = (DbOperator)params;
            dbOperator.prepareStatement(this.sql);
            String barcode = this.sortInfo.getBarcode();
            if (barcode == null || barcode.equals("")) {
                barcode = "none";
            }
            dbOperator.setString(1, barcode);
            String platId = String.valueOf(this.sortInfo.getPlatId());
            if (platId == null || platId.equals("")) {
                platId = "none";
            }
            dbOperator.setString(2, platId);
            String platMode = this.sortInfo.getPlatMode();
            if (platMode == null || platMode.equals("")) {
                platMode = "none";
            }
            dbOperator.setString(3, platMode);
            String workerNo = "Test";
            dbOperator.setString(4, workerNo);
            String scannedMode = this.sortInfo.getScannedMode();
            if (scannedMode == null || scannedMode.equals("")) {
                scannedMode = "none";
            }
            dbOperator.setString(5, scannedMode);
            String scannedPlatType = this.sortInfo.getScannedPlatType();
            if (scannedPlatType == null || scannedPlatType.equals("")) {
                scannedPlatType = "none";
            }
            dbOperator.setString(6, scannedPlatType);
            Timestamp scannedTime = this.sortInfo.getTimestampScanned();
            if (scannedTime == null) {
                scannedTime = SortProtocolCreator.getInstance().createCurrentTimeStamp();
            }
            String scannedTimeContent = scannedTime.toString();
            dbOperator.setString(7, scannedTimeContent);
            int res = dbOperator.executeUpdate();
            ret = res > 0 ? Boolean.valueOf(true) : Boolean.valueOf(false);
        }
        catch (Exception ex) {
            ret = false;
        }
        return ret;
    }
}

