/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.commands.impl;

import com.simba.common.command.ICommand;
import com.simba.common.database.DbOperator;
import com.simba.server.components.data.BoxInfo;
import java.util.List;

public class RecordBoxInfoCmd
implements ICommand {
    public static final String NAME = "RecordBoxInfoCmd";
    private final List<BoxInfo> boxInfos;
    private final String sql = "insert into tt_box_info(slotId, chuteCode, boxCode, boxType, receiveSiteCode,receiveSiteName, createSiteName, router, routerNum, categoryText, mixBoxTypeText) values (?,?,?,?,?,?,?,?,?,?,?)";

    public RecordBoxInfoCmd(List<BoxInfo> slotIPacknfos) {
        this.boxInfos = slotIPacknfos;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Boolean run(Object params) {
        Boolean ret = false;
        if (!(params instanceof DbOperator)) {
            return ret;
        }
        if (this.boxInfos == null || this.boxInfos.size() == 0) {
            return ret;
        }
        try {
            DbOperator dbOperator = (DbOperator)params;
            dbOperator.clearParameters();
            dbOperator.prepareStatement(this.sql);
            dbOperator.setAutoCommit(false);
            for (BoxInfo boxInfo : this.boxInfos) {
                dbOperator.setString(1, boxInfo.getSlotId());
                dbOperator.setString(2, boxInfo.getChuteCode());
                dbOperator.setString(3, boxInfo.getBoxCode());
                dbOperator.setString(4, boxInfo.getBoxType());
                dbOperator.setString(5, boxInfo.getReceiveSiteCode());
                dbOperator.setString(6, boxInfo.getReceiveSiteName());
                dbOperator.setString(7, boxInfo.getCreateSiteName());
                dbOperator.setString(8, boxInfo.getRouter());
                dbOperator.setString(9, boxInfo.getRouterNum());
                dbOperator.setString(10, boxInfo.getCategoryText());
                dbOperator.setString(11, boxInfo.getMixBoxTypeText());
                dbOperator.addBatch();
            }
            int[] rs = dbOperator.executeBatch();
            if (rs == null || rs.length <= 0) {
                return ret;
            }
            dbOperator.commit();
            dbOperator.setAutoCommit(true);
            ret = true;
        }
        catch (Exception ex) {
            ret = false;
        }
        return ret;
    }
}

