/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.commands.impl;

import com.simba.common.command.ICommand;
import com.simba.common.database.DbOperator;
import com.simba.server.components.data.SortPlanItem;
import java.sql.ResultSet;
import java.util.List;

public class FetchSortPlanCmd
implements ICommand {
    public static final String NAME = "FetchSortPlanCmd";
    private final List<SortPlanItem> sortPlanItems;
    private final String sql = "select sortMode,chuteCode1 from tt_sort_plan_info where siteCode=?;";

    public FetchSortPlanCmd(List<SortPlanItem> sortPlanItems) {
        this.sortPlanItems = sortPlanItems;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Boolean run(Object params) {
        Boolean ret = false;
        if (!(params instanceof DbOperator)) {
            return ret;
        }
        if (this.sortPlanItems.size() == 0) {
            return ret;
        }
        SortPlanItem item = this.sortPlanItems.get(0);
        String siteCode = item.getSiteCode();
        this.sortPlanItems.clear();
        try {
            DbOperator dbOperator = (DbOperator)params;
            dbOperator.prepareStatement(this.sql);
            dbOperator.setString(1, siteCode);
            ResultSet rs = dbOperator.executeQuery();
            while (rs.next()) {
                SortPlanItem sortPlanItem = new SortPlanItem();
                String slotId = rs.getString("chuteCode1");
                sortPlanItem.setChuteCode1(slotId);
                String sortMode = rs.getString("sortMode");
                sortPlanItem.setSortMode(sortMode);
                sortPlanItem.setSiteCode(siteCode);
                this.sortPlanItems.add(sortPlanItem);
            }
            ret = true;
        }
        catch (Exception ex) {
            ret = false;
        }
        return ret;
    }
}

