/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.commands.impl;

import com.simba.common.command.ICommand;
import com.simba.common.database.DbOperator;
import com.simba.server.components.data.ScreenInfo;
import java.sql.ResultSet;
import java.util.concurrent.ConcurrentHashMap;

public class FetchScreenInfoCmd
implements ICommand {
    public static final String NAME = "FetchScreenInfoCmd";
    private ConcurrentHashMap<String, ScreenInfo> screenInfos = new ConcurrentHashMap();
    private final String sql = "select * from tt_screen_config;";

    public FetchScreenInfoCmd(ConcurrentHashMap<String, ScreenInfo> screenInfos) {
        this.screenInfos = screenInfos;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Boolean run(Object params) {
        Boolean ret = false;
        if (!(params instanceof DbOperator)) {
            return ret;
        }
        try {
            DbOperator dbOperator = (DbOperator)params;
            dbOperator.prepareStatement(this.sql);
            ResultSet rs = dbOperator.executeQuery();
            while (rs.next()) {
                String screenId = rs.getString("screenID");
                String screenIp = rs.getString("IP");
                ScreenInfo screen = new ScreenInfo();
                screen.setScreenId(screenId);
                screen.setScreenIp(screenIp);
                this.screenInfos.put(screenId, screen);
            }
            ret = true;
        }
        catch (Exception ex) {
            ret = false;
        }
        return ret;
    }
}

