/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.commands.impl;

import com.simba.common.command.ICommand;
import com.simba.common.database.DbOperator;
import com.simba.server.components.SorterParams;
import com.simba.server.components.data.SortInfo;
import java.sql.ResultSet;
import org.apache.log4j.Logger;

public class FetchPacketOffCmd
implements ICommand {
    public static final String NAME = "FetchPacketOffCmd";
    protected static final Logger logger = Logger.getLogger(FetchPacketOffCmd.class);
    private final SortInfo sortInfo;
    private final String sql = "select * from tt_packet_off_info where uploadFlag=0 and uploadNum<? and errorCodeSVR = 0 order by id asc limit 1;";

    public FetchPacketOffCmd(SortInfo sortInfo) {
        this.sortInfo = sortInfo;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Boolean run(Object params) {
        Boolean ret = false;
        if (!(params instanceof DbOperator)) {
            return ret;
        }
        try {
            DbOperator dbOperator = (DbOperator)params;
            dbOperator.prepareStatement(this.sql);
            dbOperator.setInt(1, SorterParams.getInstance().getUploadNum());
            ResultSet rs = dbOperator.executeQuery();
            if (rs.next()) {
                int sortResultId = rs.getInt("id");
                this.sortInfo.setSortResultId(sortResultId);
                String barcode = rs.getString("barcode");
                this.sortInfo.setBarcode(barcode);
                int droppedSlot = rs.getInt("droppedSlot");
                this.sortInfo.setDroppedSlotId(droppedSlot);
                String boxCode = rs.getString("boxCode");
                this.sortInfo.setBoxCode(boxCode);
                String packOffTime = rs.getString("packetOffTime");
                this.sortInfo.setTimePacketOff(packOffTime);
                int turnNumber = rs.getInt("turnNumber");
                this.sortInfo.setTurnNumber(String.valueOf(turnNumber));
                int carID = rs.getInt("carId");
                this.sortInfo.setCarId(String.valueOf(carID));
                int platID = rs.getInt("platId");
                this.sortInfo.setPlatId(String.valueOf(platID));
                int layer = rs.getInt("layer");
                this.sortInfo.setLayer(String.valueOf(layer));
                String complementCode = rs.getString("complementCode");
                this.sortInfo.setComplementCode(complementCode);
                int sortSource = rs.getInt("sortSource");
                this.sortInfo.setSortSource(String.valueOf(sortSource));
                int errorCodeSVR = rs.getInt("errorCodeSVR");
                this.sortInfo.setErrorCodeSVR(errorCodeSVR);
                String depID = rs.getString("depId");
                this.sortInfo.setDepId(depID);
                int uploadNum = rs.getInt("uploadNum");
                this.sortInfo.setUploadNum(uploadNum);
            }
            ret = true;
        }
        catch (Exception ex) {
            ret = false;
        }
        return ret;
    }
}

