/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.commands.impl;

import com.simba.common.command.ICommand;
import com.simba.common.database.DbOperator;
import com.simba.server.components.SorterParams;
import com.simba.server.components.data.BoxInfo;
import java.sql.ResultSet;

public class FetchBoxPackCmd
implements ICommand {
    public static final String NAME = "FetchBoxPackCmd";
    private final BoxInfo boxInfo;
    private final String sql = "select id,boxCode,uploadNum,mailCount,slotId,boxType,receiveSiteCode,createTime from tt_slot_pack_info where uploadFlag=0 and uploadNum<? order by id asc limit 1;";

    public FetchBoxPackCmd(BoxInfo boxInfo) {
        this.boxInfo = boxInfo;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Boolean run(Object params) {
        Boolean ret = false;
        if (!(params instanceof DbOperator)) {
            return ret;
        }
        try {
            DbOperator dbOperator = (DbOperator)params;
            dbOperator.prepareStatement(this.sql);
            dbOperator.setInt(1, SorterParams.getInstance().getUploadNum());
            ResultSet rs = dbOperator.executeQuery();
            if (rs.next()) {
                int id = rs.getInt("id");
                this.boxInfo.setId(id);
                String boxCode = rs.getString("boxCode");
                this.boxInfo.setBoxCode(boxCode);
                int uploadNum = rs.getInt("uploadNum");
                this.boxInfo.setUploadNum(uploadNum);
                int count = rs.getInt("mailCount");
                this.boxInfo.setMailCount(count);
                String chuteCode = rs.getString("slotId");
                this.boxInfo.setChuteCode(chuteCode);
                String boxType = rs.getString("boxType");
                this.boxInfo.setBoxType(boxType);
                String receiveSiteCode = rs.getString("receiveSiteCode");
                this.boxInfo.setReceiveSiteCode(receiveSiteCode);
                String createTime = rs.getString("createTime");
                this.boxInfo.setCreateTime(createTime);
            }
            ret = true;
        }
        catch (Exception ex) {
            ret = false;
        }
        return ret;
    }
}

