/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.commands.impl;

import com.simba.common.command.ICommand;
import com.simba.common.database.DbOperator;
import com.simba.server.components.data.BoxInfo;
import com.simba.server.components.data.SlotInfo;
import java.sql.ResultSet;

public class FetchBoxInfoCmd
implements ICommand {
    public static final String NAME = "FetchBoxInfoCmd";
    private final SlotInfo slotInfo;
    private final String sql = "select * from tt_box_info where slotId=? and batchFlag=0 order by id asc limit 1;";

    public FetchBoxInfoCmd(SlotInfo slotInfo) {
        this.slotInfo = slotInfo;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Boolean run(Object params) {
        Boolean ret = false;
        if (!(params instanceof DbOperator)) {
            return ret;
        }
        try {
            DbOperator dbOperator = (DbOperator)params;
            dbOperator.prepareStatement(this.sql);
            dbOperator.setString(1, this.slotInfo.getSlotId());
            ResultSet boxObj = dbOperator.executeQuery();
            if (boxObj.next()) {
                BoxInfo boxInfo = this.slotInfo.getBoxInfo();
                int id = boxObj.getInt("id");
                boxInfo.setId(id);
                String boxCode = boxObj.getString("boxCode");
                boxInfo.setBoxCode(boxCode);
                String boxType = boxObj.getString("boxType");
                boxInfo.setBoxType(boxType);
                String recieveSiteCode = boxObj.getString("receiveSiteCode");
                boxInfo.setReceiveSiteCode(recieveSiteCode);
                String receiveSiteName = boxObj.getString("receiveSiteName");
                boxInfo.setReceiveSiteName(receiveSiteName);
                String createSiteName = boxObj.getString("createSiteName");
                boxInfo.setCreateSiteName(createSiteName);
                String categoryText = boxObj.getString("categoryText");
                boxInfo.setCategoryText(categoryText);
                String mixBoxTypeText = boxObj.getString("mixBoxTypeText");
                boxInfo.setMixBoxTypeText(mixBoxTypeText);
                String routers = boxObj.getString("router");
                boxInfo.setRouter(routers);
                String routerNum = boxObj.getString("routerNum");
                boxInfo.setRouterNum(routerNum);
                String slotId = boxObj.getString("slotId");
                boxInfo.setSlotId(slotId);
                String chuteCode = boxObj.getString("chuteCode");
                boxInfo.setChuteCode(chuteCode);
                ret = true;
            }
        }
        catch (Exception ex) {
            ret = false;
        }
        return ret;
    }
}

