/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server;

import com.simba.GlobalParam;
import com.simba.common.command.CommandParams;
import com.simba.common.command.SQLCommandExecutor;
import com.simba.common.database.DbPool;
import com.simba.common.database.DbPoolInterface;
import com.simba.common.frameserver.FrameChannelHandler;
import com.simba.common.frameserver.FrameChannelManager;
import com.simba.common.frameserver.TwoBFrameServer;
import com.simba.common.jsonserver.JsonChannelHandler;
import com.simba.common.jsonserver.JsonChannelManager;
import com.simba.common.jsonserver.JsonServer;
import com.simba.common.log.Log4jLogger;
import com.simba.common.log.LogTask;
import com.simba.common.log.LogUtil;
import com.simba.common.log.LoggerExecutor;
import com.simba.common.processor.FrameProcessor;
import com.simba.common.processor.JsonProcessor;
import com.simba.server.ServerParam;
import com.simba.server.components.BarcodeManager;
import com.simba.server.components.MachineParams;
import com.simba.server.components.PlatManager;
import com.simba.server.components.PrinterInfoManager;
import com.simba.server.components.ScreenInfoManager;
import com.simba.server.components.SlotManager;
import com.simba.server.components.SortControllerManager;
import com.simba.server.components.SortPlanManager;
import com.simba.server.components.SortProtocolCreator;
import com.simba.server.components.SorterParams;
import com.simba.server.framedecoder.FrameDecoderManager;
import com.simba.server.jsonservice.JsonServiceManager;
import com.simba.server.netclient.DefaultBootstrapManager;
import com.simba.server.netclient.DefaultClientManager;
import com.simba.server.task.BoxPackOfferTask;
import com.simba.server.task.ColorLightTask;
import com.simba.server.task.DataClearTask;
import com.simba.server.task.DataRestoreTask;
import com.simba.server.task.SortPlanTask;
import com.simba.server.task.SortResultOfferTask;
import com.simba.server.task.SorterStatusTask;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;
import org.jdom2.input.sax.XMLReaderSAX2Factory;

public class ServerManager {
    private static final String CLIENT_CONFIG_FILE = "simba-client-config.xml";
    private static ServerManager instance = new ServerManager();
    private static final String LOG_HEADERS_CONFIG_FILE = "simba-header-config.xml";
    private static final String LOG4J_CONFIG_FILE_DEBUG = "simba-log4j-debug.xml";
    private static final String LOG4J_CONFIG_FILE_VERBOSE = "simba-log4j-verbose.xml";
    private static final Logger logger = Logger.getLogger(ServerManager.class);
    private static final String MYSQL_DATABASE_CONFIG_FILE = "simba-mysql-config.xml";
    private static final String PLAT_CONFIG_FILE = "simba-plat-config.xml";
    private final DataClearTask dataClearTask = new DataClearTask();
    private final DataRestoreTask dataRestoreTask = new DataRestoreTask();
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private TwoBFrameServer frameServer;
    private JsonServer jsonServer;
    private final List<String> logHeaders = new LinkedList<String>();
    private final DbPoolInterface mysqlDbPool = new DbPool("simba-mysql-config.xml", "mysql");
    private final String privateKey = "JD-Sorter-Server-2018-09-01";
    private String runMode;
    private int serialNumber;
    private final BoxPackOfferTask slotPackOfferTask = new BoxPackOfferTask();
    private final SorterStatusTask sorterStatusTask = new SorterStatusTask();
    private final SortPlanTask sortPlanTask = new SortPlanTask();
    private final SortResultOfferTask sortResultOfferTask = new SortResultOfferTask();
    private final ColorLightTask colorLightTask = new ColorLightTask();

    public static ServerManager getInstance() {
        return instance;
    }

    private ServerManager() {
    }

    public DataRestoreTask getDataRestoreTask() {
        return this.dataRestoreTask;
    }

    public SimpleDateFormat getDateformat() {
        return this.dateFormat;
    }

    public TwoBFrameServer getFrameServer() {
        return this.frameServer;
    }

    public String getPrivatekey() {
        return this.privateKey;
    }

    public String getRunMode() {
        return this.runMode;
    }

    public int getSerialNumber() {
        return this.serialNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document getXmlDocFromFile(File fp) throws Exception {
        Document xmlDoc = null;
        try {
            SAXBuilder builder = null;
            String driver = "org.apache.crimson.parser.XMLReaderImpl";
            builder = new SAXBuilder(new XMLReaderSAX2Factory(false, driver));
            xmlDoc = builder.build(fp);
        }
        catch (Exception ex) {
            if (xmlDoc == null) {
                throw ex;
            }
        }
        return xmlDoc;
    }

    public void init() {
        this.initParam();
        this.initLogHeaders();
        this.initDatabase();
        this.initTransports();
        this.initServerInstance();
        this.initThreadTasks();
        ServerParam.printStartedInfo();
        this.postInitProcess();
    }

    public void setFrameMessageServer(TwoBFrameServer frameSorterServer) {
        this.frameServer = frameSorterServer;
    }

    public void setRunMode(String runMode) {
        this.runMode = runMode;
    }

    public void setSerialNumber(int serialNumber) {
        this.serialNumber = serialNumber;
    }

    protected void initDbPool() {
        this.mysqlDbPool.init(true);
        SQLCommandExecutor.getInstance().setDbPool(this.mysqlDbPool);
    }

    protected void initParam() {
        System.setProperty("java.net.preferIPv4Stack", "true");
        if (this.runMode.equals("debug")) {
            ServerParam.initRootLogger(LOG4J_CONFIG_FILE_DEBUG);
        } else {
            ServerParam.initRootLogger(LOG4J_CONFIG_FILE_VERBOSE);
        }
        ServerParam.initGlobalConfiguration();
    }

    protected void initTransports() {
        this.buildFrameServer();
        this.buildJsonServer();
    }

    private void buildFrameServer() {
        System.out.println("\u3010Server Init\u3011 Starting the tcp server of frame message ...");
        try {
            FrameProcessor frameMessageProcessor = new FrameProcessor(FrameDecoderManager.getInstance(), FrameChannelManager.getInstance());
            FrameChannelHandler handler = new FrameChannelHandler(frameMessageProcessor);
            this.setFrameMessageServer(new TwoBFrameServer(ServerParam.getServerInfo().getDefaultServerAddress(), ServerParam.getServerInfo().getDefaultServerPort(), ServerParam.IO_THREAD_POOL_SIZE, ServerParam.EVENT_THREAD_POOL_SIZE, handler));
            frameMessageProcessor.setLogHeaders(this.logHeaders);
            for (String header : this.logHeaders) {
                FrameChannelManager.getInstance().addHeader(header);
            }
            this.getFrameServer().start();
            String printInfo = "\u3010Server Init\u3011Starting the frame sorter server on: " + this.getFrameServer().getInetSocketAddress().toString();
            System.out.println(printInfo);
            LogUtil.LogInfo(logger, printInfo);
        }
        catch (Exception e) {
            LogUtil.LogError(logger, e.toString());
        }
    }

    private void buildJsonServer() {
        System.out.println("\u3010Server Init\u3011 Starting the json server for service ...");
        try {
            JsonProcessor jsonMessageProcessor = new JsonProcessor(JsonServiceManager.getInstance(), JsonChannelManager.getInstance());
            JsonChannelHandler handler = new JsonChannelHandler(jsonMessageProcessor);
            this.jsonServer = new JsonServer(ServerParam.getServerInfo().getJsonServerAddress(), ServerParam.getServerInfo().getJsonServerPort(), ServerParam.IO_THREAD_POOL_SIZE, ServerParam.EVENT_THREAD_POOL_SIZE, handler);
            this.jsonServer.start();
            String printInfo = "\u3010Server Init\u3011Starting the json server on: " + this.jsonServer.getInetSocketAddress().toString();
            System.out.println(printInfo);
            LogUtil.LogInfo(logger, printInfo);
        }
        catch (Exception e) {
            LogUtil.LogError(logger, e.toString());
        }
    }

    private void initBarcodeManager() {
        BarcodeManager.getInstance().init();
    }

    private void initCommandParams() {
        CommandParams.getInstance().init();
    }

    private void initDatabase() {
        this.initDbPool();
    }

    private void initFrameDecodeManager() {
        FrameDecoderManager.getInstance().init();
    }

    private void initJsonServiceManager() {
        JsonServiceManager.getInstance().init();
    }

    private void initLogHeaders() {
        try {
            Document rootDoc = ServerManager.getInstance().getXmlDocFromFile(new File("etc" + GlobalParam.PATH_SEP + LOG_HEADERS_CONFIG_FILE));
            Element root = rootDoc.getRootElement();
            Element headersElement = root.getChild("Headers");
            List<Element> headers = headersElement.getChildren();
            for (Element element : headers) {
                String value = element.getAttributeValue("value");
                this.logHeaders.add(value);
            }
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Send headers init error : " + ex.getMessage(), 2));
        }
    }

    private void initMachineParameters() {
        MachineParams.getInstance().loadBasicConfig();
    }

    private void initPlatInstanceManager() {
        PlatManager.getInstance().init(PLAT_CONFIG_FILE);
    }

    private void initPrinterManager() {
        PrinterInfoManager.getInstance().loadPrinters();
    }

    private void initScreenManager() {
        ScreenInfoManager.getInstance().loadScreens();
        ScreenInfoManager.getInstance().initScreenJSonFile();
    }

    private void initClientManager() {
        DefaultClientManager.getInstance().init(CLIENT_CONFIG_FILE);
    }

    private void initServerInstance() {
        this.initFrameDecodeManager();
        this.initJsonServiceManager();
        this.initCommandParams();
        this.initPlatInstanceManager();
        this.initSorterParameters();
        this.initMachineParameters();
        this.initScreenManager();
        this.initPrinterManager();
        this.initSlotManager();
        this.initSortControllerManager();
        this.initSortCommandManager();
        this.initBarcodeManager();
        this.initClientBootstrap();
        this.initClientManager();
    }

    private void initSlotManager() {
        SlotManager.getInstance().init();
    }

    private void initSortCommandManager() {
        SortProtocolCreator.getInstance().init();
    }

    private void initSortControllerManager() {
        SortControllerManager.getInstance().init();
    }

    private void initSorterParameters() {
        SorterParams.getInstance().init();
    }

    private void initSortPlanManager() {
        SortPlanManager.getInstance().init();
    }

    private void initThreadTasks() {
        this.dataClearTask.start();
        this.dataRestoreTask.start();
        this.slotPackOfferTask.start();
        this.sortResultOfferTask.start();
        this.sorterStatusTask.start();
        this.sortPlanTask.start();
    }

    private void postInitProcess() {
        FrameDecoderManager.getInstance().postInitProcess();
        JsonServiceManager.getInstance().postInitProcess();
        PlatManager.getInstance().postInitProcess();
        SlotManager.getInstance().postInitProcess();
        this.whenInitProcessEnd();
    }

    private void initClientBootstrap() {
        DefaultBootstrapManager.getInstance().init();
    }

    private void whenInitProcessEnd() {
    }
}

