/*
 * Decompiled with CFR 0.152.
 */
package com.simba.common.jsonserver.netty;

import com.simba.common.frameserver.netty.FrameReadBytesDecoder;
import java.util.concurrent.ExecutorService;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.ChannelUpstreamHandler;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.handler.codec.frame.LengthFieldBasedFrameDecoder;
import org.jboss.netty.handler.codec.frame.LengthFieldPrepender;
import org.jboss.netty.handler.execution.ExecutionHandler;
import org.jboss.netty.handler.stream.ChunkedWriteHandler;

public class JsonPipelineFactory
implements ChannelPipelineFactory {
    protected static final int MAX_FRAME_LENGTH = 65535;
    private static final int LENGTH_FIELD_OFFSET = 0;
    private static final int LENGTH_FIELD_SIZE = 4;
    protected final ExecutorService executor;
    protected final ChannelUpstreamHandler handler;

    public JsonPipelineFactory(ExecutorService executor, ChannelUpstreamHandler handler) {
        this.executor = executor;
        this.handler = handler;
    }

    @Override
    public ChannelPipeline getPipeline() throws Exception {
        ChannelPipeline pipeline = Channels.pipeline();
        pipeline.addLast("frameLengthDecoder", new LengthFieldBasedFrameDecoder(65535, 0, 4, 0, 4));
        pipeline.addLast("bytesReadDecoder", new FrameReadBytesDecoder());
        pipeline.addLast("frameEncoder", new LengthFieldPrepender(4));
        pipeline.addLast("chunkedWriter", new ChunkedWriteHandler());
        if (this.executor != null) {
            pipeline.addLast("executor", new ExecutionHandler(this.executor));
        }
        pipeline.addLast("handler", this.handler);
        return pipeline;
    }
}

