/*
 * Decompiled with CFR 0.152.
 */
package com.simba.common.command;

import com.simba.common.command.ICommand;
import com.simba.common.command.ICommandExecutor;
import com.simba.common.log.Log4jLogger;
import com.simba.common.log.LogTask;
import com.simba.common.log.LoggerExecutor;
import java.io.IOException;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.log4j.Logger;

public class WebCommandExecutor
implements ICommandExecutor {
    private static final Logger logger = Logger.getLogger(WebCommandExecutor.class);
    private static final int REQUEST_CONNECT_TIMEOUT = 10000;
    private static final int REQUEST_READ_SOCKET_TIME = 10000;
    private final PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
    private CloseableHttpClient httpClient;
    private RequestConfig requestConfig;

    public static WebCommandExecutor getInstance() {
        return CmdExecutorHolder.INSTANCE;
    }

    private WebCommandExecutor() {
    }

    public CloseableHttpResponse doHttpServiceByGet(HttpGet getRequest) throws ClientProtocolException, IOException {
        CloseableHttpResponse response = this.httpClient.execute(getRequest);
        return response;
    }

    public CloseableHttpResponse doHttpServiceByPost(HttpPost postRequest) throws ClientProtocolException, IOException {
        CloseableHttpResponse response = this.httpClient.execute(postRequest);
        return response;
    }

    @Override
    public Boolean executeCmd(ICommand command) {
        Boolean ret = false;
        if (command == null) {
            return ret;
        }
        String name = command.getName();
        try {
            ret = command.run(null);
            if (!ret.booleanValue()) {
                LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Command Executed Failed : " + name, 3));
            }
        }
        catch (Exception e) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), name + " request sort info from web interface error: " + e.getMessage(), 2));
            ret = false;
        }
        return ret;
    }

    public void init() {
        this.initHttpClient();
    }

    private void initHttpClient() {
        this.connectionManager.setMaxTotal(600);
        this.connectionManager.setDefaultMaxPerRoute(200);
        this.requestConfig = RequestConfig.custom().setConnectTimeout(10000).setSocketTimeout(10000).build();
        this.httpClient = HttpClients.custom().setConnectionManager(this.connectionManager).setDefaultRequestConfig(this.requestConfig).build();
    }

    private static class CmdExecutorHolder {
        private static WebCommandExecutor INSTANCE = new WebCommandExecutor();

        private CmdExecutorHolder() {
        }
    }
}

