/*
 * Decompiled with CFR 0.152.
 */
package com.simba.common;

import com.simba.common.InetAddressHelper;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;

public class DefaultServerInfo {
    protected static final String COLON = ":";
    private String availableIpAddress = "";
    private String delimiterServerAddress = "*";
    private int delimiterServerPort = 8580;
    private String frameServerAddress = "*";
    private int frameServerPort = 8686;
    private String httpServerAddress = "*";
    private int httpServerPort = 8080;
    private String jsonServerAddress = "*";
    private int jsonServerPort = 8680;

    public String getAvailableDefaultServerAddress() {
        return this.frameServerAddress.equals("*") ? this.getAvailableIpAddress() : this.frameServerAddress;
    }

    public String getAvailableHttpInfoServerAddress() {
        return this.httpServerAddress.equals("*") ? this.getAvailableIpAddress() : this.httpServerAddress;
    }

    public String getAvailableJsonInfoServerAddress() {
        return this.jsonServerAddress.equals("*") ? this.getAvailableIpAddress() : this.jsonServerAddress;
    }

    public String getDefaultServerAddress() {
        return this.frameServerAddress;
    }

    public int getDefaultServerPort() {
        return this.frameServerPort;
    }

    public String getDelimiterServerAddress() {
        return this.delimiterServerAddress;
    }

    public int getDelimiterServerPort() {
        return this.delimiterServerPort;
    }

    public String getHttpServerAddress() {
        return this.httpServerAddress;
    }

    public int getHttpServerPort() {
        return this.httpServerPort;
    }

    public String getJsonServerAddress() {
        return this.jsonServerAddress;
    }

    public int getJsonServerPort() {
        return this.jsonServerPort;
    }

    public void setDefaultServerAddress(String frameServerAddress) {
        this.frameServerAddress = frameServerAddress;
    }

    public void setDefaultServerPort(int frameServerPort) {
        this.frameServerPort = frameServerPort;
    }

    public void setDelimiterServerAddress(String delimiterServerAddress) {
        this.delimiterServerAddress = delimiterServerAddress;
    }

    public void setDelimiterServerPort(int delimiterServerPort) {
        this.delimiterServerPort = delimiterServerPort;
    }

    public void setHttpServerAddress(String httpServerAddress) {
        this.httpServerAddress = httpServerAddress;
    }

    public void setHttpServerPort(int httpServerPort) {
        this.httpServerPort = httpServerPort;
    }

    public void setJsonServerAddress(String httpServerAddress) {
        this.jsonServerAddress = httpServerAddress;
    }

    public void setJsonServerPort(int httpServerPort) {
        this.jsonServerPort = httpServerPort;
    }

    protected String getAvailableIpAddress() {
        if (this.availableIpAddress.length() == 0) {
            String address = "127.0.0.1";
            try {
                Enumeration<NetworkInterface> nie = NetworkInterface.getNetworkInterfaces();
                while (nie.hasMoreElements()) {
                    NetworkInterface ni = nie.nextElement();
                    Enumeration<InetAddress> iae = ni.getInetAddresses();
                    while (iae.hasMoreElements()) {
                        InetAddress ia = iae.nextElement();
                        String hostAddress = ia.getHostAddress();
                        if (hostAddress.indexOf(COLON) != -1 || hostAddress.equals("127.0.0.1")) continue;
                        if (!InetAddressHelper.isInnerIP(hostAddress)) {
                            address = hostAddress;
                            break;
                        }
                        address = hostAddress;
                    }
                    if (InetAddressHelper.isInnerIP(address)) continue;
                    break;
                }
            }
            catch (Exception ex) {
                address = "127.0.0.1";
            }
            this.availableIpAddress = address;
        }
        return this.availableIpAddress;
    }
}

