/*
 * Decompiled with CFR 0.152.
 */
package org.logicalcobwebs.proxool.admin;

import java.util.Calendar;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.logicalcobwebs.concurrent.WriterPreferenceReadWriteLock;
import org.logicalcobwebs.proxool.ProxoolException;
import org.logicalcobwebs.proxool.admin.CompositeStatisticsListener;
import org.logicalcobwebs.proxool.admin.Statistics;

class StatsRoller {
    private static final Log LOG = LogFactory.getLog(StatsRoller.class);
    private WriterPreferenceReadWriteLock readWriteLock = new WriterPreferenceReadWriteLock();
    private Statistics completeStatistics;
    private Statistics currentStatistics;
    private Calendar nextRollDate;
    private int period;
    private int units;
    private boolean running = true;
    private CompositeStatisticsListener compositeStatisticsListener;
    private String alias;

    public StatsRoller(String alias, CompositeStatisticsListener compositeStatisticsListener, String token) throws ProxoolException {
        this.alias = alias;
        this.compositeStatisticsListener = compositeStatisticsListener;
        this.nextRollDate = Calendar.getInstance();
        if (token.endsWith("s")) {
            this.units = 13;
            this.nextRollDate.clear(13);
            this.nextRollDate.clear(14);
        } else if (token.endsWith("m")) {
            this.units = 12;
            this.nextRollDate.clear(12);
            this.nextRollDate.clear(13);
            this.nextRollDate.clear(14);
        } else if (token.endsWith("h")) {
            this.nextRollDate.clear(11);
            this.nextRollDate.clear(12);
            this.nextRollDate.clear(13);
            this.nextRollDate.clear(14);
            this.units = 11;
        } else if (token.endsWith("d")) {
            this.units = 5;
            this.nextRollDate.clear(11);
            this.nextRollDate.clear(12);
            this.nextRollDate.clear(13);
            this.nextRollDate.clear(14);
        } else {
            throw new ProxoolException("Unrecognised suffix in statistics: " + token);
        }
        this.period = Integer.parseInt(token.substring(0, token.length() - 1));
        Calendar now = Calendar.getInstance();
        while (this.nextRollDate.before(now)) {
            this.nextRollDate.add(this.units, this.period);
        }
        LOG.debug("Collecting first statistics for '" + token + "' at " + this.nextRollDate.getTime());
        this.currentStatistics = new Statistics(now.getTime());
        Thread t = new Thread(){

            public void run() {
                while (StatsRoller.this.running) {
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException e) {
                        LOG.debug("Interruption", e);
                    }
                    StatsRoller.this.roll();
                }
            }
        };
        t.setDaemon(true);
        t.start();
    }

    protected void cancel() {
        this.running = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void roll() {
        if (!this.isCurrent()) {
            try {
                this.readWriteLock.writeLock().acquire();
                if (!this.isCurrent()) {
                    this.currentStatistics.setStopDate(this.nextRollDate.getTime());
                    this.completeStatistics = this.currentStatistics;
                    this.currentStatistics = new Statistics(this.nextRollDate.getTime());
                    this.nextRollDate.add(this.units, this.period);
                    this.compositeStatisticsListener.statistics(this.alias, this.completeStatistics);
                }
            }
            catch (Throwable e) {
                LOG.error("Unable to roll statistics log", e);
            }
            finally {
                this.readWriteLock.writeLock().release();
            }
        }
    }

    private boolean isCurrent() {
        return System.currentTimeMillis() < this.nextRollDate.getTime().getTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectionReturned(long activeTime) {
        this.roll();
        try {
            this.readWriteLock.readLock().acquire();
            this.currentStatistics.connectionReturned(activeTime);
        }
        catch (InterruptedException e) {
            LOG.error("Unable to log connectionReturned", e);
        }
        finally {
            this.readWriteLock.readLock().release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectionRefused() {
        this.roll();
        try {
            this.readWriteLock.readLock().acquire();
            this.currentStatistics.connectionRefused();
        }
        catch (InterruptedException e) {
            LOG.error("Unable to log connectionRefused", e);
        }
        finally {
            this.readWriteLock.readLock().release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Statistics getCompleteStatistics() {
        try {
            this.readWriteLock.readLock().acquire();
            Statistics statistics = this.completeStatistics;
            return statistics;
        }
        catch (InterruptedException e) {
            LOG.error("Couldn't read statistics", e);
            Statistics statistics = null;
            return statistics;
        }
        finally {
            this.readWriteLock.readLock().release();
        }
    }
}

