/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.websocket.serivces;

import com.simba.common.frameserver.FrameChannelManager;
import com.simba.common.log.LogUtil;
import com.simba.common.websocket.service.WebSocketService;
import com.simba.server.components.CommonProtocolDefines;
import com.simba.server.components.FrameUtils;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.Channel;
import org.json.JSONException;
import org.json.JSONObject;

public class WheelSetStatusWebSocketService
implements WebSocketService {
    public static final String NAME = "WheelStatus";
    private static final Logger logger = Logger.getLogger(WheelSetStatusWebSocketService.class);

    @Override
    public void handleRequest(Channel channel, Object content) {
        try {
            JSONObject request = new JSONObject(content.toString());
            String SorterID = request.getString("SorterID");
            String SorterStatus = request.getString("SorterStatus");
            int intSorterID = Integer.valueOf(SorterID);
            int intSorterStatus = Integer.valueOf(SorterStatus);
            LogUtil.LogDebug(logger, "[WheelSetStatusWebSocketService] Change Wheel Status : SorterID:[" + SorterID + "] SorterStatus:[" + SorterStatus + "]");
            this.SubmitOperationToPLC(intSorterID, intSorterStatus);
        }
        catch (JSONException ex) {
            LogUtil.LogError(logger, "[WheelSetStatusWebSocketService] Catch Exception : :" + ex.toString());
        }
    }

    private void SubmitOperationToPLC(int intSorterID, int intSorterStatus) {
        byte[] replyBuffer = new byte[8];
        int position = 0;
        byte[] header = CommonProtocolDefines.REPLY_HEADER;
        System.arraycopy(header, 0, replyBuffer, position, header.length);
        byte[] command = new byte[]{114};
        System.arraycopy(command, 0, replyBuffer, position += header.length, command.length);
        byte[] sorterIdBuf = new byte[2];
        int sorterID = intSorterID;
        FrameUtils.getInstance().setShortBigEndian(0, sorterID, sorterIdBuf);
        System.arraycopy(sorterIdBuf, 0, replyBuffer, position += command.length, sorterIdBuf.length);
        byte[] sysStatusBuf = new byte[]{(byte)intSorterStatus};
        System.arraycopy(sysStatusBuf, 0, replyBuffer, position += sorterIdBuf.length, sysStatusBuf.length);
        byte[] end = CommonProtocolDefines.REPLY_ENDER;
        System.arraycopy(end, 0, replyBuffer, position += sysStatusBuf.length, end.length);
        position += end.length;
        for (Channel channel : FrameChannelManager.getInstance().getChannelList()) {
            FrameChannelManager.getInstance().commitResponse(channel, replyBuffer, false);
        }
    }
}

