/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.websocket;

import com.simba.common.RequestHandler;
import com.simba.common.log.LogUtil;
import com.simba.common.thread.CommonExecutorFactory;
import com.simba.common.thread.CounterThreadFactory;
import com.simba.common.websocket.service.DefaultWebSocketServiceContainer;
import com.simba.common.websocket.service.WebSocketService;
import com.simba.server.websocket.serivces.EchoWebSocketService;
import com.simba.server.websocket.serivces.ErrorWebSocketService;
import com.simba.server.websocket.serivces.HeartbeatWebSocketService;
import com.simba.server.websocket.serivces.UserLoginWebSocketService;
import com.simba.server.websocket.serivces.WheelSetStatusWebSocketService;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.Channel;
import org.json.JSONObject;

public class WebServiceManager
implements RequestHandler {
    public static final String WEBSOCKET_SERVICE_NAME = "ServiceName";
    protected static final Logger logger = Logger.getLogger(WebServiceManager.class);
    private static int ASYNC_WEBSOCKET_EXECUTOR_POOL_SIZE = 4;
    private static final String ASYNC_OPERATION_EXECUTOR_NAME = "WebSocket-Service-Task";
    private Executor asyncWebServiceExecutor;
    private BlockingQueue<Runnable> asyncWebServiceOperationQueue;
    private final DefaultWebSocketServiceContainer container = new DefaultWebSocketServiceContainer();

    public static WebServiceManager getInstance() {
        return WebServiceManagerHolder.INSTANCE;
    }

    private WebServiceManager() {
    }

    @Override
    public void handleRequest(final Channel channel, final Object requestObj) {
        this.runAsyncWebSocketTask(new Runnable(){

            @Override
            public void run() {
                block7: {
                    try {
                        WebSocketService accessor = null;
                        String request = null;
                        try {
                            String receivedMsg = requestObj.toString();
                            request = receivedMsg.substring(receivedMsg.indexOf(40) + 1, receivedMsg.indexOf(41)).replace(" ", "").substring(5);
                            JSONObject requestJSONObject = new JSONObject(request.toString());
                            String serviceName = requestJSONObject.getString(WebServiceManager.WEBSOCKET_SERVICE_NAME);
                            if (serviceName == null) {
                                return;
                            }
                            accessor = WebServiceManager.this.container.getWebSocketService(serviceName);
                            if (accessor == null) {
                                accessor = WebServiceManager.this.container.getWebSocketService(serviceName);
                            }
                        }
                        catch (Exception ex) {
                            accessor = WebServiceManager.this.container.getWebSocketService("ErrorWebSocketService");
                        }
                        if (accessor != null) {
                            accessor.handleRequest(channel, request);
                        }
                    }
                    catch (Exception e) {
                        LogUtil.LogDebug(logger, "Handle WebSocket Request Content is : " + e.getMessage());
                        if (!(e instanceof InterruptedException)) break block7;
                        Thread.currentThread().interrupt();
                    }
                }
            }
        });
    }

    public void init() {
        this.initWebSocketServiceContainer();
        this.initAsyncWebSocketTaskExcutor();
    }

    public void postInitProcess() {
        LogUtil.LogDebug(logger, "[WebSocketServiceManager.postInitProcess] initialize successfully!");
    }

    private void initAsyncWebSocketTaskExcutor() {
        this.asyncWebServiceOperationQueue = new LinkedBlockingQueue<Runnable>();
        this.asyncWebServiceExecutor = CommonExecutorFactory.newFixedThreadPool(ASYNC_WEBSOCKET_EXECUTOR_POOL_SIZE, new CounterThreadFactory(ASYNC_OPERATION_EXECUTOR_NAME), this.asyncWebServiceOperationQueue);
    }

    private void initWebSocketServiceContainer() {
        this.container.addWebSocketService("EchoWebSocketService", new EchoWebSocketService());
        this.container.addWebSocketService("ErrorWebSocketService", new ErrorWebSocketService());
        this.container.addWebSocketService("HeartbeatWebSocket", new HeartbeatWebSocketService());
        this.container.addWebSocketService("UserLogin", new UserLoginWebSocketService());
        this.container.addWebSocketService("WheelStatus", new WheelSetStatusWebSocketService());
    }

    private void runAsyncWebSocketTask(Runnable task) {
        try {
            if (task != null) {
                this.asyncWebServiceExecutor.execute(task);
            }
        }
        catch (Exception e) {
            LogUtil.LogError(logger, "[WebSocketServiceManager] run async task to access WebSocket request failed : " + e.getMessage());
        }
    }

    @Override
    public void onChannelConnected(Channel channel) {
    }

    @Override
    public void onChannelDisconnected(Channel channel) {
    }

    private static class WebServiceManagerHolder {
        private static final WebServiceManager INSTANCE = new WebServiceManager();

        private WebServiceManagerHolder() {
        }
    }
}

