/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.framedecoder.wheel;

import com.simba.common.decoder.Decoder;
import com.simba.common.log.LogUtil;
import com.simba.server.components.FrameUtils;
import com.simba.server.components.SendMsgManager;
import com.simba.server.components.SorterManager;
import com.simba.server.components.data.WheelSorterInfo;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.Channel;
import org.json.JSONObject;

public class WheelStatusDecoder
implements Decoder {
    public static final String NAME = "RockerStatus";
    protected static final Logger logger = Logger.getLogger(WheelStatusDecoder.class);
    private static final int SORTER_NUM_POSITION = 3;
    private static final int SYS_STATUS_POSITION = 5;

    public static WheelStatusDecoder getInstance() {
        return RockerStatusDecoderHolder.INSTANCE;
    }

    private WheelStatusDecoder() {
    }

    @Override
    public void doDecode(Channel channel, Object message) {
        try {
            byte[] content = (byte[])message;
            int sorterID = FrameUtils.getInstance().getUnsignedShortBigEndian(3, content);
            WheelSorterInfo sorterInfo = SorterManager.getInstance().getWheelSorterByID(String.valueOf(sorterID));
            if (sorterInfo == null) {
                return;
            }
            String nowSysStatus = String.valueOf(content[5]);
            String oldSysStatus = sorterInfo.getSorterStatus();
            if (!oldSysStatus.equals(nowSysStatus)) {
                sorterInfo.setSorterStatus(nowSysStatus);
                this.sendToRemote(sorterInfo);
            }
        }
        catch (Exception ex) {
            LogUtil.LogError(logger, "[CarStatus.doDecode] Catch Exception : " + ex.toString());
        }
    }

    @Override
    public String getName() {
        return NAME;
    }

    private void sendToRemote(WheelSorterInfo sorterInfo) {
        JSONObject sendObj = new JSONObject();
        sendObj.put("ServiceName", "WheelStatusChange");
        sendObj.put("SorterStatus", sorterInfo.getSorterStatus());
        sendObj.put("SorterID", sorterInfo.getSorterID());
        SendMsgManager.getInstance().SendToClients(sendObj);
    }

    private static class RockerStatusDecoderHolder {
        private static final WheelStatusDecoder INSTANCE = new WheelStatusDecoder();

        private RockerStatusDecoderHolder() {
        }
    }
}

