/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.framedecoder.wheel;

import com.simba.common.command.ICommand;
import com.simba.common.command.SQLCommandExecutor;
import com.simba.common.decoder.Decoder;
import com.simba.common.frameserver.FrameChannelManager;
import com.simba.common.log.LogUtil;
import com.simba.server.commands.CommandCreator;
import com.simba.server.components.ChannelsManager;
import com.simba.server.components.FrameUtils;
import com.simba.server.components.SendMsgManager;
import com.simba.server.components.SorterManager;
import com.simba.server.components.SorterStatusManager;
import com.simba.server.components.data.WarningInfo;
import com.simba.server.components.data.WheelSorterInfo;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.Channel;
import org.json.JSONObject;

public class WheelKeepAliveDecoder
implements Decoder {
    public static final String NAME = "Wheel-KeepAlive-Decoder";
    protected static final Logger logger = Logger.getLogger(WheelKeepAliveDecoder.class);
    private static final int SORTER_NUM_POSITION = 3;
    private static final int SYS_STATUS_POSITION = 5;
    private static final int SYS_MODEL_POSITION = 6;
    private static final int CAMERA_POSITION = 7;

    public static WheelKeepAliveDecoder getInstance() {
        return RockerKeepAliveDecoderHolder.INSTANCE;
    }

    private WheelKeepAliveDecoder() {
    }

    @Override
    public void doDecode(Channel channel, Object message) {
        try {
            if (!ChannelsManager.getInstance().containsWheelPlcClient(channel)) {
                ChannelsManager.getInstance().addWheelPlcClients(channel);
            } else {
                ChannelsManager.getInstance().updateWheelPlctTime(channel);
            }
            byte[] content = (byte[])message;
            int sorterID = FrameUtils.getInstance().getUnsignedShortBigEndian(3, content);
            WheelSorterInfo wheelSorterInfo = SorterManager.getInstance().getWheelSorterByID(String.valueOf(sorterID));
            if (wheelSorterInfo == null) {
                return;
            }
            byte sorterStatus = content[5];
            byte sorterModel = content[6];
            wheelSorterInfo.setSorterID(String.valueOf(sorterID));
            wheelSorterInfo.setSorterStatus(String.valueOf(sorterStatus));
            wheelSorterInfo.setSorterModel(sorterModel);
            wheelSorterInfo.setObrNum(0);
            wheelSorterInfo.setEmergencyNum(0);
            int cameraNum = FrameUtils.getInstance().getUnsignedShortBigEndian(7, content);
            int cameraPosition = 9;
            String cameraStatus = "";
            for (int i = 1; i <= cameraNum; ++i) {
                byte intStatus = content[cameraPosition];
                cameraStatus = cameraStatus + intStatus + ",";
                ++cameraPosition;
            }
            if (cameraStatus.length() >= 2) {
                cameraStatus = cameraStatus.substring(0, cameraStatus.length() - 1);
                wheelSorterInfo.setObrNum(cameraNum);
                wheelSorterInfo.setObrStatus(cameraStatus);
            }
            String emergencyStatus = "";
            int emergencyNumPosition = cameraPosition;
            int emergencyPosition = emergencyNumPosition + 2;
            int emergencyNum = FrameUtils.getInstance().getUnsignedShortBigEndian(emergencyNumPosition, content);
            for (int i = 1; i <= emergencyNum; ++i) {
                byte intStatus = content[emergencyPosition];
                this.HandleEmergencyNotify(i + "", intStatus + "");
                emergencyStatus = emergencyStatus + intStatus + ",";
                ++emergencyPosition;
            }
            if (emergencyStatus.length() >= 2) {
                emergencyStatus = emergencyStatus.substring(0, emergencyStatus.length() - 1);
                wheelSorterInfo.setEmergencyNum(emergencyNum);
                wheelSorterInfo.setEmergencyStatus(emergencyStatus);
            }
            this.sendToRemote(wheelSorterInfo);
            this.sendContentEchoToPLC(content);
        }
        catch (Exception ex) {
            LogUtil.LogError(logger, "[WheelKeepAliveDecoder.doDecode] Catch Exception : " + ex.toString());
        }
    }

    private void HandleEmergencyNotify(String statusSN, String strStatus) {
        String oldStatus;
        if (SorterStatusManager.getInstance().CheckWheelEmergencyStatusIsAvailable(statusSN) && !(oldStatus = SorterStatusManager.getInstance().getWheelEmergency(statusSN)).equals(strStatus)) {
            if (oldStatus.equals("0")) {
                JSONObject sendObj = new JSONObject();
                sendObj.put("ServiceName", "Notify");
                sendObj.put("Message", statusSN + "\u53f7\u6025\u505c\u88ab\u6441\u4e0b");
                SendMsgManager.getInstance().SendToClients(sendObj);
                WarningInfo warningInfo = new WarningInfo();
                warningInfo.setLevel(3);
                warningInfo.setModule("Emergency");
                warningInfo.setModuleId(Integer.valueOf(statusSN));
                warningInfo.setMessage(statusSN + "\u53f7\u6025\u505c\u88ab\u6441\u4e0b");
                ICommand command = CommandCreator.getInstance().createCommand("RecordWarningInfoCmd", warningInfo);
                boolean res = SQLCommandExecutor.getInstance().executeCmd(command);
                if (!res) {
                    LogUtil.LogDebug(logger, statusSN + "\u53f7\u6025\u505c\u88ab\u6441\u4e0b");
                    return;
                }
            } else {
                JSONObject sendObj = new JSONObject();
                sendObj.put("ServiceName", "Notify");
                sendObj.put("Message", statusSN + "\u53f7\u6025\u505c\u6062\u590d\u6b63\u5e38");
                SendMsgManager.getInstance().SendToClients(sendObj);
                WarningInfo warningInfo = new WarningInfo();
                warningInfo.setLevel(1);
                warningInfo.setModule("Emergency");
                warningInfo.setModuleId(Integer.valueOf(statusSN));
                warningInfo.setMessage(statusSN + "\u53f7\u6025\u505c\u6062\u590d\u6b63\u5e38");
                ICommand command = CommandCreator.getInstance().createCommand("RecordWarningInfoCmd", warningInfo);
                boolean res = SQLCommandExecutor.getInstance().executeCmd(command);
                if (!res) {
                    LogUtil.LogDebug(logger, statusSN + "\u53f7\u6025\u505c\u6062\u590d\u6b63\u5e38");
                    return;
                }
            }
        }
        SorterStatusManager.getInstance().addWheelEmergency(statusSN, strStatus);
    }

    private void sendToRemote(WheelSorterInfo wheelSorterInfo) {
        JSONObject sendObj = new JSONObject();
        sendObj.put("ServiceName", "WheelStatus");
        sendObj.put("SorterID", wheelSorterInfo.getSorterID());
        sendObj.put("SorterStatus", wheelSorterInfo.getSorterStatus());
        sendObj.put("SorterModel", wheelSorterInfo.getSorterModel());
        sendObj.put("EmergencyStatus", wheelSorterInfo.getEmergencyStatus());
        sendObj.put("OBRStatus", wheelSorterInfo.getObrStatus());
        SendMsgManager.getInstance().SendToClients(sendObj);
    }

    @Override
    public String getName() {
        return NAME;
    }

    public void sendContentEchoToPLC(byte[] content) {
        Channel[] channels;
        if (content == null || content.length < 2) {
            return;
        }
        content[0] = 3;
        content[1] = 1;
        for (Channel channel : channels = FrameChannelManager.getInstance().getChannelList()) {
            FrameChannelManager.getInstance().commitResponse(channel, content, false);
        }
    }

    private static class RockerKeepAliveDecoderHolder {
        private static final WheelKeepAliveDecoder INSTANCE = new WheelKeepAliveDecoder();

        private RockerKeepAliveDecoderHolder() {
        }
    }
}

