/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.framedecoder.wheel;

import com.simba.common.decoder.Decoder;
import com.simba.common.frameserver.FrameChannelManager;
import com.simba.common.log.LogUtil;
import com.simba.common.utils.FrameUtils;
import com.simba.server.components.ChannelsManager;
import com.simba.server.components.CommonProtocolDefines;
import com.simba.server.components.SendMsgManager;
import com.simba.server.components.SortProtocolCreator;
import com.simba.server.components.SorterManager;
import com.simba.server.components.WheelSortInfoManager;
import com.simba.server.components.data.WheelSortInfo;
import com.simba.server.components.data.WheelSorterInfo;
import java.sql.Timestamp;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.Channel;
import org.json.JSONObject;

public class TestWheelPacketOnDecoder
implements Decoder {
    public static final String NAME = "TestWheelPacketOnDecoder";
    protected static final Logger logger = Logger.getLogger(TestWheelPacketOnDecoder.class);
    private static final int SORTER_NUM_POSITION = 3;
    private static final int STR_CONTENT_BEGIN_POSITION = 5;
    private static final int STR_CONTENT_END_POSITION = 2;
    private static final int PLC_POSITION = 0;
    private static final int PLC_LEN = 17;
    private static final int EDGE_LENGTH = 4;
    private static final int VOLUME_LENGTH = 7;

    public static TestWheelPacketOnDecoder getInstance() {
        return TestRockerPacketOnDecoderHolder.INSTANCE;
    }

    private TestWheelPacketOnDecoder() {
    }

    @Override
    public void doDecode(Channel channel, Object message) {
        try {
            if (!ChannelsManager.getInstance().containsWheelPlcClient(channel)) {
                ChannelsManager.getInstance().addWheelPlcClients(channel);
            } else {
                ChannelsManager.getInstance().updateWheelPlctTime(channel);
            }
            byte[] content = (byte[])message;
            int sorterID = FrameUtils.getInstance().getUnsignedShortBigEndian(3, content);
            WheelSorterInfo wheelSorterInfo = SorterManager.getInstance().getWheelSorterByID(String.valueOf(sorterID));
            if (wheelSorterInfo == null) {
                return;
            }
            byte[] plcIdBuffer = new byte[17];
            System.arraycopy(content, 5, plcIdBuffer, 0, 17);
            int contentLen = content.length;
            String strContent = new String(content, 5, contentLen - 2 - 5, "UTF-8");
            int plcIdLen = 17;
            int plcIdPosition = 0;
            String plcId = strContent.substring(plcIdPosition, plcIdLen);
            int handPosition = plcIdLen + plcIdPosition;
            String packageLength = strContent.substring(handPosition, handPosition + 4);
            String packageWidth = strContent.substring(handPosition += 4, handPosition + 4);
            String packageHeight = strContent.substring(handPosition += 4, handPosition + 4);
            String packageVolume = strContent.substring(handPosition += 4, handPosition + 7);
            handPosition += 7;
            WheelSortInfo wheelSortInfo = WheelSortInfoManager.getInstance().createSortInfo();
            wheelSortInfo.setPlcId(plcId);
            wheelSortInfo.setPlcLdBuf(plcIdBuffer);
            wheelSortInfo.setSorterID(String.valueOf(sorterID));
            wheelSortInfo.setPackageLength(packageLength);
            wheelSortInfo.setPackageWidth(packageWidth);
            wheelSortInfo.setPackageHeight(packageHeight);
            wheelSortInfo.setPackageVolume(packageVolume);
            String strBarcodeNumber = strContent.substring(handPosition, handPosition + 2);
            int barcodeNumber = Integer.valueOf(strBarcodeNumber);
            handPosition += 2;
            for (int i = 0; i < barcodeNumber; ++i) {
                String strBarcodeLen = strContent.substring(handPosition += 2, handPosition + 2);
                int barcodeLen = Integer.valueOf(strBarcodeLen);
                String barcode = strContent.substring(handPosition += 2, handPosition + barcodeLen);
                wheelSortInfo.setBarcode(barcode);
                wheelSortInfo.getBarcodeList().add(barcode);
                handPosition += barcodeLen;
            }
            Timestamp packetOnTime = SortProtocolCreator.getInstance().createCurrentTimeStamp();
            wheelSortInfo.setPacketOnTime(packetOnTime);
            this.serverSlotGenerate(wheelSortInfo);
            WheelSortInfoManager.getInstance().addSortInfo(wheelSortInfo);
            this.sendToPlc(channel, wheelSorterInfo, wheelSortInfo);
            this.sendToRemote(wheelSorterInfo, wheelSortInfo);
            this.recordSortResult(wheelSortInfo);
        }
        catch (Exception ex) {
            LogUtil.LogError(logger, "[TestWheelPacketOnDecoder.doDecode] Catch Exception : " + ex.toString());
        }
    }

    private void sendToPlc(Channel channel, WheelSorterInfo wheelSorterInfo, WheelSortInfo wheelSortInfo) {
        byte[] sortResultBuffer = null;
        sortResultBuffer = this.createSortResultBuffer(wheelSorterInfo, wheelSortInfo);
        FrameChannelManager.getInstance().commitResponse(channel, sortResultBuffer, false);
    }

    private byte[] createSortResultBuffer(WheelSorterInfo wheelSorterInfo, WheelSortInfo wheelSortInfo) {
        byte[] replyBuffer = null;
        byte[] plcIdBuf = wheelSortInfo.getPlcLdBuf();
        int plcIdLen = 0;
        if (plcIdBuf != null) {
            plcIdLen = plcIdBuf.length;
        }
        int bufferSize = plcIdLen + 1 + 8;
        replyBuffer = new byte[bufferSize];
        int position = 0;
        byte[] header = CommonProtocolDefines.REPLY_HEADER;
        System.arraycopy(header, 0, replyBuffer, position, header.length);
        byte[] command = new byte[]{4};
        System.arraycopy(command, 0, replyBuffer, position += header.length, command.length);
        byte[] sorterIdBuf = new byte[2];
        int wheelSorterId = Integer.valueOf(wheelSorterInfo.getSorterID());
        FrameUtils.getInstance().setShortBigEndian(0, wheelSorterId, sorterIdBuf);
        System.arraycopy(sorterIdBuf, 0, replyBuffer, position += command.length, sorterIdBuf.length);
        int slotId = wheelSortInfo.getServerSlotId();
        byte[] slotLockStatus = new byte[]{(byte)slotId};
        System.arraycopy(slotLockStatus, 0, replyBuffer, position += sorterIdBuf.length, slotLockStatus.length);
        byte[] plcIdLenBuf = new byte[]{(byte)plcIdLen};
        System.arraycopy(plcIdLenBuf, 0, replyBuffer, position += slotLockStatus.length, plcIdLenBuf.length);
        position += plcIdLenBuf.length;
        if (plcIdLen > 0) {
            System.arraycopy(plcIdBuf, 0, replyBuffer, position, plcIdBuf.length);
            position += plcIdBuf.length;
        }
        byte[] replayEnd = CommonProtocolDefines.REPLY_ENDER;
        System.arraycopy(replayEnd, 0, replyBuffer, position, replayEnd.length);
        position += replayEnd.length;
        return replyBuffer;
    }

    private void serverSlotGenerate(WheelSortInfo wheelSortInfo) {
        int min = 1;
        int max = 4;
        int num = min + (int)(Math.random() * (double)(max - min + 1));
        wheelSortInfo.setServerSlotId(num);
        String barcode = wheelSortInfo.getBarcode().toLowerCase();
        if (barcode.endsWith("noread")) {
            wheelSortInfo.setServerSlotId(99);
            return;
        }
        int slot = Integer.valueOf(TestWheelPacketOnDecoder.getLastPlateNum(wheelSortInfo.getBarcode()));
        wheelSortInfo.setServerSlotId(slot);
    }

    private static String getLastPlateNum(String plate_no) {
        String lastNum;
        try {
            boolean ret;
            int i = 0;
            while (!(ret = TestWheelPacketOnDecoder.isNum(lastNum = plate_no.substring(plate_no.length() - (i + 1), plate_no.length() - i)))) {
                ++i;
            }
        }
        catch (Exception ex) {
            lastNum = "99";
        }
        return lastNum;
    }

    private static boolean isNum(String str) {
        Pattern pattern = Pattern.compile("[0-9]*");
        Matcher isNum = pattern.matcher(str);
        return isNum.matches();
    }

    private void sendToRemote(WheelSorterInfo wheelSorterInfo, WheelSortInfo wheelSortInfo) {
        JSONObject sendObj = new JSONObject();
        sendObj.put("ServiceName", "WheelPacketOn");
        sendObj.put("SorterID", wheelSorterInfo.getSorterID());
        sendObj.put("Barcode", wheelSortInfo.getBarcode());
        sendObj.put("ServerSlotId", wheelSortInfo.getServerSlotId());
        sendObj.put("PlcID", wheelSortInfo.getPlcId());
        sendObj.put("TimeStamp", Long.toString(System.currentTimeMillis()));
        SendMsgManager.getInstance().SendToClients(sendObj);
    }

    private void recordSortResult(WheelSortInfo sortInfo) {
        try {
            StringBuilder info = new StringBuilder(256);
            info.append("[Key:TestWheelPacketOnDecoder],");
            info.append("[SorterID:").append(sortInfo.getSorterID()).append("],");
            info.append("[Barcode:").append(sortInfo.getBarcode()).append("],");
            info.append("[BarcodeList:").append(sortInfo.getBarcodeList()).append("],");
            info.append("[PlcID:").append(sortInfo.getPlcId()).append("],");
            info.append("[ServerSlotId:").append(sortInfo.getServerSlotId()).append("]");
            String content = info.toString();
            LogUtil.LogDebug(logger, content);
        }
        catch (Exception ex) {
            LogUtil.LogError(logger, "[PacketOffDecoder.recordSortResult] Error:" + ex.getMessage());
        }
    }

    @Override
    public String getName() {
        return NAME;
    }

    private static class TestRockerPacketOnDecoderHolder {
        private static final TestWheelPacketOnDecoder INSTANCE = new TestWheelPacketOnDecoder();

        private TestRockerPacketOnDecoderHolder() {
        }
    }
}

