/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.framedecoder.wheel;

import com.simba.common.command.ICommand;
import com.simba.common.command.SQLCommandExecutor;
import com.simba.common.decoder.Decoder;
import com.simba.common.frameserver.FrameChannelManager;
import com.simba.common.log.LogUtil;
import com.simba.common.utils.FrameUtils;
import com.simba.server.commands.CommandCreator;
import com.simba.server.components.ChannelsManager;
import com.simba.server.components.SendMsgManager;
import com.simba.server.components.SorterManager;
import com.simba.server.components.WheelSortInfoManager;
import com.simba.server.components.data.WheelSortInfo;
import com.simba.server.components.data.WheelSorterInfo;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.Channel;
import org.json.JSONObject;

public class TestWheelPacketOffDecoder
implements Decoder {
    public static final String NAME = "TestWheelPacketOffDecoder";
    protected static final Logger logger = Logger.getLogger(TestWheelPacketOffDecoder.class);
    private static final int SORTER_NUM_POSITION = 3;
    private static final int PACKET_OFF_SLOT_POSITION = 5;
    private static final int STR_CONTEN_BEGIN_POSITION = 6;
    private static final int STR_CONTEN_END_POSITION = 2;
    private static final int PLC_LEN = 17;
    private static final int PLC_POSITION = 0;

    public static TestWheelPacketOffDecoder getInstance() {
        return TestRockerPacketOffDecoderHolder.INSTANCE;
    }

    private TestWheelPacketOffDecoder() {
    }

    @Override
    public void doDecode(Channel channel, Object message) {
        try {
            if (!ChannelsManager.getInstance().containsWheelPlcClient(channel)) {
                ChannelsManager.getInstance().addWheelPlcClients(channel);
            } else {
                ChannelsManager.getInstance().updateWheelPlctTime(channel);
            }
            byte[] content = (byte[])message;
            int sorterID = FrameUtils.getInstance().getUnsignedShortBigEndian(3, content);
            WheelSorterInfo wheelSorterInfo = SorterManager.getInstance().getWheelSorterByID(String.valueOf(sorterID));
            if (wheelSorterInfo == null) {
                return;
            }
            byte droppedSlotId = content[5];
            int contentLen = content.length;
            String strContent = new String(content, 6, contentLen - 2 - 6, "UTF-8");
            int plcIdLen = 17;
            int plcIdPosition = 0;
            String plcId = strContent.substring(plcIdPosition, plcIdLen);
            WheelSortInfo wheelSortInfo = WheelSortInfoManager.getInstance().getSortInfo(plcId);
            if (wheelSortInfo == null) {
                LogUtil.LogDebug(logger, "[TestWheelPacketOnDecoder] PacketOn No found! PLC ID:" + plcId);
                try {
                    wheelSortInfo = WheelSortInfoManager.getInstance().createSortInfo();
                    Date dNow = new Date();
                    SimpleDateFormat ft = new SimpleDateFormat("yyyyMMddhhmmssSSS");
                    wheelSortInfo.setPlcId(ft.format(dNow));
                    wheelSortInfo.setPlcLdBuf(null);
                    wheelSortInfo.setSorterID(String.valueOf(sorterID));
                    wheelSortInfo.setPackageLength("123");
                    wheelSortInfo.setPackageWidth("456");
                    wheelSortInfo.setPackageHeight("789");
                    wheelSortInfo.setPackageVolume("1234567");
                }
                catch (Exception dNow) {
                    // empty catch block
                }
            }
            wheelSortInfo.setDroppedSlotId(droppedSlotId);
            this.sendToRemote(wheelSorterInfo, wheelSortInfo);
            FrameChannelManager.getInstance().commitResponse(channel, content, false);
            ICommand command = CommandCreator.getInstance().createCommand("TestRecordPacketOffCmd", wheelSortInfo);
            boolean ret = SQLCommandExecutor.getInstance().executeCmd(command);
            if (!ret) {
                LogUtil.LogError(logger, "[TestWheelPacketOffDecoder] inster err! :" + wheelSortInfo.toString());
            }
            this.recordSortResult(wheelSortInfo);
            WheelSortInfoManager.getInstance().removeSortInfo(plcId);
        }
        catch (Exception ex) {
            LogUtil.LogError(logger, "[TestWheelPacketOffDecoder.doDecode] Catch Exception : " + ex.toString());
        }
    }

    private void sendToRemote(WheelSorterInfo wheelSorterInfo, WheelSortInfo wheelSortInfo) {
        JSONObject sendObj = new JSONObject();
        sendObj.put("ServiceName", "WheelPacketOff");
        sendObj.put("SorterID", wheelSorterInfo.getSorterID());
        sendObj.put("Barcode", wheelSortInfo.getBarcode());
        sendObj.put("DroppedSlotID", wheelSortInfo.getDroppedSlotId());
        sendObj.put("ServerSlotID", wheelSortInfo.getServerSlotId());
        sendObj.put("PlcID", wheelSortInfo.getPlcId());
        sendObj.put("TimeStamp", System.currentTimeMillis());
        SendMsgManager.getInstance().SendToClients(sendObj);
    }

    private void recordSortResult(WheelSortInfo sortInfo) {
        try {
            StringBuilder info = new StringBuilder(256);
            info.append("[Key:SortResult],");
            info.append("[SorterID:").append(sortInfo.getSorterID()).append("],");
            info.append("[Barcode:").append(sortInfo.getBarcode()).append("],");
            info.append("[BarcodeList:").append(sortInfo.getBarcodeList()).append("],");
            info.append("[PlcID:").append(sortInfo.getPlcId()).append("],");
            info.append("[DroppedSlot:").append(sortInfo.getDroppedSlotId()).append("],");
            info.append("[ServerSlotId:").append(sortInfo.getServerSlotId()).append("],");
            info.append("[DroppedErrorCode:").append(sortInfo.getErrorCodePLC()).append("],");
            info.append("[ServerErrorCode:").append(sortInfo.getErrorCodeSVR()).append("]");
            String content = info.toString();
            LogUtil.LogDebug(logger, content);
        }
        catch (Exception ex) {
            LogUtil.LogError(logger, "[PacketOffDecoder.recordSortResult] Error:" + ex.getMessage());
        }
    }

    @Override
    public String getName() {
        return NAME;
    }

    private static class TestRockerPacketOffDecoderHolder {
        private static final TestWheelPacketOffDecoder INSTANCE = new TestWheelPacketOffDecoder();

        private TestRockerPacketOffDecoderHolder() {
        }
    }
}

