/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.framedecoder.decoders;

import com.simba.common.decoder.Decoder;
import com.simba.common.log.LogUtil;
import com.simba.server.components.FrameUtils;
import com.simba.server.components.SendMsgManager;
import com.simba.server.components.SorterManager;
import com.simba.server.components.data.CrossSorterInfo;
import java.net.InetSocketAddress;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.Channel;
import org.json.JSONObject;

public class MachineStatusDecoder
implements Decoder {
    public static final String NAME = "MachineStatus";
    protected static final Logger logger = Logger.getLogger(MachineStatusDecoder.class);
    private static final int SORTER_STATUS = 3;
    private static final int SORTER_MODEL = 4;
    private static final int SORTER_SPEED = 5;

    public static MachineStatusDecoder getInstance() {
        return MachineStatusDecoderHolder.INSTANCE;
    }

    private MachineStatusDecoder() {
    }

    @Override
    public void doDecode(Channel channel, Object message) {
        try {
            byte[] content = (byte[])message;
            InetSocketAddress socketAddress = (InetSocketAddress)channel.getRemoteAddress();
            String clientIP = socketAddress.getAddress().getHostAddress();
            CrossSorterInfo crossSorterInfo = SorterManager.getInstance().getCrossSorterByIP(clientIP);
            if (crossSorterInfo == null) {
                return;
            }
            byte sorterStatus = content[3];
            byte sorterModel = content[4];
            int speed = FrameUtils.getInstance().getUnsignedShortBigEndian(5, content);
            double dspeed = speed;
            crossSorterInfo.setSorterStatus(sorterStatus);
            crossSorterInfo.setSorterSpeed(dspeed /= 1000.0);
            crossSorterInfo.setSorterModel(sorterModel);
            this.sendToRemote("", crossSorterInfo);
        }
        catch (Exception ex) {
            LogUtil.LogError(logger, "[MachineStatusDecoder.doDecode] Catch Exception : " + ex.toString());
        }
    }

    @Override
    public String getName() {
        return NAME;
    }

    private void sendToRemote(String strStatus, CrossSorterInfo crossSorterInfo) {
        JSONObject sendObj = new JSONObject();
        sendObj.put("ServiceName", "PlcStatus");
        sendObj.put("Machine", crossSorterInfo.getSorterName());
        sendObj.put("Layer", crossSorterInfo.getSorterLayer());
        sendObj.put("Status", crossSorterInfo.getSorterStatus());
        sendObj.put("Model", crossSorterInfo.getSorterModel());
        sendObj.put("Speed", crossSorterInfo.getSorterSpeed());
        SendMsgManager.getInstance().SendToClients(sendObj);
    }

    private static class MachineStatusDecoderHolder {
        private static final MachineStatusDecoder INSTANCE = new MachineStatusDecoder();

        private MachineStatusDecoderHolder() {
        }
    }
}

