/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.framedecoder.decoders;

import com.simba.common.decoder.Decoder;
import com.simba.common.log.LogUtil;
import com.simba.server.components.FrameUtils;
import com.simba.server.components.SendMsgManager;
import com.simba.server.components.SorterManager;
import com.simba.server.components.data.CrossSorterInfo;
import java.net.InetSocketAddress;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.Channel;
import org.json.JSONObject;

public class CarStatusDecoder
implements Decoder {
    public static final String NAME = "CarStatus";
    protected static final Logger logger = Logger.getLogger(CarStatusDecoder.class);
    private static final int CAR_NUM_POSITION = 3;
    private static final int EACH_CAR_POSITION = 5;

    public static CarStatusDecoder getInstance() {
        return CarStatusDecoderHolder.INSTANCE;
    }

    private CarStatusDecoder() {
    }

    @Override
    public void doDecode(Channel channel, Object message) {
        try {
            InetSocketAddress socketAddress = (InetSocketAddress)channel.getRemoteAddress();
            String clientIP = socketAddress.getAddress().getHostAddress();
            CrossSorterInfo crossSorterInfo = SorterManager.getInstance().getCrossSorterByIP(clientIP);
            if (crossSorterInfo == null) {
                return;
            }
            byte[] content = (byte[])message;
            int totalStatus = FrameUtils.getInstance().getUnsignedShortBigEndian(3, content);
            int position = 5;
            String strStatus = "";
            for (int i = 1; i <= totalStatus; ++i) {
                byte intStatus = content[position];
                strStatus = strStatus + intStatus + ",";
                ++position;
            }
            if (strStatus.length() > 2) {
                strStatus = strStatus.substring(0, strStatus.length() - 1);
                this.sendToRemote(strStatus, crossSorterInfo);
            }
        }
        catch (Exception ex) {
            LogUtil.LogError(logger, "[CarStatus.doDecode] Catch Exception : " + ex.toString());
        }
    }

    @Override
    public String getName() {
        return NAME;
    }

    private void sendToRemote(String strStatus, CrossSorterInfo crossSorterInfo) {
        JSONObject sendObj = new JSONObject();
        sendObj.put("ServiceName", "Car");
        sendObj.put("Machine", crossSorterInfo.getSorterName());
        sendObj.put("Layer", crossSorterInfo.getSorterLayer());
        sendObj.put("Data", strStatus);
        SendMsgManager.getInstance().SendToClients(sendObj);
    }

    private static class CarStatusDecoderHolder {
        private static final CarStatusDecoder INSTANCE = new CarStatusDecoder();

        private CarStatusDecoderHolder() {
        }
    }
}

