/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.components;

import com.simba.common.log.LogUtil;
import com.simba.server.components.data.WheelSortInfo;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

public class WheelSortInfoManager {
    protected static final Logger logger = Logger.getLogger(WheelSortInfoManager.class);
    private final ConcurrentHashMap<String, WheelSortInfo> sortInfoList = new ConcurrentHashMap();

    public static WheelSortInfoManager getInstance() {
        return SortManagerHolder.INSTANCE;
    }

    private WheelSortInfoManager() {
    }

    public void addSortInfo(WheelSortInfo sortInfo) {
        if (sortInfo != null) {
            this.sortInfoList.put(sortInfo.getPlcId(), sortInfo);
        }
    }

    public void clearSortInfoList() {
        this.sortInfoList.clear();
    }

    public boolean containsSortInfo(String key) {
        return this.sortInfoList.containsKey(key);
    }

    public WheelSortInfo createSortInfo() {
        WheelSortInfo sortInfo = new WheelSortInfo();
        sortInfo.setSortingId(this.createSortingId());
        long currentTime = System.currentTimeMillis();
        sortInfo.setCurrentTime(currentTime);
        return sortInfo;
    }

    public WheelSortInfo getSortInfo(String key) {
        return this.sortInfoList.get(key.toLowerCase());
    }

    public int getSortInfoCount() {
        return this.sortInfoList.size();
    }

    public WheelSortInfo[] getSortInfoList() {
        return this.sortInfoList.values().toArray(new WheelSortInfo[0]);
    }

    public WheelSortInfo removeSortInfo(String key) {
        return this.sortInfoList.remove(key);
    }

    private String createSortingId() {
        UUID uuid = UUID.randomUUID();
        long now = System.currentTimeMillis();
        String timeInfo = String.valueOf(now);
        String uuidStr = uuid.toString() + "-" + timeInfo;
        uuidStr = uuidStr.toUpperCase();
        return uuidStr;
    }

    public void handlerOverTimePacketOnInfo() {
        long currentTime = System.currentTimeMillis();
        for (Map.Entry<String, WheelSortInfo> entry : this.sortInfoList.entrySet()) {
            WheelSortInfo info = entry.getValue();
            long packetOnTime = info.getCurrentTime();
            long spanTime = currentTime - packetOnTime;
            if (spanTime <= 1200000L) continue;
            String plcKey = info.getPlcId();
            WheelSortInfoManager.getInstance().removeSortInfo(plcKey);
            LogUtil.LogError(logger, "[WheelSortInfoManager.handlerOverTimePacketOnInfo] Auto remove SortInfo. PLC ID:" + plcKey);
            LogUtil.LogDebug(logger, "[WheelSortInfoManager.handlerOverTimePacketOnInfo] Auto remove SortInfo. PLC ID:" + plcKey);
        }
    }

    private static class SortManagerHolder {
        private static final WheelSortInfoManager INSTANCE = new WheelSortInfoManager();

        private SortManagerHolder() {
        }
    }
}

