/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.components;

import com.simba.common.log.LogUtil;
import com.simba.server.components.data.KeepAliveInfo;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.Channel;

public class ChannelsManager {
    protected static final Logger logger = Logger.getLogger(ChannelsManager.class);
    private final List<KeepAliveInfo> webSocketChannels = new LinkedList<KeepAliveInfo>();
    private final List<KeepAliveInfo> crossPlcChannels = new LinkedList<KeepAliveInfo>();
    private final List<KeepAliveInfo> rockerPlcChannels = new LinkedList<KeepAliveInfo>();
    private final List<KeepAliveInfo> wheelPlcChannels = new LinkedList<KeepAliveInfo>();

    public static ChannelsManager getInstance() {
        return ChannelsManagerHolder.INSTANCE;
    }

    public List<KeepAliveInfo> getWebSocketChannels() {
        return this.webSocketChannels;
    }

    public List<KeepAliveInfo> getCrossPlcChannels() {
        return this.crossPlcChannels;
    }

    public List<KeepAliveInfo> getRockerPlcChannels() {
        return this.rockerPlcChannels;
    }

    public List<KeepAliveInfo> getWheelPlcChannels() {
        return this.wheelPlcChannels;
    }

    public void addWebSocketClients(Channel connection) {
        long now = System.currentTimeMillis();
        this.getWebSocketChannels().add(new KeepAliveInfo(connection, now));
    }

    public void addCrossPlcClients(Channel connection) {
        long now = System.currentTimeMillis();
        this.getCrossPlcChannels().add(new KeepAliveInfo(connection, now));
    }

    public void addRockerPlcClients(Channel connection) {
        long now = System.currentTimeMillis();
        this.getRockerPlcChannels().add(new KeepAliveInfo(connection, now));
    }

    public void addWheelPlcClients(Channel connection) {
        long now = System.currentTimeMillis();
        this.getWheelPlcChannels().add(new KeepAliveInfo(connection, now));
    }

    public void updateWebSocketTime(Channel channel) {
        for (KeepAliveInfo keepAliveInfo : ChannelsManager.getInstance().getWebSocketChannels()) {
            if (keepAliveInfo.getChannel() != channel) continue;
            long now = System.currentTimeMillis();
            keepAliveInfo.setKeepAliveTime(now);
            break;
        }
    }

    public void updateCrossPlcTime(Channel channel) {
        for (KeepAliveInfo keepAliveInfo : ChannelsManager.getInstance().getCrossPlcChannels()) {
            if (keepAliveInfo.getChannel() != channel) continue;
            long now = System.currentTimeMillis();
            keepAliveInfo.setKeepAliveTime(now);
            break;
        }
    }

    public void updateRockerPlcTime(Channel channel) {
        for (KeepAliveInfo keepAliveInfo : ChannelsManager.getInstance().getRockerPlcChannels()) {
            if (keepAliveInfo.getChannel() != channel) continue;
            long now = System.currentTimeMillis();
            keepAliveInfo.setKeepAliveTime(now);
            break;
        }
    }

    public void updateWheelPlctTime(Channel channel) {
        for (KeepAliveInfo keepAliveInfo : ChannelsManager.getInstance().getWheelPlcChannels()) {
            if (keepAliveInfo.getChannel() != channel) continue;
            long now = System.currentTimeMillis();
            keepAliveInfo.setKeepAliveTime(now);
            break;
        }
    }

    public boolean containsWebSocketClient(Channel channel) {
        boolean ret = false;
        for (KeepAliveInfo keepAliveInfo : this.webSocketChannels) {
            if (keepAliveInfo.getChannel() != channel) continue;
            ret = true;
            break;
        }
        return ret;
    }

    public boolean containsCrosssPlcClient(Channel channel) {
        boolean ret = false;
        for (KeepAliveInfo keepAliveInfo : this.crossPlcChannels) {
            if (keepAliveInfo.getChannel() != channel) continue;
            ret = true;
            break;
        }
        return ret;
    }

    public boolean containsRockerPlcClient(Channel channel) {
        boolean ret = false;
        for (KeepAliveInfo keepAliveInfo : this.rockerPlcChannels) {
            if (keepAliveInfo.getChannel() != channel) continue;
            ret = true;
            break;
        }
        return ret;
    }

    public boolean containsWheelPlcClient(Channel channel) {
        boolean ret = false;
        for (KeepAliveInfo keepAliveInfo : this.wheelPlcChannels) {
            if (keepAliveInfo.getChannel() != channel) continue;
            ret = true;
            break;
        }
        return ret;
    }

    public void handlerOverTimeLink() {
        this.handlerWebSocketOverTimeLink();
        this.handlerCrossPlcOverTimeLink();
        this.handlerRockerPlcOverTimeLink();
        this.handlerWheelPlcOverTimeLink();
    }

    private void handlerWebSocketOverTimeLink() {
        try {
            for (int i = ChannelsManager.getInstance().getWebSocketChannels().size() - 1; i >= 0; --i) {
                KeepAliveInfo keepAliveInfo = ChannelsManager.getInstance().getWebSocketChannels().get(i);
                long recordTime = keepAliveInfo.getKeepAliveTime();
                long currentTime = System.currentTimeMillis();
                long spanTime = currentTime - recordTime;
                if (spanTime <= 60000L) continue;
                keepAliveInfo.getChannel().disconnect();
                ChannelsManager.getInstance().getWebSocketChannels().remove(i);
            }
        }
        catch (Exception e) {
            LogUtil.LogError(logger, "[ChannelsManager.handlerWebSocketOverTimeLink] catch exception : " + e.getMessage());
        }
    }

    private void handlerCrossPlcOverTimeLink() {
        try {
            for (int i = ChannelsManager.getInstance().getCrossPlcChannels().size() - 1; i >= 0; --i) {
                KeepAliveInfo keepAliveInfo = ChannelsManager.getInstance().getCrossPlcChannels().get(i);
                long recordTime = keepAliveInfo.getKeepAliveTime();
                long currentTime = System.currentTimeMillis();
                long spanTime = currentTime - recordTime;
                if (spanTime <= 10000L) continue;
                keepAliveInfo.getChannel().disconnect();
                ChannelsManager.getInstance().getCrossPlcChannels().remove(i);
            }
        }
        catch (Exception e) {
            LogUtil.LogError(logger, "[ChannelsManager.handlerCrossPlcOverTimeLink] catch exception : " + e.getMessage());
        }
    }

    private void handlerRockerPlcOverTimeLink() {
        try {
            for (int i = ChannelsManager.getInstance().getRockerPlcChannels().size() - 1; i >= 0; --i) {
                KeepAliveInfo keepAliveInfo = ChannelsManager.getInstance().getRockerPlcChannels().get(i);
                long recordTime = keepAliveInfo.getKeepAliveTime();
                long currentTime = System.currentTimeMillis();
                long spanTime = currentTime - recordTime;
                if (spanTime <= 10000L) continue;
                keepAliveInfo.getChannel().disconnect();
                ChannelsManager.getInstance().getRockerPlcChannels().remove(i);
            }
        }
        catch (Exception e) {
            LogUtil.LogError(logger, "[ChannelsManager.handlerRockerPlcOverTimeLink] catch exception : " + e.getMessage());
        }
    }

    private void handlerWheelPlcOverTimeLink() {
        try {
            for (int i = ChannelsManager.getInstance().getWheelPlcChannels().size() - 1; i >= 0; --i) {
                KeepAliveInfo keepAliveInfo = ChannelsManager.getInstance().getWheelPlcChannels().get(i);
                long recordTime = keepAliveInfo.getKeepAliveTime();
                long currentTime = System.currentTimeMillis();
                long spanTime = currentTime - recordTime;
                if (spanTime <= 10000L) continue;
                keepAliveInfo.getChannel().disconnect();
                ChannelsManager.getInstance().getWheelPlcChannels().remove(i);
            }
        }
        catch (Exception e) {
            LogUtil.LogError(logger, "[ChannelsManager.handlerWheelPlcOverTimeLink] catch exception : " + e.getMessage());
        }
    }

    private static class ChannelsManagerHolder {
        private static final ChannelsManager INSTANCE = new ChannelsManager();

        private ChannelsManagerHolder() {
        }
    }
}

