/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.commands.impl.web;

import com.simba.common.command.ICommand;
import com.simba.common.command.WebCommandExecutor;
import com.simba.common.log.LogUtil;
import com.simba.server.components.SortProtocolCreator;
import com.simba.server.components.SorterParameter;
import com.simba.server.components.data.DBDataInfos;
import java.io.Closeable;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.json.JSONObject;

public class WebCmd
implements ICommand {
    public static final String NAME = "WebCmd";
    private static final Logger logger = Logger.getLogger(WebCmd.class);
    private final DBDataInfos infos;

    public WebCmd(DBDataInfos DBDataInfos2) {
        this.infos = DBDataInfos2;
    }

    @Override
    public String getName() {
        return NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean run(Object params) {
        Boolean ret = false;
        String urlPostFix = "/WebCmd/message";
        String serverHost = SorterParameter.getInstance().getServerHost();
        String serverPort = SorterParameter.getInstance().getServerPort();
        if (!SorterParameter.getInstance().isNeedDebug()) {
            serverHost = SorterParameter.getInstance().getDebugServerHost();
            serverPort = SorterParameter.getInstance().getDebugServerPort();
        }
        String url = "http://" + serverHost + ":" + serverPort + urlPostFix;
        HttpPost postRequest = new HttpPost(url);
        String content = SortProtocolCreator.getInstance().createArriveRecvRequest(this.infos);
        StringEntity contentEntity = new StringEntity(content, "UTF-8");
        contentEntity.setContentEncoding("UTF-8");
        contentEntity.setContentType("application/json");
        postRequest.setEntity(contentEntity);
        Closeable response = null;
        try {
            LogUtil.LogDebug(logger, "[WebCmd] Query Content:" + content);
            response = WebCommandExecutor.getInstance().doHttpServiceByPost(postRequest);
            HttpEntity entity = response.getEntity();
            byte[] contentBuffer = EntityUtils.toByteArray(entity);
            content = new String(contentBuffer, "UTF-8");
            JSONObject responseObj = new JSONObject(content);
            String respCode = responseObj.getString("respCode");
            LogUtil.LogDebug(logger, "[WebCmd] Request Content:" + responseObj);
            if (respCode.equals("000")) {
                ret = true;
            } else {
                this.printArrivalUploadFailed(responseObj);
                ret = false;
            }
        }
        catch (IOException ex) {
            LogUtil.LogError(logger, "[WebCmd] Catch IO Exception: Request Content:[" + content + "] Exception Message:" + ex.getMessage());
            ret = false;
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException ex) {
                    LogUtil.LogError(logger, "[WebArriveRecvCmd] Catch an exception when close a http response :" + ex.getMessage());
                }
            }
        }
        return ret;
    }

    private void printArrivalUploadFailed(JSONObject responseObj) {
        try {
            StringBuilder info = new StringBuilder("[WebCmd!] :");
            String respCode = responseObj.getString("respCode");
            String resMessage = responseObj.getString("resMessage");
            info.append(" respCode:" + respCode);
            info.append(" resMessage:" + resMessage);
            LogUtil.LogDebug(logger, info.toString());
        }
        catch (Exception e) {
            LogUtil.LogDebug(logger, "[WebArriveRecvCmd.printWebArrivalUploadSuccess] Catch an exception" + e.toString());
        }
    }
}

