/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.commands.impl.sql;

import com.simba.common.command.ICommand;
import com.simba.common.database.DbOperator;
import com.simba.server.components.SortProtocolCreator;
import com.simba.server.components.data.WheelSortInfo;
import java.sql.Timestamp;

public class TestRecordPacketOffCmd
implements ICommand {
    public static final String NAME = "TestRecordPacketOffCmd";
    private final WheelSortInfo wheelSortInfo;
    private final String sql = "insert into tt_packet_off(barcode, barcodeList, packageLength,packageWidth,packageHeight,packageVolume,scannedMode,sorterId, plcId, serverSlots,droppedSlot,sortingId,errorCodeSVR,errorCodePLC,packetOnTime,packetOffTime,recordTime) values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";

    public TestRecordPacketOffCmd(WheelSortInfo wheelSortInfo) {
        this.wheelSortInfo = wheelSortInfo;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Boolean run(Object params) {
        Boolean ret = false;
        if (!(params instanceof DbOperator)) {
            return ret;
        }
        try {
            DbOperator dbOperator = (DbOperator)params;
            dbOperator.prepareStatement(this.sql);
            String barcode = this.isStringNullToNone(this.wheelSortInfo.getBarcode());
            dbOperator.setString(1, barcode);
            String barcodeList = this.isStringNullToNone(this.wheelSortInfo.getBarcodeList().toString());
            dbOperator.setString(2, barcodeList);
            String packageLength = this.isStringNullToNone(this.wheelSortInfo.getPackageLength());
            dbOperator.setString(3, packageLength);
            String packageWidth = this.isStringNullToNone(this.wheelSortInfo.getPackageWidth());
            dbOperator.setString(4, packageWidth);
            String packageHeight = this.isStringNullToNone(this.wheelSortInfo.getPackageHeight());
            dbOperator.setString(5, packageHeight);
            String packageVolume = this.isStringNullToNone(this.wheelSortInfo.getPackageVolume());
            dbOperator.setString(6, packageVolume);
            String scannedMode = this.isStringNullToNone(this.wheelSortInfo.getScannedMode());
            dbOperator.setString(7, scannedMode);
            int sorterId = this.isStringToInt(this.wheelSortInfo.getSorterID());
            dbOperator.setInt(8, sorterId);
            String plcId = this.isStringNullToNone(this.wheelSortInfo.getPlcId());
            dbOperator.setString(9, plcId);
            String serverSlots = String.valueOf(this.wheelSortInfo.getServerSlotId());
            dbOperator.setString(10, serverSlots);
            int droppedSlot = this.wheelSortInfo.getDroppedSlotId();
            dbOperator.setInt(11, droppedSlot);
            String sortingId = this.isStringNullToNone(this.wheelSortInfo.getSortingId());
            dbOperator.setString(12, sortingId);
            int errorCodeSVR = this.wheelSortInfo.getErrorCodeSVR();
            dbOperator.setInt(13, errorCodeSVR);
            int errorCodePLC = this.wheelSortInfo.getErrorCodePLC();
            dbOperator.setInt(14, errorCodePLC);
            String packetOnTime = this.isTimeToString(this.wheelSortInfo.getPacketOnTime());
            dbOperator.setString(15, packetOnTime);
            String packetOffTime = this.isTimeToString(this.wheelSortInfo.getPacketOffTime());
            dbOperator.setString(16, packetOffTime);
            String recordTime = this.isTimeToString(this.wheelSortInfo.getRecordTime());
            dbOperator.setString(17, recordTime);
            int res = dbOperator.executeUpdate();
            if (res > 0) {
                ret = true;
            }
        }
        catch (Exception ex) {
            ret = false;
        }
        return ret;
    }

    private String isStringNullToNone(String str) {
        if (str == null || str.equals("")) {
            str = "none";
        }
        return str;
    }

    private int isStringToInt(String str) {
        int ret = 0;
        try {
            ret = Integer.valueOf(str);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    private String isTimeToString(Timestamp time) {
        String ret = "";
        if (time == null) {
            time = SortProtocolCreator.getInstance().createCurrentTimeStamp();
        }
        ret = time.toString();
        return ret;
    }
}

