/*
 * Decompiled with CFR 0.152.
 */
package com.simba.common.websocket;

import com.simba.GlobalParam;
import com.simba.common.ChannelManager;
import com.simba.common.log.LogUtil;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.handler.codec.http.websocketx.TextWebSocketFrame;

public class WebSocketChannelManager
implements ChannelManager {
    protected static final Logger logger = Logger.getLogger(WebSocketChannelManager.class);
    private final ConcurrentHashMap<String, Channel> channelList = new ConcurrentHashMap();

    public static WebSocketChannelManager getInstance() {
        return WebSocketChannelManagerHolder.INSTANCE;
    }

    private WebSocketChannelManager() {
    }

    @Override
    public void addChannel(Channel channel) {
        if (channel != null) {
            this.channelList.put(String.valueOf(channel.getId()), channel);
        }
    }

    @Override
    public void clearChannelList() {
        this.channelList.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ChannelFuture commitResponse(Channel channel, Object response, boolean close) {
        try {
            if (response == null || !(response instanceof String)) {
                ChannelFuture channelFuture = null;
                return channelFuture;
            }
            String content = (String)response;
            TextWebSocketFrame frameContent = new TextWebSocketFrame(content);
            ChannelFuture writeFuture = channel.write(frameContent);
            if (this.isNeedClose(response, close)) {
                writeFuture.addListener(ChannelFutureListener.CLOSE);
            }
            ChannelFuture channelFuture = writeFuture;
            return channelFuture;
        }
        finally {
            if (GlobalParam.LOG_MODE != 3) {
                LogUtil.LogDebug(logger, "[WebSocketChannelManager.commitResponse] Message sent [" + channel.getRemoteAddress() + "] -- " + response);
            }
        }
    }

    @Override
    public boolean containsChannel(String key) {
        return this.channelList.containsKey(key);
    }

    @Override
    public Channel getChannel(String key) {
        return this.channelList.get(key.toLowerCase());
    }

    @Override
    public int getChannelCount() {
        return this.channelList.size();
    }

    @Override
    public Channel[] getChannelList() {
        return this.channelList.values().toArray(new Channel[0]);
    }

    @Override
    public boolean isNeedClose(Object response, boolean close) {
        return close;
    }

    @Override
    public Channel removeChannel(String key) {
        return this.channelList.remove(key);
    }

    private static class WebSocketChannelManagerHolder {
        private static final WebSocketChannelManager INSTANCE = new WebSocketChannelManager();

        private WebSocketChannelManagerHolder() {
        }
    }
}

