/*
 * Decompiled with CFR 0.152.
 */
package com.simba.common.log;

import com.simba.common.thread.NamedThreadFactory;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class LoggerExecutor {
    private static final long KEEP_ALIVE_TIME = 300L;
    private static final int MAX_POOL_SIZE = 50;
    private static final int MIN_POOL_SIZE = 2;
    private final ExecutorService executor = new ThreadPoolExecutor(2, 50, 300L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new NamedThreadFactory("logger thread"));

    public static LoggerExecutor getInstance() {
        return LazyHolder.instance;
    }

    private LoggerExecutor() {
    }

    public void execute(Runnable command) {
        this.executor.execute(command);
    }

    private static class LazyHolder {
        static final LoggerExecutor instance = new LoggerExecutor();

        private LazyHolder() {
        }
    }
}

