/*
 * Decompiled with CFR 0.152.
 */
package com.simba.common.PadFrameserver.netty;

import com.simba.common.PadFrameserver.netty.PadFrameReadBytesDecoder;
import java.util.concurrent.ExecutorService;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.ChannelUpstreamHandler;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.handler.codec.frame.LengthFieldBasedFrameDecoder;
import org.jboss.netty.handler.execution.ExecutionHandler;
import org.jboss.netty.handler.stream.ChunkedWriteHandler;

public class PadFramePipelineFactory
implements ChannelPipelineFactory {
    protected static final int MAX_FRAME_LENGTH = 1024;
    private static final int LEN_FILED_OFFSET = 1;
    private static final int FRAME_HEADER_SIZE = 2;
    private static final int LEN_ADJUST_MENT = 2;
    private static final int INIT_BYTES_TO_STRIP = 3;
    protected final ExecutorService executor;
    protected final ChannelUpstreamHandler handler;

    public PadFramePipelineFactory(ExecutorService executor, ChannelUpstreamHandler handler) {
        this.executor = executor;
        this.handler = handler;
    }

    @Override
    public ChannelPipeline getPipeline() throws Exception {
        ChannelPipeline pipeline = Channels.pipeline();
        pipeline.addLast("PadframeLengthDecoder", new LengthFieldBasedFrameDecoder(1024, 1, 2, 2, 3));
        pipeline.addLast("bytesReadDecoder", new PadFrameReadBytesDecoder());
        pipeline.addLast("chunkedWriter", new ChunkedWriteHandler());
        if (this.executor != null) {
            pipeline.addLast("executor", new ExecutionHandler(this.executor));
        }
        pipeline.addLast("handler", this.handler);
        return pipeline;
    }
}

