/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.event;

import javax.mail.Folder;
import javax.mail.event.FolderListener;
import javax.mail.event.MailEvent;

public class FolderEvent
extends MailEvent {
    public static final int CREATED = 1;
    public static final int DELETED = 2;
    public static final int RENAMED = 3;
    protected transient Folder folder;
    protected transient Folder newFolder;
    protected int type;

    public FolderEvent(Object source, Folder oldFolder, Folder newFolder, int type) {
        super(source);
        this.folder = oldFolder;
        this.newFolder = newFolder;
        this.type = type;
        if (type != 1 && type != 2 && type != 3) {
            throw new IllegalArgumentException("Unknown type " + type);
        }
    }

    public FolderEvent(Object source, Folder folder, int type) {
        this(source, folder, null, type);
    }

    public void dispatch(Object listener) {
        FolderListener l = (FolderListener)listener;
        if (this.type == 1) {
            l.folderCreated(this);
        } else if (this.type == 2) {
            l.folderDeleted(this);
        } else if (this.type == 3) {
            l.folderRenamed(this);
        } else {
            throw new IllegalArgumentException("Unknown type " + this.type);
        }
    }

    public Folder getFolder() {
        return this.folder;
    }

    public Folder getNewFolder() {
        return this.newFolder;
    }

    public int getType() {
        return this.type;
    }
}

