/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.printers;

import com.simba.common.command.ICommand;
import com.simba.common.command.SQLCommandExecutor;
import com.simba.common.log.LogUtil;
import com.simba.common.thread.CommonExecutorFactory;
import com.simba.common.thread.CounterThreadFactory;
import com.simba.server.commands.CommandCreator;
import com.simba.server.components.data.PrinterInfo;
import com.simba.server.printers.PrinterClient;
import com.simba.server.printers.PrinterStatusTask;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.log4j.Logger;

public class PrinterManager {
    private static int ASYNC_EXECUTOR_POOL_SIZE = 10;
    private static final String ASYNC_OPERATION_EXECUTOR_NAME = "Printer-Status-Task-Pool";
    private static final Logger logger = Logger.getLogger(PrintersManagerHolder.class);
    public final byte[] TOSHIBA_PRINTER_STATUS_CMD = new byte[]{123, 87, 83, 124, 125};
    public final byte[] ZEBRA_PRINTER_STATUS_CMD = new byte[]{126, 72, 81, 69, 83};
    private Executor asyncServiceExecutor;
    private BlockingQueue<Runnable> asyncServiceOperationQueue;
    private String fieldCode;
    private String printerType;
    private final ConcurrentHashMap<String, PrinterClient> printerClientsMap = new ConcurrentHashMap();
    private final List<PrinterInfo> printerInfos = new LinkedList<PrinterInfo>();
    private final PrinterStatusTask statusTask = new PrinterStatusTask();

    public static PrinterManager getInstance() {
        return PrintersManagerHolder.INSTANCE;
    }

    private PrinterManager() {
    }

    public byte[] createIPBuffer(String serverHost2) {
        String[] ipValues = serverHost2.split("\\.");
        if (ipValues.length != 4) {
            return null;
        }
        byte[] result = new byte[4];
        int ip0 = Integer.parseInt(ipValues[0]);
        int ip1 = Integer.parseInt(ipValues[1]);
        int ip2 = Integer.parseInt(ipValues[2]);
        int ip3 = Integer.parseInt(ipValues[3]);
        result[0] = (byte)ip0;
        result[1] = (byte)ip1;
        result[2] = (byte)ip2;
        result[3] = (byte)ip3;
        return result;
    }

    public PrinterClient getClientPrinterByIP(String ipAddress) {
        PrinterClient clientPrinter = this.printerClientsMap.get(ipAddress);
        return clientPrinter;
    }

    public PrinterClient[] getClientPrinterList() {
        return this.printerClientsMap.values().toArray(new PrinterClient[0]);
    }

    public String getFieldCode() {
        return this.fieldCode;
    }

    public void setFieldCode(String filedCode) {
        this.fieldCode = filedCode;
    }

    public String getPrinterType() {
        return this.printerType;
    }

    public void setPrinterType(String printerType) {
        this.printerType = printerType;
    }

    public void init() {
        try {
            this.printerInfos.clear();
            LinkedList printInfos = new LinkedList();
            ICommand command = CommandCreator.getInstance().createCommand("FetchPrinterInfosCmd", printInfos);
            SQLCommandExecutor.getInstance().executeCmd(command);
            if (printInfos != null && printInfos.size() > 0) {
                for (PrinterInfo printerInfo : printInfos) {
                    this.printerInfos.add(printerInfo);
                }
            }
            this.initClients();
            this.initAsyncTaskExcutor();
            this.initRunTreads();
        }
        catch (Exception ex) {
            LogUtil.LogError(logger, "[PrinterManager] init error : " + ex.getMessage());
        }
    }

    public void runAsyncTask(Runnable task) {
        try {
            if (task != null) {
                this.asyncServiceExecutor.execute(task);
            }
        }
        catch (Exception ex) {
            LogUtil.LogError(logger, "[PrinterManager] Run async task error : " + ex.getMessage());
        }
    }

    private void initAsyncTaskExcutor() {
        this.asyncServiceOperationQueue = new LinkedBlockingQueue<Runnable>();
        this.asyncServiceExecutor = CommonExecutorFactory.newFixedThreadPool(ASYNC_EXECUTOR_POOL_SIZE, new CounterThreadFactory(ASYNC_OPERATION_EXECUTOR_NAME), this.asyncServiceOperationQueue);
    }

    private void initClients() {
        for (PrinterInfo monitor : this.printerInfos) {
            String id = monitor.getPrinterId();
            String serverHost = monitor.getPrinterIp();
            int port = monitor.getPrinterPort();
            PrinterClient clientPrinter = new PrinterClient(id, serverHost, port);
            this.printerClientsMap.put(serverHost, clientPrinter);
            clientPrinter.init();
        }
    }

    private void initRunTreads() {
        this.statusTask.start();
    }

    private static class PrintersManagerHolder {
        private static final PrinterManager INSTANCE = new PrinterManager();

        private PrintersManagerHolder() {
        }
    }
}

