/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.printers;

import com.simba.common.frameserver.FrameChannelManager;
import com.simba.common.jsonserver.JsonChannelManager;
import com.simba.common.log.LogUtil;
import com.simba.server.components.CommonDefines;
import com.simba.server.components.data.PackInfo;
import com.simba.server.printers.PrinterManager;
import com.simba.server.printers.PrinterPackTask;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.Channel;
import org.json.JSONObject;

public class PrinterClient {
    public static final int PRINTER_ERROR_STATUS = 1;
    public static final int PRINTER_SEND_SUCCESS_STATUS = 0;
    public static final int PRINTER_SOCKET_EXCEPT_STATUS = 2;
    protected static final Logger logger = Logger.getLogger(PrinterClient.class);
    private static final int TOSHIBA_PRINTER_STATUS_BUFFER_LEN = 13;
    private static final int ZEBRA_PRINTER_STATUS_BUFFER_LEN = 144;
    private static final int SOCKET_CONN_TIMEOUT = 1000;
    private static final int SOCKET_READ_TIMEOUT = 1000;
    private static final int SOCKET_RECV_BUFFER_SIZE = 1024;
    private static final int SOCKET_SEND_BUFFER_SIZE = 8192;
    private final String id;
    private final AtomicBoolean isError = new AtomicBoolean(false);
    private PrinterPackTask packTask;
    private final String serverHost;
    private final int serverPort;

    public PrinterClient(String idKey, String serverHost, int serverPort) {
        this.id = idKey;
        this.serverHost = serverHost;
        this.serverPort = serverPort;
    }

    public String getId() {
        return this.id;
    }

    public String getServerHost() {
        return this.serverHost;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public void init() {
        this.packTask = new PrinterPackTask(this, this.id);
        this.packTask.start();
    }

    public boolean isErrorStatus() {
        return this.isError.get();
    }

    public Boolean offerPackInfoToPrint(PackInfo packInfo) {
        if (packInfo == null) {
            return false;
        }
        return this.packTask.offerPackInfo(packInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized int sendSessionPackInfo(byte[] content, PackInfo packInfo) {
        int ret = -1;
        Socket clientSocket = null;
        FilterOutputStream out = null;
        try {
            String PrinterType;
            clientSocket = new Socket();
            int SocketStatus = this.SocketConnect(clientSocket);
            if (SocketStatus != 0) {
                int n = 2;
                return n;
            }
            if (!clientSocket.isConnected() || clientSocket.isClosed()) return ret;
            out = new DataOutputStream(clientSocket.getOutputStream());
            int retSize = -1;
            switch (PrinterType = PrinterManager.getInstance().getPrinterType()) {
                case "Toshiba": {
                    byte[] cmdToshibaBuf = PrinterManager.getInstance().TOSHIBA_PRINTER_STATUS_CMD;
                    out.write(cmdToshibaBuf);
                    ((DataOutputStream)out).flush();
                    byte[] toshibaBuffer = new byte[200];
                    retSize = clientSocket.getInputStream().read(toshibaBuffer);
                    if (retSize == -1) {
                        int n = 2;
                        return n;
                    }
                    if (retSize != 13) {
                        int n = 1;
                        return n;
                    }
                    byte[] receivedBuf = new byte[retSize];
                    System.arraycopy(toshibaBuffer, 0, receivedBuf, 0, retSize);
                    if (receivedBuf[2] == 48 && receivedBuf[3] == 48) {
                        LogUtil.LogDebug(logger, "[PrinterClient.sendSessionPackInfo] Send To Printer PackID : [" + packInfo.getId() + "]");
                        out.write(content);
                        ((DataOutputStream)out).flush();
                        ret = this.checkPrintStatus(clientSocket, (DataOutputStream)out);
                        this.sendPrintPackInfoToClient(packInfo);
                        return ret;
                    } else if (receivedBuf[2] == 48 && receivedBuf[3] == 50) {
                        LogUtil.LogDebug(logger, "[PrinterClient.sendSessionPackInfo] Send To Printer PackID : [" + packInfo.getId() + "]");
                        out.write(content);
                        ((DataOutputStream)out).flush();
                        ret = this.checkPrintStatus(clientSocket, (DataOutputStream)out);
                        return ret;
                    } else {
                        ret = 1;
                        return ret;
                    }
                }
                case "Zebra": {
                    byte[] cmdZebraBuf = PrinterManager.getInstance().ZEBRA_PRINTER_STATUS_CMD;
                    out.write(cmdZebraBuf);
                    ((DataOutputStream)out).flush();
                    byte[] zebraBuffer = new byte[200];
                    retSize = clientSocket.getInputStream().read(zebraBuffer);
                    if (retSize == -1) {
                        int n = 2;
                        return n;
                    }
                    if (retSize != 144) {
                        int n = 1;
                        return n;
                    }
                    byte[] receivedZebraBuf = new byte[retSize - 2];
                    System.arraycopy(zebraBuffer, 1, receivedZebraBuf, 0, retSize - 2);
                    String zebraMsg = new String(receivedZebraBuf, "UTF-8");
                    String[] zebraMsgList = zebraMsg.split("\r\n");
                    String printerStatus = zebraMsgList[3].replaceAll(" ", "");
                    String Status2 = String.valueOf(printerStatus.charAt(7));
                    if (Status2.equals("0")) {
                        LogUtil.LogDebug(logger, "[PrinterClient.sendSessionPackInfo] Send To Printer PackID : [" + packInfo.getId() + "]");
                        out.write(content);
                        ((DataOutputStream)out).flush();
                        ret = this.checkPrintStatus(clientSocket, (DataOutputStream)out);
                        this.sendPrintPackInfoToClient(packInfo);
                        return ret;
                    } else {
                        ret = 1;
                        return ret;
                    }
                }
                default: {
                    int n = ret;
                    return n;
                }
            }
        }
        catch (Exception ex) {
            ret = 2;
            LogUtil.LogError(logger, "[PrinterClient.sendSessionPackInfo] Error [" + ex.getMessage() + "]");
            return ret;
        }
        finally {
            if (clientSocket != null) {
                try {
                    clientSocket.close();
                }
                catch (IOException IOex) {
                    ret = -1;
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException IOex) {
                    ret = -1;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void sendSessionStatus() {
        Socket clientSocket = null;
        FilterOutputStream out = null;
        try {
            String PrinterType;
            clientSocket = new Socket();
            int SocketStatus = this.SocketConnect(clientSocket);
            if (SocketStatus != 0) {
                return;
            }
            if (!clientSocket.isConnected()) return;
            if (clientSocket.isClosed()) return;
            out = new DataOutputStream(clientSocket.getOutputStream());
            byte[] buffer = new byte[200];
            switch (PrinterType = PrinterManager.getInstance().getPrinterType()) {
                case "Toshiba": {
                    byte[] cmdToshibaBuf = PrinterManager.getInstance().TOSHIBA_PRINTER_STATUS_CMD;
                    out.write(cmdToshibaBuf);
                    ((DataOutputStream)out).flush();
                    int retSize = clientSocket.getInputStream().read(buffer);
                    if (retSize == -1) {
                        return;
                    }
                    if (retSize != 13) return;
                    byte[] receivedBuf = new byte[retSize];
                    System.arraycopy(buffer, 0, receivedBuf, 0, retSize);
                    this.handleToshibaPrinterStatus(receivedBuf);
                    return;
                }
                case "Zebra": {
                    byte[] cmdZebraBuf = PrinterManager.getInstance().ZEBRA_PRINTER_STATUS_CMD;
                    out.write(cmdZebraBuf);
                    ((DataOutputStream)out).flush();
                    int retZebraSize = clientSocket.getInputStream().read(buffer);
                    if (retZebraSize == -1) {
                        return;
                    }
                    if (retZebraSize != 144) return;
                    byte[] receivedBuf = new byte[retZebraSize - 2];
                    System.arraycopy(buffer, 1, receivedBuf, 0, retZebraSize - 2);
                    this.handleZebraPrinterStatus(receivedBuf);
                    return;
                }
            }
            LogUtil.LogDebug(logger, "[PrinterClient.sendSessionStatus] Not Found PrinterType");
            return;
        }
        catch (Exception ex) {
            LogUtil.LogError(logger, "[PrinterClient.sendSessionStatus] Read From [" + this.serverHost + "] Error: [" + ex.getMessage() + "]");
            return;
        }
        finally {
            if (clientSocket != null) {
                try {
                    clientSocket.close();
                }
                catch (IOException iOException) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private synchronized int SocketConnect(Socket clientSocket) throws IOException {
        int ret = -1;
        try {
            clientSocket.setSoTimeout(1000);
            clientSocket.setTcpNoDelay(true);
            clientSocket.setSendBufferSize(8192);
            clientSocket.setReceiveBufferSize(1024);
            InetSocketAddress socketAddress = new InetSocketAddress(this.serverHost, this.serverPort);
            clientSocket.connect(socketAddress, 1000);
            ret = 0;
        }
        catch (Exception e) {
            LogUtil.LogError(logger, " [PrinterClient.SocketConnect] Printer IP : [" + this.serverHost + "] Connect Faild");
            ret = 2;
        }
        return ret;
    }

    public void setErrorStatus(Boolean error) {
        this.isError.set(error);
    }

    private int checkPrintStatus(Socket clientSocket, DataOutputStream out) {
        int ret = -1;
        try {
            String PrinterType;
            byte[] buffer = new byte[200];
            switch (PrinterType = PrinterManager.getInstance().getPrinterType()) {
                case "Toshiba": {
                    byte[] cmdToshibaBuf = PrinterManager.getInstance().TOSHIBA_PRINTER_STATUS_CMD;
                    out.write(cmdToshibaBuf);
                    out.flush();
                    int retSize = clientSocket.getInputStream().read(buffer);
                    if (retSize == -1) {
                        return 2;
                    }
                    if (retSize != 13) {
                        return 1;
                    }
                    byte[] receivedBuf = new byte[retSize];
                    System.arraycopy(buffer, 0, receivedBuf, 0, retSize);
                    if (receivedBuf[2] == 48 && receivedBuf[3] == 48) {
                        ret = 0;
                        break;
                    }
                    if (receivedBuf[2] == 48 && receivedBuf[3] == 50) {
                        ret = 0;
                        break;
                    }
                    ret = 1;
                    break;
                }
                case "Zebra": {
                    byte[] cmdZebraBuf = PrinterManager.getInstance().ZEBRA_PRINTER_STATUS_CMD;
                    out.write(cmdZebraBuf);
                    out.flush();
                    int retZebraSize = clientSocket.getInputStream().read(buffer);
                    if (retZebraSize == -1) {
                        return 2;
                    }
                    if (retZebraSize != 144) {
                        return 1;
                    }
                    byte[] receivedZebraBuf = new byte[retZebraSize - 2];
                    System.arraycopy(buffer, 1, receivedZebraBuf, 0, retZebraSize - 2);
                    String zebraMsg = new String(receivedZebraBuf, "UTF-8");
                    String[] zebraMsgList = zebraMsg.split("\r\n");
                    String printerStatus = zebraMsgList[3].replaceAll(" ", "");
                    String Status2 = String.valueOf(printerStatus.charAt(7));
                    if (Status2.equals("0")) {
                        ret = 0;
                        break;
                    }
                    ret = 1;
                    break;
                }
            }
        }
        catch (Exception ex) {
            ret = 2;
        }
        return ret;
    }

    private void handleZebraPrinterStatus(byte[] realContent) {
        try {
            String zebraMsg = new String(realContent, "UTF-8");
            String[] zebraMsgList = zebraMsg.split("\r\n");
            String printerStatus = zebraMsgList[3].replaceAll(" ", "");
            String Status2 = String.valueOf(printerStatus.charAt(7));
            if (Status2.equals("0")) {
                this.setErrorStatus(false);
                this.sendPrinterStatusToPLC(1);
            } else {
                this.setErrorStatus(true);
                String PrintHeadStatus = String.valueOf(printerStatus.charAt(22));
                String errStatus = String.valueOf(printerStatus.charAt(23));
                if (PrintHeadStatus.equals("8")) {
                    this.sendPrinterStatusToPLC(17);
                    this.sendPrinterStatusToClient(17, "Print Head Check ERR!");
                    this.printerStatusLog("Print Head Check ERR!");
                } else if (PrintHeadStatus.equals("4")) {
                    this.sendPrinterStatusToPLC(17);
                    this.sendPrinterStatusToClient(17, "Print Head Damage!");
                    this.printerStatusLog("Print Head Damage!");
                } else if (PrintHeadStatus.equals("2")) {
                    this.sendPrinterStatusToPLC(17);
                    this.sendPrinterStatusToClient(17, "Motor Over Temperature!");
                    this.printerStatusLog("Motor Over Temperature!");
                } else if (PrintHeadStatus.equals("1")) {
                    this.sendPrinterStatusToPLC(17);
                    this.sendPrinterStatusToClient(17, "Printhead Over Temperature!");
                    this.printerStatusLog("Print Head Over Temperature!");
                } else if (errStatus.equals("8")) {
                    this.sendPrinterStatusToPLC(12);
                    this.sendPrinterStatusToClient(12, "Cutter Fault!");
                    this.printerStatusLog("Cutter Fault!");
                } else if (errStatus.equals("4")) {
                    this.sendPrinterStatusToPLC(15);
                    this.sendPrinterStatusToClient(15, "Head Open!");
                    this.printerStatusLog("Head Open!");
                } else if (errStatus.equals("2")) {
                    this.sendPrinterStatusToPLC(17);
                    this.sendPrinterStatusToClient(17, "Ribbon Out!");
                    this.printerStatusLog("Ribbon Out!");
                } else if (errStatus.equals("1")) {
                    this.sendPrinterStatusToPLC(17);
                    this.sendPrinterStatusToClient(17, "Media Out !");
                    this.printerStatusLog("Media Out !");
                } else {
                    this.sendPrinterStatusToPLC(99);
                    this.sendPrinterStatusToClient(99, "UNKNOWN ERROR");
                }
            }
        }
        catch (Exception ex) {
            LogUtil.LogError(logger, "Printer IP : [" + this.serverHost + "] error : " + ex.toString());
        }
    }

    private void handleToshibaPrinterStatus(byte[] realContent) {
        try {
            if (realContent[2] == 48 && realContent[3] == 48) {
                this.isError.set(false);
                this.sendPrinterStatusToPLC(1);
            } else if (realContent[2] == 48 && realContent[3] == 49) {
                this.isError.set(true);
                this.sendPrinterStatusToPLC(2);
                this.sendPrinterStatusToClient(2, "HEAD OPEN ON LINE MODE");
                this.printerStatusLog("HEAD OPEN ON LINE MODE");
            } else if (realContent[2] == 48 && realContent[3] == 50) {
                this.isError.set(false);
                this.sendPrinterStatusToPLC(3);
                this.sendPrinterStatusToClient(3, "IN OPERATION");
                this.printerStatusLog("IN OPERATION");
            } else if (realContent[2] == 48 && realContent[3] == 52) {
                this.isError.set(true);
                this.sendPrinterStatusToPLC(4);
                this.sendPrinterStatusToClient(4, "PAUSE");
                this.printerStatusLog("PAUSE");
            } else if (realContent[2] == 48 && realContent[3] == 53) {
                this.isError.set(true);
                this.sendPrinterStatusToPLC(5);
                this.sendPrinterStatusToClient(5, "LABLE WAITTING TO STRIPPED");
            } else if (realContent[2] == 49 && realContent[3] == 49) {
                this.isError.set(true);
                this.sendPrinterStatusToPLC(11);
                this.sendPrinterStatusToClient(11, "PAPAER JAM");
                this.printerStatusLog("PAPER JAM");
            } else if (realContent[2] == 49 && realContent[3] == 50) {
                this.isError.set(true);
                this.sendPrinterStatusToPLC(12);
                this.sendPrinterStatusToClient(12, "CUTTER ERROR");
            } else if (realContent[2] == 49 && realContent[3] == 51) {
                this.isError.set(true);
                this.sendPrinterStatusToPLC(13);
                this.sendPrinterStatusToClient(13, "NO PAPER");
                this.printerStatusLog("NO PAPER");
            } else if (realContent[2] == 49 && realContent[3] == 53) {
                this.isError.set(true);
                this.sendPrinterStatusToPLC(15);
                this.sendPrinterStatusToClient(15, "HEAD OPEN");
            } else if (realContent[2] == 49 && realContent[3] == 55) {
                this.isError.set(true);
                this.sendPrinterStatusToPLC(17);
                this.sendPrinterStatusToClient(17, "HEAD ERROR");
            } else if (realContent[2] == 49 && realContent[3] == 56) {
                this.isError.set(true);
                this.sendPrinterStatusToPLC(18);
                this.sendPrinterStatusToClient(18, "EXCESS HEAD TEMP");
            } else if (realContent[2] == 50 && realContent[3] == 49) {
                this.isError.set(true);
                this.sendPrinterStatusToPLC(21);
                this.sendPrinterStatusToClient(21, "RIBBON ERROR");
            } else if (realContent[2] == 50 && realContent[3] == 52) {
                this.isError.set(true);
                this.sendPrinterStatusToPLC(24);
                this.sendPrinterStatusToClient(24, "COVER OPEN");
            } else if (realContent[2] == 53 && realContent[3] == 48) {
                this.isError.set(true);
                this.sendPrinterStatusToPLC(50);
                this.sendPrinterStatusToClient(50, "FLASH WRITE ERROR");
            } else if (realContent[2] == 53 && realContent[3] == 49) {
                this.isError.set(true);
                this.sendPrinterStatusToPLC(51);
                this.sendPrinterStatusToClient(51, "FORMAT ERROR");
            } else if (realContent[2] == 53 && realContent[3] == 52) {
                this.isError.set(true);
                this.sendPrinterStatusToPLC(54);
                this.sendPrinterStatusToClient(54, "FLASH CARD FULL");
            } else {
                this.isError.set(true);
                this.sendPrinterStatusToPLC(99);
                this.sendPrinterStatusToClient(99, "UNKNOWN ERROR");
            }
        }
        catch (Exception ex) {
            LogUtil.LogError(logger, "Printer IP : [" + this.serverHost + "] error : " + ex.toString());
        }
    }

    private void printerStatusLog(String content) {
        LogUtil.LogError(logger, "Printer Status : [" + content + "] Printer IP : [" + this.serverHost + "]");
    }

    private void reOfferLastPackInfo() {
        PackInfo packInfo = this.packTask.getLastPackInfo();
        this.packTask.setLastPackInfo(null);
        if (packInfo != null) {
            this.offerPackInfoToPrint(packInfo);
        }
    }

    private void sendPrinterStatusToClient(int status, String desc) {
        Channel[] channels;
        JSONObject printerStatusObj = new JSONObject();
        printerStatusObj.put("ServiceName", "PrinterStatus");
        printerStatusObj.put("printerAddress", this.serverHost);
        printerStatusObj.put("printerStatusValue", status);
        printerStatusObj.put("printerStatusDesc", desc);
        String content = printerStatusObj.toString();
        for (Channel channel : channels = JsonChannelManager.getInstance().getChannelList()) {
            JsonChannelManager.getInstance().commitResponse(channel, content.getBytes(), false);
        }
    }

    private void sendPrinterStatusToPLC(int status) {
        Channel[] channels;
        int ipLen = 4;
        int headerLen = 2;
        int cmdLen = 1;
        int statusBufLen = 1;
        int tailLen = 2;
        int totalLen = headerLen + cmdLen + ipLen + statusBufLen + tailLen;
        byte[] result = new byte[totalLen];
        byte[] cmdBuf = new byte[]{-1};
        byte[] ipBuffer = PrinterManager.getInstance().createIPBuffer(this.serverHost);
        byte[] statusBuf = new byte[]{(byte)status};
        int position = 0;
        if (ipBuffer == null) {
            return;
        }
        System.arraycopy(CommonDefines.REPLY_HEADER, 0, result, position, headerLen);
        System.arraycopy(cmdBuf, 0, result, position += headerLen, cmdLen);
        System.arraycopy(ipBuffer, 0, result, position += cmdLen, ipLen);
        System.arraycopy(statusBuf, 0, result, position += ipLen, statusBufLen);
        System.arraycopy(CommonDefines.REPLY_ENDER, 0, result, position += statusBufLen, tailLen);
        position += tailLen;
        for (Channel ch : channels = FrameChannelManager.getInstance().getChannelList()) {
            FrameChannelManager.getInstance().commitResponse(ch, result, false);
        }
    }

    private void sendPrintPackInfoToClient(PackInfo packInfo) {
        Channel[] channels;
        JSONObject printPackInfoObj = new JSONObject();
        printPackInfoObj.put("ServiceName", "PrintPackInfo");
        printPackInfoObj.put("printerAddress", this.serverHost);
        printPackInfoObj.put("packId", packInfo.getId());
        printPackInfoObj.put("packCode", packInfo.getBarcode());
        printPackInfoObj.put("receiveSiteCode", packInfo.getReceiveSiteCode());
        printPackInfoObj.put("slotId", packInfo.getSlotId());
        printPackInfoObj.put("packCount", packInfo.getPackCounts());
        String content = printPackInfoObj.toString();
        for (Channel channel : channels = JsonChannelManager.getInstance().getChannelList()) {
            JsonChannelManager.getInstance().commitResponse(channel, content.getBytes(), false);
        }
    }
}

