/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.printercmd;

import com.simba.server.components.data.PackInfo;
import com.simba.server.printercmd.PrinterCmdUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

public class PackCmdCreator {
    private static PackCmdCreator instance = new PackCmdCreator();

    public static PackCmdCreator getInstance() {
        return instance;
    }

    private PackCmdCreator() {
    }

    public byte[] createPackCmd(PackInfo packInfo) {
        byte[] cmdBuffer = null;
        int bufferLen = 0;
        PrinterCmdUtils.getInstance().preHandlePacketInfo(packInfo);
        try {
            byte[] cmdD = this.ToUTF8("{D0500,1000,0500,1000|}").getBytes();
            bufferLen += cmdD.length;
            byte[] cmdAY = this.ToUTF8("{AY;+08,0|}").getBytes();
            bufferLen += cmdAY.length;
            byte[] cmdC = this.ToUTF8("{C|}").getBytes();
            bufferLen += cmdC.length;
            byte[] cmdPC11 = this.ToUTF8("{PC11;0210,0060,20,20,r,00,B;01,02|}").getBytes();
            bufferLen += cmdPC11.length;
            byte[] cmdRC11 = this.ToUTF8("{RC11;\u4ef6:|}").getBytes();
            bufferLen += cmdRC11.length;
            byte[] cmdPC25 = this.ToUTF8("{PC25;0270,0060,20,20,r,00,B;01,02|}").getBytes();
            bufferLen += cmdPC25.length;
            byte[] cmdRC25 = this.ToUTF8("{RC25;" + packInfo.getPackCounts() + "|}").getBytes();
            bufferLen += cmdRC25.length;
            byte[] cmdPC20 = this.ToUTF8("{PC20;0020,0060,20,20,r,00,B;01,02|}").getBytes();
            bufferLen += cmdPC20.length;
            byte[] cmdRC20 = this.ToUTF8("{RC20;\u683c:|}").getBytes();
            bufferLen += cmdRC20.length;
            byte[] cmdPC26 = this.ToUTF8("{PC26;0080,0060,20,20,r,00,B;01,02|}").getBytes();
            bufferLen += cmdPC26.length;
            byte[] cmdRC26 = this.ToUTF8("{RC26;" + packInfo.getSlotId() + "|}").getBytes();
            bufferLen += cmdRC26.length;
            byte[] cmdPC21 = this.ToUTF8("{PC21;0420,0065,30,30,r,00,B;01,02|}").getBytes();
            bufferLen += cmdPC21.length;
            byte[] cmdRC21 = this.ToUTF8("{RC21;" + packInfo.getBoxType() + "|}").getBytes();
            bufferLen += cmdRC21.length;
            byte[] cmdPC22 = this.ToUTF8("{PC22;0560,0060,20,20,r,00,B;01,02|}").getBytes();
            bufferLen += cmdPC22.length;
            byte[] cmdRC22 = this.ToUTF8("{RC22;" + packInfo.getMixBoxTypeText() + "|}").getBytes();
            bufferLen += cmdRC22.length;
            byte[] cmdPC23 = this.ToUTF8("{PC23;0860,0060,30,30,r,00,B;01,02|}").getBytes();
            bufferLen += cmdPC23.length;
            byte[] cmdRC23 = this.ToUTF8("{RC23;" + packInfo.getCategoryText() + "|}").getBytes();
            bufferLen += cmdRC23.length;
            byte[] cmdPC24 = this.ToUTF8("{PC24;0660,0060,20,20,r,00,B;01,02|}").getBytes();
            bufferLen += cmdPC24.length;
            byte[] cmdRC24 = this.ToUTF8("{RC24;" + packInfo.getReceiveSiteCode() + "|}").getBytes();
            bufferLen += cmdRC24.length;
            byte[] cmdPC03 = this.ToUTF8("{PC03;0160,0260,15,1,H,00,B;01,02|}").getBytes();
            bufferLen += cmdPC03.length;
            byte[] cmdRC03 = this.ToUTF8("{RC03;" + packInfo.getBarcode() + " |}").getBytes();
            bufferLen += cmdRC03.length;
            byte[] cmdXB01 = this.ToUTF8("{XB01;0095,0080,9,1,04,0,0150=" + packInfo.getBarcode() + "|}").getBytes();
            bufferLen += cmdXB01.length;
            byte[] cmdPC27 = this.ToUTF8("{PC27;0020,0400,30,30,r,00,B;01,02|}").getBytes();
            bufferLen += cmdPC27.length;
            byte[] cmdRC27 = this.ToUTF8("{RC27;" + packInfo.getRouterNum() + "|}").getBytes();
            bufferLen += cmdRC27.length;
            byte[] cmdPC100 = this.ToUTF8("{PC100;0100,0470,15,20,r,00,B;01,02|}").getBytes();
            bufferLen += cmdPC100.length;
            byte[] cmdRC100 = this.ToUTF8("{RC100;\u6253\u5370\u65f6\u95f4:|}").getBytes();
            bufferLen += cmdRC100.length;
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String strTimeString = df.format(new Date());
            byte[] cmdPC101 = this.ToUTF8("{PC101;0260,0460,15,1,H,00,B;01,02|}").getBytes();
            bufferLen += cmdPC101.length;
            byte[] cmdRC101 = this.ToUTF8("{RC101;" + strTimeString + "|}").getBytes();
            bufferLen += cmdRC101.length;
            String router = packInfo.getRouter().replaceAll("\\[", "").replaceAll("\\]", "").replace("\"", "");
            String[] routName = router.split(",");
            String routList = "";
            for (String name : routName) {
                routList = routList + name + " - ";
            }
            routList = routList.substring(0, routList.length() - 2);
            byte[] routeBuffer = new byte[]{};
            byte[] lineBuffer = new byte[]{};
            if (routList.length() < 19) {
                int pos = 0;
                byte[] routePC28 = this.ToUTF8("{PC28;0210,0400,25,25,r,00,B;01,02|}").getBytes();
                byte[] routeRC28 = this.ToUTF8("{RC28;" + routList + "|}").getBytes();
                routeBuffer = new byte[routePC28.length + routeRC28.length];
                System.arraycopy(routePC28, 0, routeBuffer, pos, routePC28.length);
                System.arraycopy(routeRC28, 0, routeBuffer, pos += routePC28.length, routeRC28.length);
                pos += routeRC28.length;
            } else {
                switch (routName.length) {
                    case 2: {
                        routeBuffer = this.handlerTwoRouter(routName);
                        lineBuffer = this.handlertwoline();
                        break;
                    }
                    case 3: {
                        routeBuffer = this.handlerThreeRouter(routName);
                        lineBuffer = this.handlerthreeline();
                        break;
                    }
                    case 4: {
                        routeBuffer = this.handlerFourRouter(routName);
                        lineBuffer = this.handlerfourline();
                        break;
                    }
                    case 5: {
                        routeBuffer = this.handlerFiveRouter(routName);
                        lineBuffer = this.handlerfiveline();
                        break;
                    }
                    case 6: {
                        routeBuffer = this.handlerSixRouter(routName);
                        lineBuffer = this.handlerSixline();
                        break;
                    }
                }
            }
            byte[] cmdXS = this.ToUTF8("{XS;I,0001,0002C4000|}").getBytes();
            cmdBuffer = new byte[(bufferLen += cmdXS.length) + routeBuffer.length + lineBuffer.length];
            int position = 0;
            System.arraycopy(cmdD, 0, cmdBuffer, position, cmdD.length);
            System.arraycopy(cmdAY, 0, cmdBuffer, position += cmdD.length, cmdAY.length);
            System.arraycopy(cmdC, 0, cmdBuffer, position += cmdAY.length, cmdC.length);
            System.arraycopy(cmdPC03, 0, cmdBuffer, position += cmdC.length, cmdPC03.length);
            System.arraycopy(cmdRC03, 0, cmdBuffer, position += cmdPC03.length, cmdRC03.length);
            System.arraycopy(cmdPC11, 0, cmdBuffer, position += cmdRC03.length, cmdPC11.length);
            System.arraycopy(cmdRC11, 0, cmdBuffer, position += cmdPC11.length, cmdRC11.length);
            System.arraycopy(cmdPC20, 0, cmdBuffer, position += cmdRC11.length, cmdPC20.length);
            System.arraycopy(cmdRC20, 0, cmdBuffer, position += cmdPC20.length, cmdRC20.length);
            System.arraycopy(cmdPC21, 0, cmdBuffer, position += cmdRC20.length, cmdPC21.length);
            System.arraycopy(cmdRC21, 0, cmdBuffer, position += cmdPC21.length, cmdRC21.length);
            System.arraycopy(cmdPC22, 0, cmdBuffer, position += cmdRC21.length, cmdPC22.length);
            System.arraycopy(cmdRC22, 0, cmdBuffer, position += cmdPC22.length, cmdRC22.length);
            System.arraycopy(cmdPC23, 0, cmdBuffer, position += cmdRC22.length, cmdPC23.length);
            System.arraycopy(cmdRC23, 0, cmdBuffer, position += cmdPC23.length, cmdRC23.length);
            System.arraycopy(cmdPC24, 0, cmdBuffer, position += cmdRC23.length, cmdPC24.length);
            System.arraycopy(cmdRC24, 0, cmdBuffer, position += cmdPC24.length, cmdRC24.length);
            System.arraycopy(cmdPC25, 0, cmdBuffer, position += cmdRC24.length, cmdPC25.length);
            System.arraycopy(cmdRC25, 0, cmdBuffer, position += cmdPC25.length, cmdRC25.length);
            System.arraycopy(cmdPC26, 0, cmdBuffer, position += cmdRC25.length, cmdPC26.length);
            System.arraycopy(cmdRC26, 0, cmdBuffer, position += cmdPC26.length, cmdRC26.length);
            System.arraycopy(cmdPC27, 0, cmdBuffer, position += cmdRC26.length, cmdPC27.length);
            System.arraycopy(cmdRC27, 0, cmdBuffer, position += cmdPC27.length, cmdRC27.length);
            System.arraycopy(cmdPC100, 0, cmdBuffer, position += cmdRC27.length, cmdPC100.length);
            System.arraycopy(cmdRC100, 0, cmdBuffer, position += cmdPC100.length, cmdRC100.length);
            System.arraycopy(cmdPC101, 0, cmdBuffer, position += cmdRC100.length, cmdPC101.length);
            System.arraycopy(cmdRC101, 0, cmdBuffer, position += cmdPC101.length, cmdRC101.length);
            System.arraycopy(routeBuffer, 0, cmdBuffer, position += cmdRC101.length, routeBuffer.length);
            System.arraycopy(lineBuffer, 0, cmdBuffer, position += routeBuffer.length, lineBuffer.length);
            System.arraycopy(cmdXB01, 0, cmdBuffer, position += lineBuffer.length, cmdXB01.length);
            System.arraycopy(cmdXS, 0, cmdBuffer, position += cmdXB01.length, cmdXS.length);
            position += cmdXS.length;
        }
        catch (Exception ex) {
            cmdBuffer = null;
        }
        return cmdBuffer;
    }

    private String autoGenericCode(int code, int num) {
        String result = "";
        result = String.format("%0" + num + "d", code);
        return result;
    }

    private byte[] handlerfiveline() {
        int pos = 0;
        byte[] Buffer2 = null;
        byte[] cmdPC55 = this.ToUTF8("{PC55;0320,0400,25,25,r,00,B;01,02|}").getBytes();
        byte[] cmdRC55 = this.ToUTF8("{RC55;-|}").getBytes();
        byte[] cmdPC56 = this.ToUTF8("{PC56;0480,0400,25,25,r,00,B;01,02|}").getBytes();
        byte[] cmdRC56 = this.ToUTF8("{RC56;-|}").getBytes();
        byte[] cmdPC57 = this.ToUTF8("{PC57;0640,0400,25,25,r,00,B;01,02|}").getBytes();
        byte[] cmdRC57 = this.ToUTF8("{RC57;-|}").getBytes();
        byte[] cmdPC58 = this.ToUTF8("{PC58;0800,0400,25,25,r,00,B;01,02|}").getBytes();
        byte[] cmdRC58 = this.ToUTF8("{RC58;-|}").getBytes();
        Buffer2 = new byte[cmdPC55.length + cmdPC56.length + cmdPC57.length + cmdPC58.length + cmdRC55.length + cmdRC56.length + cmdRC57.length + cmdRC58.length];
        System.arraycopy(cmdPC55, 0, Buffer2, pos, cmdPC55.length);
        System.arraycopy(cmdRC55, 0, Buffer2, pos += cmdPC55.length, cmdRC55.length);
        System.arraycopy(cmdPC56, 0, Buffer2, pos += cmdRC55.length, cmdPC56.length);
        System.arraycopy(cmdRC56, 0, Buffer2, pos += cmdPC56.length, cmdRC56.length);
        System.arraycopy(cmdPC57, 0, Buffer2, pos += cmdRC56.length, cmdPC57.length);
        System.arraycopy(cmdRC57, 0, Buffer2, pos += cmdPC57.length, cmdRC57.length);
        System.arraycopy(cmdPC58, 0, Buffer2, pos += cmdRC57.length, cmdPC58.length);
        System.arraycopy(cmdRC58, 0, Buffer2, pos += cmdPC58.length, cmdRC58.length);
        pos += cmdRC58.length;
        return Buffer2;
    }

    private byte[] handlerFiveRouter(String[] routName) {
        byte[] cmdBuffer = null;
        int position = 0;
        try {
            byte[] routeBuffer2 = new byte[]{};
            byte[] routeBuffer3 = new byte[]{};
            byte[] routeBuffer4 = new byte[]{};
            byte[] routeBuffer5 = new byte[]{};
            byte[] routeBuffer6 = new byte[]{};
            byte[] routeBuffer7 = new byte[]{};
            ArrayList<byte[]> lenListBuffer5 = new ArrayList<byte[]>();
            ArrayList<byte[]> lenListBuffer3 = new ArrayList<byte[]>();
            ArrayList<byte[]> lenListBuffer4 = new ArrayList<byte[]>();
            ArrayList<byte[]> lenListBuffer6 = new ArrayList<byte[]>();
            ArrayList<byte[]> lenListBuffer7 = new ArrayList<byte[]>();
            ArrayList<byte[]> lenListBuffer2 = new ArrayList<byte[]>();
            for (int i = 0; i < routName.length; ++i) {
                String bufPos;
                String firstLine;
                int strLen = routName[i].length();
                if (strLen == 2) {
                    firstLine = routName[i].substring(0, strLen);
                    int pos = 200 + 160 * i;
                    String bufPos2 = this.autoGenericCode(pos, 4);
                    byte[] routePC31 = this.ToUTF8("{PC1" + i + "8;" + bufPos2 + ",0400,25,25,r,00,B;01,02|}").getBytes();
                    byte[] routeRC31 = this.ToUTF8("{RC1" + i + "8;" + firstLine + "|}").getBytes();
                    int position3 = 0;
                    routeBuffer2 = new byte[routePC31.length + routeRC31.length];
                    System.arraycopy(routePC31, 0, routeBuffer2, position3, routePC31.length);
                    System.arraycopy(routeRC31, 0, routeBuffer2, position3 += routePC31.length, routeRC31.length);
                    position3 += routeRC31.length;
                    if (lenListBuffer2.add(routeBuffer2)) {
                        // empty if block
                    }
                }
                if (strLen == 3) {
                    firstLine = routName[i].substring(0, 2);
                    String secLine = routName[i].substring(2, strLen);
                    int pos = 200 + 160 * i;
                    String bufPos3 = this.autoGenericCode(pos, 4);
                    byte[] routePC31 = this.ToUTF8("{PC3" + i + ";" + bufPos3 + ",0360,25,25,r,00,B;01,02|}").getBytes();
                    byte[] routeRC31 = this.ToUTF8("{RC3" + i + ";" + firstLine + "|}").getBytes();
                    byte[] routePC32 = this.ToUTF8("{PC1" + i + "1;" + bufPos3 + ",0430,25,25,r,00,B;01,02|}").getBytes();
                    byte[] routeRC32 = this.ToUTF8("{RC1" + i + "1;" + secLine + "|}").getBytes();
                    int position3 = 0;
                    routeBuffer3 = new byte[routePC31.length + routePC32.length + routeRC31.length + routeRC32.length];
                    System.arraycopy(routePC31, 0, routeBuffer3, position3, routePC31.length);
                    System.arraycopy(routeRC31, 0, routeBuffer3, position3 += routePC31.length, routeRC31.length);
                    System.arraycopy(routePC32, 0, routeBuffer3, position3 += routeRC31.length, routePC32.length);
                    System.arraycopy(routeRC32, 0, routeBuffer3, position3 += routePC32.length, routeRC32.length);
                    position3 += routeRC32.length;
                    if (lenListBuffer3.add(routeBuffer3)) {
                        // empty if block
                    }
                }
                if (strLen == 4) {
                    int position4 = 0;
                    String firstLine2 = routName[i].substring(0, 2);
                    String secLine = routName[i].substring(2, strLen);
                    int pos = 200 + 160 * i;
                    bufPos = this.autoGenericCode(pos, 4);
                    byte[] routePC41 = this.ToUTF8("{PC4" + i + ";" + bufPos + ",0360,25,25,r,00,B;01,02|}").getBytes();
                    byte[] routeRC41 = this.ToUTF8("{RC4" + i + ";" + firstLine2 + "|}").getBytes();
                    byte[] routePC42 = this.ToUTF8("{PC1" + i + "2;" + bufPos + ",0430,25,25,r,00,B;01,02|}").getBytes();
                    byte[] routeRC42 = this.ToUTF8("{RC1" + i + "2;" + secLine + "|}").getBytes();
                    routeBuffer4 = new byte[routePC41.length + routeRC41.length + routePC42.length + routeRC42.length];
                    System.arraycopy(routePC41, 0, routeBuffer4, position4, routePC41.length);
                    System.arraycopy(routeRC41, 0, routeBuffer4, position4 += routePC41.length, routeRC41.length);
                    System.arraycopy(routePC42, 0, routeBuffer4, position4 += routeRC41.length, routePC42.length);
                    System.arraycopy(routeRC42, 0, routeBuffer4, position4 += routePC42.length, routeRC42.length);
                    position4 += routeRC42.length;
                    if (lenListBuffer4.add(routeBuffer4)) {
                        // empty if block
                    }
                }
                if (strLen == 5) {
                    String firstLine3 = routName[i].substring(0, 3);
                    String secLine = routName[i].substring(3, strLen);
                    int pos = 200 + 160 * i;
                    String bufPos4 = this.autoGenericCode(pos, 4);
                    byte[] routePC51 = this.ToUTF8("{PC5" + i + ";" + bufPos4 + ",0360,20,20,r,00,B;01,02|}").getBytes();
                    byte[] routeRC51 = this.ToUTF8("{RC5" + i + ";" + firstLine3 + "|}").getBytes();
                    byte[] routePC52 = this.ToUTF8("{PC1" + i + "3;" + bufPos4 + ",0430,25,20,r,00,B;01,02|}").getBytes();
                    byte[] routeRC52 = this.ToUTF8("{RC1" + i + "3;" + secLine + "|}").getBytes();
                    int position5 = 0;
                    routeBuffer5 = new byte[routePC51.length + routePC52.length + routeRC51.length + routeRC52.length];
                    System.arraycopy(routePC51, 0, routeBuffer5, position5, routePC51.length);
                    System.arraycopy(routePC52, 0, routeBuffer5, position5 += routePC51.length, routePC52.length);
                    System.arraycopy(routeRC51, 0, routeBuffer5, position5 += routePC52.length, routeRC51.length);
                    System.arraycopy(routeRC52, 0, routeBuffer5, position5 += routeRC51.length, routeRC52.length);
                    position5 += routeRC52.length;
                    if (lenListBuffer5.add(routeBuffer5)) {
                        // empty if block
                    }
                }
                if (strLen == 6) {
                    String firstLine4 = routName[i].substring(0, 2);
                    String secLine = routName[i].substring(2, 4);
                    String thirdLine = routName[i].substring(4, strLen);
                    int pos = 200 + 160 * i;
                    bufPos = this.autoGenericCode(pos, 4);
                    byte[] routePC61 = this.ToUTF8("{PC6" + i + ";" + bufPos + ",0350,25,20,r,00,B;01,02|}").getBytes();
                    byte[] routeRC61 = this.ToUTF8("{RC6" + i + ";" + firstLine4 + "|}").getBytes();
                    byte[] routePC62 = this.ToUTF8("{PC1" + i + "4;" + bufPos + ",0390,25,20,r,00,B;01,02|}").getBytes();
                    byte[] routeRC62 = this.ToUTF8("{RC1" + i + "4;" + secLine + "|}").getBytes();
                    byte[] routePC63 = this.ToUTF8("{PC1" + i + "5;" + bufPos + ",0430,25,20,r,00,B;01,02|}").getBytes();
                    byte[] routeRC63 = this.ToUTF8("{RC1" + i + "5;" + thirdLine + "|}").getBytes();
                    int position6 = 0;
                    routeBuffer6 = new byte[routePC61.length + routePC62.length + routeRC62.length + routeRC62.length + routePC63.length + routeRC63.length];
                    System.arraycopy(routePC61, 0, routeBuffer6, position6, routePC61.length);
                    System.arraycopy(routePC62, 0, routeBuffer6, position6 += routePC61.length, routePC62.length);
                    System.arraycopy(routeRC62, 0, routeBuffer6, position6 += routePC62.length, routeRC62.length);
                    System.arraycopy(routeRC61, 0, routeBuffer6, position6 += routeRC62.length, routeRC61.length);
                    System.arraycopy(routePC63, 0, routeBuffer6, position6 += routeRC61.length, routePC63.length);
                    System.arraycopy(routeRC63, 0, routeBuffer6, position6 += routePC63.length, routeRC63.length);
                    position6 += routeRC63.length;
                    if (lenListBuffer6.add(routeBuffer6)) {
                        // empty if block
                    }
                }
                if (strLen < 7) continue;
                String firstLine5 = routName[i].substring(0, 4);
                String secLine = routName[i].substring(4, strLen);
                int pos = 200 + 160 * i;
                String bufPos5 = this.autoGenericCode(pos, 4);
                byte[] routePC71 = this.ToUTF8("{PC7" + i + ";" + bufPos5 + ",0360,20,20,r,00,B;01,02|}").getBytes();
                byte[] routeRC71 = this.ToUTF8("{RC7" + i + ";" + firstLine5 + "|}").getBytes();
                byte[] routePC72 = this.ToUTF8("{PC1" + i + "6;" + bufPos5 + ",0420,25,20,r,00,B;01,02|}").getBytes();
                byte[] routeRC72 = this.ToUTF8("{RC1" + i + "6;" + secLine + "|}").getBytes();
                int position7 = 0;
                routeBuffer7 = new byte[routePC71.length + routePC72.length + routeRC71.length + routeRC72.length];
                System.arraycopy(routePC71, 0, routeBuffer7, position7, routePC71.length);
                System.arraycopy(routePC72, 0, routeBuffer7, position7 += routePC71.length, routePC72.length);
                System.arraycopy(routeRC72, 0, routeBuffer7, position7 += routePC72.length, routeRC72.length);
                System.arraycopy(routeRC71, 0, routeBuffer7, position7 += routeRC72.length, routeRC71.length);
                position7 += routeRC71.length;
                if (!lenListBuffer7.add(routeBuffer7)) continue;
            }
            cmdBuffer = new byte[routeBuffer3.length * lenListBuffer3.size() + routeBuffer4.length * lenListBuffer4.size() + routeBuffer5.length * lenListBuffer5.size() + routeBuffer6.length * lenListBuffer6.size() + routeBuffer7.length * lenListBuffer7.size() + routeBuffer2.length * lenListBuffer2.size()];
            for (byte[] bs : lenListBuffer2) {
                System.arraycopy(bs, 0, cmdBuffer, position, bs.length);
                position += bs.length;
            }
            for (byte[] bs : lenListBuffer3) {
                System.arraycopy(bs, 0, cmdBuffer, position, bs.length);
                position += bs.length;
            }
            for (byte[] bs : lenListBuffer4) {
                System.arraycopy(bs, 0, cmdBuffer, position, bs.length);
                position += bs.length;
            }
            for (byte[] bs : lenListBuffer5) {
                System.arraycopy(bs, 0, cmdBuffer, position, bs.length);
                position += bs.length;
            }
            for (byte[] bs : lenListBuffer6) {
                System.arraycopy(bs, 0, cmdBuffer, position, bs.length);
                position += bs.length;
            }
            for (byte[] bs : lenListBuffer7) {
                System.arraycopy(bs, 0, cmdBuffer, position, bs.length);
                position += bs.length;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return cmdBuffer;
    }

    private byte[] handlerfourline() {
        int pos = 0;
        byte[] Buffer2 = null;
        byte[] cmdPC44 = this.ToUTF8("{PC44;0340,0400,25,25,r,00,B;01,02|}").getBytes();
        byte[] cmdRC44 = this.ToUTF8("{RC44;-|}").getBytes();
        byte[] cmdPC45 = this.ToUTF8("{PC45;0540,0400,25,25,r,00,B;01,02|}").getBytes();
        byte[] cmdRC45 = this.ToUTF8("{RC45;-|}").getBytes();
        byte[] cmdPC46 = this.ToUTF8("{PC46;0740,0400,25,25,r,00,B;01,02|}").getBytes();
        byte[] cmdRC46 = this.ToUTF8("{RC46;-|}").getBytes();
        Buffer2 = new byte[cmdPC44.length + cmdPC45.length + cmdPC46.length + cmdRC44.length + cmdRC45.length + cmdRC46.length];
        System.arraycopy(cmdPC44, 0, Buffer2, pos, cmdPC44.length);
        System.arraycopy(cmdRC44, 0, Buffer2, pos += cmdPC44.length, cmdRC44.length);
        System.arraycopy(cmdPC45, 0, Buffer2, pos += cmdRC44.length, cmdPC45.length);
        System.arraycopy(cmdRC45, 0, Buffer2, pos += cmdPC45.length, cmdRC45.length);
        System.arraycopy(cmdPC46, 0, Buffer2, pos += cmdRC45.length, cmdPC46.length);
        System.arraycopy(cmdRC46, 0, Buffer2, pos += cmdPC46.length, cmdRC46.length);
        pos += cmdRC46.length;
        return Buffer2;
    }

    private byte[] handlerFourRouter(String[] routName) {
        byte[] cmdBuffer = null;
        int position = 0;
        try {
            byte[] routeBuffer2 = new byte[]{};
            byte[] routeBuffer3 = new byte[]{};
            byte[] routeBuffer4 = new byte[]{};
            byte[] routeBuffer5 = new byte[]{};
            byte[] routeBuffer6 = new byte[]{};
            byte[] routeBuffer7 = new byte[]{};
            ArrayList<byte[]> lenListBuffer2 = new ArrayList<byte[]>();
            ArrayList<byte[]> lenListBuffer5 = new ArrayList<byte[]>();
            ArrayList<byte[]> lenListBuffer3 = new ArrayList<byte[]>();
            ArrayList<byte[]> lenListBuffer4 = new ArrayList<byte[]>();
            ArrayList<byte[]> lenListBuffer6 = new ArrayList<byte[]>();
            ArrayList<byte[]> lenListBuffer7 = new ArrayList<byte[]>();
            for (int i = 0; i < routName.length; ++i) {
                String bufPos;
                String firstLine;
                int strLen = routName[i].length();
                if (strLen == 2) {
                    firstLine = routName[i].substring(0, strLen);
                    int pos = 200 + 200 * i;
                    String bufPos2 = this.autoGenericCode(pos, 4);
                    byte[] routePC31 = this.ToUTF8("{PC1" + i + "8;" + bufPos2 + ",0400,25,25,r,00,B;01,02|}").getBytes();
                    byte[] routeRC31 = this.ToUTF8("{RC1" + i + "8;" + firstLine + "|}").getBytes();
                    int position3 = 0;
                    routeBuffer2 = new byte[routePC31.length + routeRC31.length];
                    System.arraycopy(routePC31, 0, routeBuffer2, position3, routePC31.length);
                    System.arraycopy(routeRC31, 0, routeBuffer2, position3 += routePC31.length, routeRC31.length);
                    position3 += routeRC31.length;
                    if (lenListBuffer2.add(routeBuffer2)) {
                        // empty if block
                    }
                }
                if (strLen == 3) {
                    firstLine = routName[i].substring(0, 2);
                    String secLine = routName[i].substring(2, strLen);
                    int pos = 200 + 200 * i;
                    String bufPos3 = this.autoGenericCode(pos, 4);
                    byte[] routePC31 = this.ToUTF8("{PC3" + i + ";" + bufPos3 + ",0360,25,25,r,00,B;01,02|}").getBytes();
                    byte[] routeRC31 = this.ToUTF8("{RC3" + i + ";" + firstLine + "|}").getBytes();
                    byte[] routePC32 = this.ToUTF8("{PC1" + i + "1;" + bufPos3 + ",0430,25,25,r,00,B;01,02|}").getBytes();
                    byte[] routeRC32 = this.ToUTF8("{RC1" + i + "1;" + secLine + "|}").getBytes();
                    int position3 = 0;
                    routeBuffer3 = new byte[routePC31.length + routePC32.length + routeRC31.length + routeRC32.length];
                    System.arraycopy(routePC31, 0, routeBuffer3, position3, routePC31.length);
                    System.arraycopy(routeRC31, 0, routeBuffer3, position3 += routePC31.length, routeRC31.length);
                    System.arraycopy(routePC32, 0, routeBuffer3, position3 += routeRC31.length, routePC32.length);
                    System.arraycopy(routeRC32, 0, routeBuffer3, position3 += routePC32.length, routeRC32.length);
                    position3 += routeRC32.length;
                    if (lenListBuffer3.add(routeBuffer3)) {
                        // empty if block
                    }
                }
                if (strLen == 4) {
                    int position4 = 0;
                    String firstLine2 = routName[i].substring(0, 2);
                    String secLine = routName[i].substring(2, strLen);
                    int pos = 200 + 200 * i;
                    bufPos = this.autoGenericCode(pos, 4);
                    byte[] routePC41 = this.ToUTF8("{PC4" + i + ";" + bufPos + ",0360,25,25,r,00,B;01,02|}").getBytes();
                    byte[] routeRC41 = this.ToUTF8("{RC4" + i + ";" + firstLine2 + "|}").getBytes();
                    byte[] routePC42 = this.ToUTF8("{PC1" + i + "2;" + bufPos + ",0430,25,25,r,00,B;01,02|}").getBytes();
                    byte[] routeRC42 = this.ToUTF8("{RC1" + i + "2;" + secLine + "|}").getBytes();
                    routeBuffer4 = new byte[routePC41.length + routeRC41.length + routePC42.length + routeRC42.length];
                    System.arraycopy(routePC41, 0, routeBuffer4, position4, routePC41.length);
                    System.arraycopy(routeRC41, 0, routeBuffer4, position4 += routePC41.length, routeRC41.length);
                    System.arraycopy(routePC42, 0, routeBuffer4, position4 += routeRC41.length, routePC42.length);
                    System.arraycopy(routeRC42, 0, routeBuffer4, position4 += routePC42.length, routeRC42.length);
                    position4 += routeRC42.length;
                    if (lenListBuffer4.add(routeBuffer4)) {
                        // empty if block
                    }
                }
                if (strLen == 5) {
                    String firstLine3 = routName[i].substring(0, 3);
                    String secLine = routName[i].substring(3, strLen);
                    int pos = 200 + 200 * i;
                    String bufPos4 = this.autoGenericCode(pos, 4);
                    byte[] routePC51 = this.ToUTF8("{PC5" + i + ";" + bufPos4 + ",0360,20,20,r,00,B;01,02|}").getBytes();
                    byte[] routeRC51 = this.ToUTF8("{RC5" + i + ";" + firstLine3 + "|}").getBytes();
                    byte[] routePC52 = this.ToUTF8("{PC1" + i + "3;" + bufPos4 + ",0430,25,20,r,00,B;01,02|}").getBytes();
                    byte[] routeRC52 = this.ToUTF8("{RC1" + i + "3;" + secLine + "|}").getBytes();
                    int position5 = 0;
                    routeBuffer5 = new byte[routePC51.length + routePC52.length + routeRC51.length + routeRC52.length];
                    System.arraycopy(routePC51, 0, routeBuffer5, position5, routePC51.length);
                    System.arraycopy(routePC52, 0, routeBuffer5, position5 += routePC51.length, routePC52.length);
                    System.arraycopy(routeRC51, 0, routeBuffer5, position5 += routePC52.length, routeRC51.length);
                    System.arraycopy(routeRC52, 0, routeBuffer5, position5 += routeRC51.length, routeRC52.length);
                    position5 += routeRC52.length;
                    if (lenListBuffer5.add(routeBuffer5)) {
                        // empty if block
                    }
                }
                if (strLen == 6) {
                    String firstLine4 = routName[i].substring(0, 2);
                    String secLine = routName[i].substring(2, 4);
                    String thirdLine = routName[i].substring(4, strLen);
                    int pos = 200 + 200 * i;
                    bufPos = this.autoGenericCode(pos, 4);
                    byte[] routePC61 = this.ToUTF8("{PC6" + i + ";" + bufPos + ",0350,25,20,r,00,B;01,02|}").getBytes();
                    byte[] routeRC61 = this.ToUTF8("{RC6" + i + ";" + firstLine4 + "|}").getBytes();
                    byte[] routePC62 = this.ToUTF8("{PC1" + i + "4;" + bufPos + ",0390,25,20,r,00,B;01,02|}").getBytes();
                    byte[] routeRC62 = this.ToUTF8("{RC1" + i + "4;" + secLine + "|}").getBytes();
                    byte[] routePC63 = this.ToUTF8("{PC1" + i + "5;" + bufPos + ",0430,25,20,r,00,B;01,02|}").getBytes();
                    byte[] routeRC63 = this.ToUTF8("{RC1" + i + "5;" + thirdLine + "|}").getBytes();
                    int position6 = 0;
                    routeBuffer6 = new byte[routePC61.length + routePC62.length + routeRC62.length + routeRC62.length + routePC63.length + routeRC63.length];
                    System.arraycopy(routePC61, 0, routeBuffer6, position6, routePC61.length);
                    System.arraycopy(routePC62, 0, routeBuffer6, position6 += routePC61.length, routePC62.length);
                    System.arraycopy(routeRC62, 0, routeBuffer6, position6 += routePC62.length, routeRC62.length);
                    System.arraycopy(routeRC61, 0, routeBuffer6, position6 += routeRC62.length, routeRC61.length);
                    System.arraycopy(routePC63, 0, routeBuffer6, position6 += routeRC61.length, routePC63.length);
                    System.arraycopy(routeRC63, 0, routeBuffer6, position6 += routePC63.length, routeRC63.length);
                    position6 += routeRC63.length;
                    if (lenListBuffer6.add(routeBuffer6)) {
                        // empty if block
                    }
                }
                if (strLen < 7) continue;
                String firstLine5 = routName[i].substring(0, 4);
                String secLine = routName[i].substring(4, strLen);
                int pos = 200 + 200 * i;
                String bufPos5 = this.autoGenericCode(pos, 4);
                byte[] routePC71 = this.ToUTF8("{PC7" + i + ";" + bufPos5 + ",0360,20,20,r,00,B;01,02|}").getBytes();
                byte[] routeRC71 = this.ToUTF8("{RC7" + i + ";" + firstLine5 + "|}").getBytes();
                byte[] routePC72 = this.ToUTF8("{PC1" + i + "6;" + bufPos5 + ",0420,25,20,r,00,B;01,02|}").getBytes();
                byte[] routeRC72 = this.ToUTF8("{RC1" + i + "6;" + secLine + "|}").getBytes();
                int position7 = 0;
                routeBuffer7 = new byte[routePC71.length + routePC72.length + routeRC71.length + routeRC72.length];
                System.arraycopy(routePC71, 0, routeBuffer7, position7, routePC71.length);
                System.arraycopy(routePC72, 0, routeBuffer7, position7 += routePC71.length, routePC72.length);
                System.arraycopy(routeRC72, 0, routeBuffer7, position7 += routePC72.length, routeRC72.length);
                System.arraycopy(routeRC71, 0, routeBuffer7, position7 += routeRC72.length, routeRC71.length);
                position7 += routeRC71.length;
                if (!lenListBuffer7.add(routeBuffer7)) continue;
            }
            cmdBuffer = new byte[routeBuffer3.length * lenListBuffer3.size() + routeBuffer4.length * lenListBuffer4.size() + routeBuffer5.length * lenListBuffer5.size() + routeBuffer6.length * lenListBuffer6.size() + routeBuffer7.length * lenListBuffer7.size() + routeBuffer2.length * lenListBuffer2.size()];
            for (byte[] bs : lenListBuffer2) {
                System.arraycopy(bs, 0, cmdBuffer, position, bs.length);
                position += bs.length;
            }
            for (byte[] bs : lenListBuffer3) {
                System.arraycopy(bs, 0, cmdBuffer, position, bs.length);
                position += bs.length;
            }
            for (byte[] bs : lenListBuffer4) {
                System.arraycopy(bs, 0, cmdBuffer, position, bs.length);
                position += bs.length;
            }
            for (byte[] bs : lenListBuffer5) {
                System.arraycopy(bs, 0, cmdBuffer, position, bs.length);
                position += bs.length;
            }
            for (byte[] bs : lenListBuffer6) {
                System.arraycopy(bs, 0, cmdBuffer, position, bs.length);
                position += bs.length;
            }
            for (byte[] bs : lenListBuffer7) {
                System.arraycopy(bs, 0, cmdBuffer, position, bs.length);
                position += bs.length;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return cmdBuffer;
    }

    private byte[] handlerSixline() {
        int pos = 0;
        byte[] Buffer2 = null;
        byte[] cmdPC55 = this.ToUTF8("{PC55;0300,0400,15,15,r,00,B;01,02|}").getBytes();
        byte[] cmdRC55 = this.ToUTF8("{RC55;-|}").getBytes();
        byte[] cmdPC56 = this.ToUTF8("{PC56;0430,0400,15,15,r,00,B;01,02|}").getBytes();
        byte[] cmdRC56 = this.ToUTF8("{RC56;-|}").getBytes();
        byte[] cmdPC57 = this.ToUTF8("{PC57;0570,0400,15,15,r,00,B;01,02|}").getBytes();
        byte[] cmdRC57 = this.ToUTF8("{RC57;-|}").getBytes();
        byte[] cmdPC58 = this.ToUTF8("{PC58;0690,0400,15,15,r,00,B;01,02|}").getBytes();
        byte[] cmdRC58 = this.ToUTF8("{RC58;-|}").getBytes();
        byte[] cmdPC59 = this.ToUTF8("{PC59;0820,0400,15,15,r,00,B;01,02|}").getBytes();
        byte[] cmdRC59 = this.ToUTF8("{RC59;-|}").getBytes();
        Buffer2 = new byte[cmdPC55.length + cmdPC56.length + cmdPC57.length + cmdPC58.length + cmdRC55.length + cmdRC56.length + cmdRC57.length + cmdRC58.length + cmdPC59.length + cmdRC59.length];
        System.arraycopy(cmdPC55, 0, Buffer2, pos, cmdPC55.length);
        System.arraycopy(cmdRC55, 0, Buffer2, pos += cmdPC55.length, cmdRC55.length);
        System.arraycopy(cmdPC56, 0, Buffer2, pos += cmdRC55.length, cmdPC56.length);
        System.arraycopy(cmdRC56, 0, Buffer2, pos += cmdPC56.length, cmdRC56.length);
        System.arraycopy(cmdPC57, 0, Buffer2, pos += cmdRC56.length, cmdPC57.length);
        System.arraycopy(cmdRC57, 0, Buffer2, pos += cmdPC57.length, cmdRC57.length);
        System.arraycopy(cmdPC58, 0, Buffer2, pos += cmdRC57.length, cmdPC58.length);
        System.arraycopy(cmdRC58, 0, Buffer2, pos += cmdPC58.length, cmdRC58.length);
        System.arraycopy(cmdPC59, 0, Buffer2, pos += cmdRC58.length, cmdPC59.length);
        System.arraycopy(cmdRC59, 0, Buffer2, pos += cmdPC59.length, cmdRC59.length);
        pos += cmdRC59.length;
        return Buffer2;
    }

    private byte[] handlerSixRouter(String[] routName) {
        byte[] cmdBuffer = null;
        int position = 0;
        try {
            byte[] routeBuffer2 = new byte[]{};
            byte[] routeBuffer3 = new byte[]{};
            byte[] routeBuffer4 = new byte[]{};
            byte[] routeBuffer5 = new byte[]{};
            byte[] routeBuffer6 = new byte[]{};
            byte[] routeBuffer7 = new byte[]{};
            ArrayList<byte[]> lenListBuffer5 = new ArrayList<byte[]>();
            ArrayList<byte[]> lenListBuffer2 = new ArrayList<byte[]>();
            ArrayList<byte[]> lenListBuffer3 = new ArrayList<byte[]>();
            ArrayList<byte[]> lenListBuffer4 = new ArrayList<byte[]>();
            ArrayList<byte[]> lenListBuffer6 = new ArrayList<byte[]>();
            ArrayList<byte[]> lenListBuffer7 = new ArrayList<byte[]>();
            for (int i = 0; i < routName.length; ++i) {
                String bufPos;
                String firstLine;
                int strLen = routName[i].length();
                if (strLen == 2) {
                    firstLine = routName[i].substring(0, strLen);
                    int pos = 200 + 130 * i;
                    String bufPos2 = this.autoGenericCode(pos, 4);
                    byte[] routePC31 = this.ToUTF8("{PC1" + i + "8;" + bufPos2 + ",0400,20,20,r,00,B;01,02|}").getBytes();
                    byte[] routeRC31 = this.ToUTF8("{RC1" + i + "8;" + firstLine + "|}").getBytes();
                    int position3 = 0;
                    routeBuffer2 = new byte[routePC31.length + routeRC31.length];
                    System.arraycopy(routePC31, 0, routeBuffer2, position3, routePC31.length);
                    System.arraycopy(routeRC31, 0, routeBuffer2, position3 += routePC31.length, routeRC31.length);
                    position3 += routeRC31.length;
                    if (lenListBuffer2.add(routeBuffer2)) {
                        // empty if block
                    }
                }
                if (strLen == 3) {
                    firstLine = routName[i].substring(0, 2);
                    String secLine = routName[i].substring(2, strLen);
                    int pos = 200 + 130 * i;
                    String bufPos3 = this.autoGenericCode(pos, 4);
                    byte[] routePC31 = this.ToUTF8("{PC3" + i + ";" + bufPos3 + ",0360,20,20,r,00,B;01,02|}").getBytes();
                    byte[] routeRC31 = this.ToUTF8("{RC3" + i + ";" + firstLine + "|}").getBytes();
                    byte[] routePC32 = this.ToUTF8("{PC1" + i + "1;" + bufPos3 + ",0430,20,20,r,00,B;01,02|}").getBytes();
                    byte[] routeRC32 = this.ToUTF8("{RC1" + i + "1;" + secLine + "|}").getBytes();
                    int position3 = 0;
                    routeBuffer3 = new byte[routePC31.length + routePC32.length + routeRC31.length + routeRC32.length];
                    System.arraycopy(routePC31, 0, routeBuffer3, position3, routePC31.length);
                    System.arraycopy(routeRC31, 0, routeBuffer3, position3 += routePC31.length, routeRC31.length);
                    System.arraycopy(routePC32, 0, routeBuffer3, position3 += routeRC31.length, routePC32.length);
                    System.arraycopy(routeRC32, 0, routeBuffer3, position3 += routePC32.length, routeRC32.length);
                    position3 += routeRC32.length;
                    if (lenListBuffer3.add(routeBuffer3)) {
                        // empty if block
                    }
                }
                if (strLen == 4) {
                    int position4 = 0;
                    String firstLine2 = routName[i].substring(0, 2);
                    String secLine = routName[i].substring(2, strLen);
                    int pos = 200 + 130 * i;
                    bufPos = this.autoGenericCode(pos, 4);
                    byte[] routePC41 = this.ToUTF8("{PC4" + i + ";" + bufPos + ",0360,20,20,r,00,B;01,02|}").getBytes();
                    byte[] routeRC41 = this.ToUTF8("{RC4" + i + ";" + firstLine2 + "|}").getBytes();
                    byte[] routePC42 = this.ToUTF8("{PC1" + i + "2;" + bufPos + ",0430,20,20,r,00,B;01,02|}").getBytes();
                    byte[] routeRC42 = this.ToUTF8("{RC1" + i + "2;" + secLine + "|}").getBytes();
                    routeBuffer4 = new byte[routePC41.length + routeRC41.length + routePC42.length + routeRC42.length];
                    System.arraycopy(routePC41, 0, routeBuffer4, position4, routePC41.length);
                    System.arraycopy(routeRC41, 0, routeBuffer4, position4 += routePC41.length, routeRC41.length);
                    System.arraycopy(routePC42, 0, routeBuffer4, position4 += routeRC41.length, routePC42.length);
                    System.arraycopy(routeRC42, 0, routeBuffer4, position4 += routePC42.length, routeRC42.length);
                    position4 += routeRC42.length;
                    if (lenListBuffer4.add(routeBuffer4)) {
                        // empty if block
                    }
                }
                if (strLen == 5) {
                    String firstLine3 = routName[i].substring(0, 3);
                    String secLine = routName[i].substring(3, strLen);
                    int pos = 200 + 130 * i;
                    String bufPos4 = this.autoGenericCode(pos, 4);
                    byte[] routePC51 = this.ToUTF8("{PC5" + i + ";" + bufPos4 + ",0360,20,20,r,00,B;01,02|}").getBytes();
                    byte[] routeRC51 = this.ToUTF8("{RC5" + i + ";" + firstLine3 + "|}").getBytes();
                    byte[] routePC52 = this.ToUTF8("{PC1" + i + "3;" + bufPos4 + ",0430,20,20,r,00,B;01,02|}").getBytes();
                    byte[] routeRC52 = this.ToUTF8("{RC1" + i + "3;" + secLine + "|}").getBytes();
                    int position5 = 0;
                    routeBuffer5 = new byte[routePC51.length + routePC52.length + routeRC51.length + routeRC52.length];
                    System.arraycopy(routePC51, 0, routeBuffer5, position5, routePC51.length);
                    System.arraycopy(routePC52, 0, routeBuffer5, position5 += routePC51.length, routePC52.length);
                    System.arraycopy(routeRC51, 0, routeBuffer5, position5 += routePC52.length, routeRC51.length);
                    System.arraycopy(routeRC52, 0, routeBuffer5, position5 += routeRC51.length, routeRC52.length);
                    position5 += routeRC52.length;
                    if (lenListBuffer5.add(routeBuffer5)) {
                        // empty if block
                    }
                }
                if (strLen == 6) {
                    String firstLine4 = routName[i].substring(0, 2);
                    String secLine = routName[i].substring(2, 4);
                    String thirdLine = routName[i].substring(4, strLen);
                    int pos = 200 + 130 * i;
                    bufPos = this.autoGenericCode(pos, 4);
                    byte[] routePC61 = this.ToUTF8("{PC6" + i + ";" + bufPos + ",0350,20,20,r,00,B;01,02|}").getBytes();
                    byte[] routeRC61 = this.ToUTF8("{RC6" + i + ";" + firstLine4 + "|}").getBytes();
                    byte[] routePC62 = this.ToUTF8("{PC1" + i + "4;" + bufPos + ",0390,20,20,r,00,B;01,02|}").getBytes();
                    byte[] routeRC62 = this.ToUTF8("{RC1" + i + "4;" + secLine + "|}").getBytes();
                    byte[] routePC63 = this.ToUTF8("{PC1" + i + "5;" + bufPos + ",0430,25,20,r,00,B;01,02|}").getBytes();
                    byte[] routeRC63 = this.ToUTF8("{RC1" + i + "5;" + thirdLine + "|}").getBytes();
                    int position6 = 0;
                    routeBuffer6 = new byte[routePC61.length + routePC62.length + routeRC62.length + routeRC62.length + routePC63.length + routeRC63.length];
                    System.arraycopy(routePC61, 0, routeBuffer6, position6, routePC61.length);
                    System.arraycopy(routePC62, 0, routeBuffer6, position6 += routePC61.length, routePC62.length);
                    System.arraycopy(routeRC62, 0, routeBuffer6, position6 += routePC62.length, routeRC62.length);
                    System.arraycopy(routeRC61, 0, routeBuffer6, position6 += routeRC62.length, routeRC61.length);
                    System.arraycopy(routePC63, 0, routeBuffer6, position6 += routeRC61.length, routePC63.length);
                    System.arraycopy(routeRC63, 0, routeBuffer6, position6 += routePC63.length, routeRC63.length);
                    position6 += routeRC63.length;
                    if (lenListBuffer6.add(routeBuffer6)) {
                        // empty if block
                    }
                }
                if (strLen < 7) continue;
                String firstLine5 = routName[i].substring(0, 4);
                String secLine = routName[i].substring(4, strLen);
                int pos = 200 + 130 * i;
                String bufPos5 = this.autoGenericCode(pos, 4);
                byte[] routePC71 = this.ToUTF8("{PC7" + i + ";" + bufPos5 + ",0360,15,20,r,00,B;01,02|}").getBytes();
                byte[] routeRC71 = this.ToUTF8("{RC7" + i + ";" + firstLine5 + "|}").getBytes();
                byte[] routePC72 = this.ToUTF8("{PC1" + i + "6;" + bufPos5 + ",0420,15,20,r,00,B;01,02|}").getBytes();
                byte[] routeRC72 = this.ToUTF8("{RC1" + i + "6;" + secLine + "|}").getBytes();
                int position7 = 0;
                routeBuffer7 = new byte[routePC71.length + routePC72.length + routeRC71.length + routeRC72.length];
                System.arraycopy(routePC71, 0, routeBuffer7, position7, routePC71.length);
                System.arraycopy(routePC72, 0, routeBuffer7, position7 += routePC71.length, routePC72.length);
                System.arraycopy(routeRC72, 0, routeBuffer7, position7 += routePC72.length, routeRC72.length);
                System.arraycopy(routeRC71, 0, routeBuffer7, position7 += routeRC72.length, routeRC71.length);
                position7 += routeRC71.length;
                if (!lenListBuffer7.add(routeBuffer7)) continue;
            }
            cmdBuffer = new byte[routeBuffer3.length * lenListBuffer3.size() + routeBuffer4.length * lenListBuffer4.size() + routeBuffer5.length * lenListBuffer5.size() + routeBuffer6.length * lenListBuffer6.size() + routeBuffer7.length * lenListBuffer7.size() + routeBuffer2.length * lenListBuffer2.size()];
            for (byte[] bs : lenListBuffer2) {
                System.arraycopy(bs, 0, cmdBuffer, position, bs.length);
                position += bs.length;
            }
            for (byte[] bs : lenListBuffer3) {
                System.arraycopy(bs, 0, cmdBuffer, position, bs.length);
                position += bs.length;
            }
            for (byte[] bs : lenListBuffer4) {
                System.arraycopy(bs, 0, cmdBuffer, position, bs.length);
                position += bs.length;
            }
            for (byte[] bs : lenListBuffer5) {
                System.arraycopy(bs, 0, cmdBuffer, position, bs.length);
                position += bs.length;
            }
            for (byte[] bs : lenListBuffer6) {
                System.arraycopy(bs, 0, cmdBuffer, position, bs.length);
                position += bs.length;
            }
            for (byte[] bs : lenListBuffer7) {
                System.arraycopy(bs, 0, cmdBuffer, position, bs.length);
                position += bs.length;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return cmdBuffer;
    }

    private byte[] handlerthreeline() {
        int pos = 0;
        byte[] Buffer2 = null;
        byte[] cmdPC33 = this.ToUTF8("{PC44;0365,0400,25,25,r,00,B;01,02|}").getBytes();
        byte[] cmdRC33 = this.ToUTF8("{RC44;-|}").getBytes();
        byte[] cmdPC34 = this.ToUTF8("{PC45;0630,0400,25,25,r,00,B;01,02|}").getBytes();
        byte[] cmdRC34 = this.ToUTF8("{RC45;-|}").getBytes();
        Buffer2 = new byte[cmdPC33.length + cmdPC34.length + cmdRC33.length + cmdRC34.length];
        System.arraycopy(cmdPC33, 0, Buffer2, pos, cmdPC33.length);
        System.arraycopy(cmdRC33, 0, Buffer2, pos += cmdPC33.length, cmdRC33.length);
        System.arraycopy(cmdPC34, 0, Buffer2, pos += cmdRC33.length, cmdPC34.length);
        System.arraycopy(cmdRC34, 0, Buffer2, pos += cmdPC34.length, cmdRC34.length);
        pos += cmdRC34.length;
        return Buffer2;
    }

    private byte[] handlerThreeRouter(String[] routName) {
        byte[] cmdBuffer = null;
        int position = 0;
        try {
            byte[] routeBuffer2 = new byte[]{};
            byte[] routeBuffer3 = new byte[]{};
            byte[] routeBuffer4 = new byte[]{};
            byte[] routeBuffer5 = new byte[]{};
            byte[] routeBuffer6 = new byte[]{};
            byte[] routeBuffer7 = new byte[]{};
            ArrayList<byte[]> lenListBuffer5 = new ArrayList<byte[]>();
            ArrayList<byte[]> lenListBuffer2 = new ArrayList<byte[]>();
            ArrayList<byte[]> lenListBuffer3 = new ArrayList<byte[]>();
            ArrayList<byte[]> lenListBuffer4 = new ArrayList<byte[]>();
            ArrayList<byte[]> lenListBuffer6 = new ArrayList<byte[]>();
            ArrayList<byte[]> lenListBuffer7 = new ArrayList<byte[]>();
            for (int i = 0; i < routName.length; ++i) {
                String bufPos;
                String firstLine;
                int strLen = routName[i].length();
                if (strLen == 2) {
                    firstLine = routName[i].substring(0, strLen);
                    int pos = 200 + 260 * i;
                    String bufPos2 = this.autoGenericCode(pos, 4);
                    byte[] routePC31 = this.ToUTF8("{PC1" + i + "8;" + bufPos2 + ",0400,25,25,r,00,B;01,02|}").getBytes();
                    byte[] routeRC31 = this.ToUTF8("{RC1" + i + "8;" + firstLine + "|}").getBytes();
                    int position3 = 0;
                    routeBuffer2 = new byte[routePC31.length + routeRC31.length];
                    System.arraycopy(routePC31, 0, routeBuffer2, position3, routePC31.length);
                    System.arraycopy(routeRC31, 0, routeBuffer2, position3 += routePC31.length, routeRC31.length);
                    position3 += routeRC31.length;
                    if (lenListBuffer2.add(routeBuffer2)) {
                        // empty if block
                    }
                }
                if (strLen == 3) {
                    firstLine = routName[i].substring(0, 2);
                    String secLine = routName[i].substring(2, strLen);
                    int pos = 200 + 260 * i;
                    String bufPos3 = this.autoGenericCode(pos, 4);
                    byte[] routePC31 = this.ToUTF8("{PC3" + i + ";" + bufPos3 + ",0360,25,25,r,00,B;01,02|}").getBytes();
                    byte[] routeRC31 = this.ToUTF8("{RC3" + i + ";" + firstLine + "|}").getBytes();
                    byte[] routePC32 = this.ToUTF8("{PC1" + i + "1;" + bufPos3 + ",0430,25,25,r,00,B;01,02|}").getBytes();
                    byte[] routeRC32 = this.ToUTF8("{RC1" + i + "1;" + secLine + "|}").getBytes();
                    int position3 = 0;
                    routeBuffer3 = new byte[routePC31.length + routePC32.length + routeRC31.length + routeRC32.length];
                    System.arraycopy(routePC31, 0, routeBuffer3, position3, routePC31.length);
                    System.arraycopy(routeRC31, 0, routeBuffer3, position3 += routePC31.length, routeRC31.length);
                    System.arraycopy(routePC32, 0, routeBuffer3, position3 += routeRC31.length, routePC32.length);
                    System.arraycopy(routeRC32, 0, routeBuffer3, position3 += routePC32.length, routeRC32.length);
                    position3 += routeRC32.length;
                    if (lenListBuffer3.add(routeBuffer3)) {
                        // empty if block
                    }
                }
                if (strLen == 4) {
                    int position4 = 0;
                    String firstLine2 = routName[i].substring(0, 2);
                    String secLine = routName[i].substring(2, strLen);
                    int pos = 200 + 260 * i;
                    bufPos = this.autoGenericCode(pos, 4);
                    byte[] routePC41 = this.ToUTF8("{PC4" + i + ";" + bufPos + ",0360,25,25,r,00,B;01,02|}").getBytes();
                    byte[] routeRC41 = this.ToUTF8("{RC4" + i + ";" + firstLine2 + "|}").getBytes();
                    byte[] routePC42 = this.ToUTF8("{PC1" + i + "2;" + bufPos + ",0430,25,25,r,00,B;01,02|}").getBytes();
                    byte[] routeRC42 = this.ToUTF8("{RC1" + i + "2;" + secLine + "|}").getBytes();
                    routeBuffer4 = new byte[routePC41.length + routeRC41.length + routePC42.length + routeRC42.length];
                    System.arraycopy(routePC41, 0, routeBuffer4, position4, routePC41.length);
                    System.arraycopy(routeRC41, 0, routeBuffer4, position4 += routePC41.length, routeRC41.length);
                    System.arraycopy(routePC42, 0, routeBuffer4, position4 += routeRC41.length, routePC42.length);
                    System.arraycopy(routeRC42, 0, routeBuffer4, position4 += routePC42.length, routeRC42.length);
                    position4 += routeRC42.length;
                    if (lenListBuffer4.add(routeBuffer4)) {
                        // empty if block
                    }
                }
                if (strLen == 5) {
                    String firstLine3 = routName[i].substring(0, 3);
                    String secLine = routName[i].substring(3, strLen);
                    int pos = 200 + 260 * i;
                    String bufPos4 = this.autoGenericCode(pos, 4);
                    byte[] routePC51 = this.ToUTF8("{PC5" + i + ";" + bufPos4 + ",0360,20,20,r,00,B;01,02|}").getBytes();
                    byte[] routeRC51 = this.ToUTF8("{RC5" + i + ";" + firstLine3 + "|}").getBytes();
                    byte[] routePC52 = this.ToUTF8("{PC1" + i + "3;" + bufPos4 + ",0430,25,20,r,00,B;01,02|}").getBytes();
                    byte[] routeRC52 = this.ToUTF8("{RC1" + i + "3;" + secLine + "|}").getBytes();
                    int position5 = 0;
                    routeBuffer5 = new byte[routePC51.length + routePC52.length + routeRC51.length + routeRC52.length];
                    System.arraycopy(routePC51, 0, routeBuffer5, position5, routePC51.length);
                    System.arraycopy(routePC52, 0, routeBuffer5, position5 += routePC51.length, routePC52.length);
                    System.arraycopy(routeRC51, 0, routeBuffer5, position5 += routePC52.length, routeRC51.length);
                    System.arraycopy(routeRC52, 0, routeBuffer5, position5 += routeRC51.length, routeRC52.length);
                    position5 += routeRC52.length;
                    if (lenListBuffer5.add(routeBuffer5)) {
                        // empty if block
                    }
                }
                if (strLen == 6) {
                    String firstLine4 = routName[i].substring(0, 2);
                    String secLine = routName[i].substring(2, 4);
                    String thirdLine = routName[i].substring(4, strLen);
                    int pos = 200 + 260 * i;
                    bufPos = this.autoGenericCode(pos, 4);
                    byte[] routePC61 = this.ToUTF8("{PC6" + i + ";" + bufPos + ",0350,25,20,r,00,B;01,02|}").getBytes();
                    byte[] routeRC61 = this.ToUTF8("{RC6" + i + ";" + firstLine4 + "|}").getBytes();
                    byte[] routePC62 = this.ToUTF8("{PC1" + i + "4;" + bufPos + ",0390,25,20,r,00,B;01,02|}").getBytes();
                    byte[] routeRC62 = this.ToUTF8("{RC1" + i + "4;" + secLine + "|}").getBytes();
                    byte[] routePC63 = this.ToUTF8("{PC1" + i + "5;" + bufPos + ",0430,25,20,r,00,B;01,02|}").getBytes();
                    byte[] routeRC63 = this.ToUTF8("{RC1" + i + "5;" + thirdLine + "|}").getBytes();
                    int position6 = 0;
                    routeBuffer6 = new byte[routePC61.length + routePC62.length + routeRC62.length + routeRC62.length + routePC63.length + routeRC63.length];
                    System.arraycopy(routePC61, 0, routeBuffer6, position6, routePC61.length);
                    System.arraycopy(routePC62, 0, routeBuffer6, position6 += routePC61.length, routePC62.length);
                    System.arraycopy(routeRC62, 0, routeBuffer6, position6 += routePC62.length, routeRC62.length);
                    System.arraycopy(routeRC61, 0, routeBuffer6, position6 += routeRC62.length, routeRC61.length);
                    System.arraycopy(routePC63, 0, routeBuffer6, position6 += routeRC61.length, routePC63.length);
                    System.arraycopy(routeRC63, 0, routeBuffer6, position6 += routePC63.length, routeRC63.length);
                    position6 += routeRC63.length;
                    if (lenListBuffer6.add(routeBuffer6)) {
                        // empty if block
                    }
                }
                if (strLen < 7) continue;
                String firstLine5 = routName[i].substring(0, 4);
                String secLine = routName[i].substring(4, strLen);
                int pos = 200 + 260 * i;
                String bufPos5 = this.autoGenericCode(pos, 4);
                byte[] routePC71 = this.ToUTF8("{PC7" + i + ";" + bufPos5 + ",0360,20,20,r,00,B;01,02|}").getBytes();
                byte[] routeRC71 = this.ToUTF8("{RC7" + i + ";" + firstLine5 + "|}").getBytes();
                byte[] routePC72 = this.ToUTF8("{PC1" + i + "6;" + bufPos5 + ",0420,25,20,r,00,B;01,02|}").getBytes();
                byte[] routeRC72 = this.ToUTF8("{RC1" + i + "6;" + secLine + "|}").getBytes();
                int position7 = 0;
                routeBuffer7 = new byte[routePC71.length + routePC72.length + routeRC71.length + routeRC72.length];
                System.arraycopy(routePC71, 0, routeBuffer7, position7, routePC71.length);
                System.arraycopy(routePC72, 0, routeBuffer7, position7 += routePC71.length, routePC72.length);
                System.arraycopy(routeRC72, 0, routeBuffer7, position7 += routePC72.length, routeRC72.length);
                System.arraycopy(routeRC71, 0, routeBuffer7, position7 += routeRC72.length, routeRC71.length);
                position7 += routeRC71.length;
                if (!lenListBuffer7.add(routeBuffer7)) continue;
            }
            cmdBuffer = new byte[routeBuffer3.length * lenListBuffer3.size() + routeBuffer4.length * lenListBuffer4.size() + routeBuffer5.length * lenListBuffer5.size() + routeBuffer6.length * lenListBuffer6.size() + routeBuffer7.length * lenListBuffer7.size() + routeBuffer2.length * lenListBuffer2.size()];
            for (byte[] bs : lenListBuffer2) {
                System.arraycopy(bs, 0, cmdBuffer, position, bs.length);
                position += bs.length;
            }
            for (byte[] bs : lenListBuffer3) {
                System.arraycopy(bs, 0, cmdBuffer, position, bs.length);
                position += bs.length;
            }
            for (byte[] bs : lenListBuffer4) {
                System.arraycopy(bs, 0, cmdBuffer, position, bs.length);
                position += bs.length;
            }
            for (byte[] bs : lenListBuffer5) {
                System.arraycopy(bs, 0, cmdBuffer, position, bs.length);
                position += bs.length;
            }
            for (byte[] bs : lenListBuffer6) {
                System.arraycopy(bs, 0, cmdBuffer, position, bs.length);
                position += bs.length;
            }
            for (byte[] bs : lenListBuffer7) {
                System.arraycopy(bs, 0, cmdBuffer, position, bs.length);
                position += bs.length;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return cmdBuffer;
    }

    private byte[] handlertwoline() {
        int pos = 0;
        byte[] Buffer2 = null;
        byte[] cmdPC33 = this.ToUTF8("{PC44;0580,0400,25,25,r,00,B;01,02|}").getBytes();
        byte[] cmdRC33 = this.ToUTF8("{RC44;-|}").getBytes();
        Buffer2 = new byte[cmdPC33.length + cmdRC33.length];
        System.arraycopy(cmdPC33, 0, Buffer2, pos, cmdPC33.length);
        System.arraycopy(cmdRC33, 0, Buffer2, pos += cmdPC33.length, cmdRC33.length);
        pos += cmdRC33.length;
        return Buffer2;
    }

    private byte[] handlerTwoRouter(String[] routName) {
        byte[] cmdBuffer = null;
        int position = 0;
        try {
            byte[] routeBuffer2 = new byte[]{};
            byte[] routeBuffer3 = new byte[]{};
            byte[] routeBuffer4 = new byte[]{};
            byte[] routeBuffer5 = new byte[]{};
            byte[] routeBuffer6 = new byte[]{};
            byte[] routeBuffer7 = new byte[]{};
            ArrayList<byte[]> lenListBuffer5 = new ArrayList<byte[]>();
            ArrayList<byte[]> lenListBuffer2 = new ArrayList<byte[]>();
            ArrayList<byte[]> lenListBuffer3 = new ArrayList<byte[]>();
            ArrayList<byte[]> lenListBuffer4 = new ArrayList<byte[]>();
            ArrayList<byte[]> lenListBuffer6 = new ArrayList<byte[]>();
            ArrayList<byte[]> lenListBuffer7 = new ArrayList<byte[]>();
            for (int i = 0; i < routName.length; ++i) {
                String bufPos;
                String firstLine;
                int strLen = routName[i].length();
                if (strLen == 2) {
                    firstLine = routName[i].substring(0, strLen);
                    int pos = 200 + 400 * i;
                    String bufPos2 = this.autoGenericCode(pos, 4);
                    byte[] routePC31 = this.ToUTF8("{PC1" + i + "8;" + bufPos2 + ",0400,25,25,r,00,B;01,02|}").getBytes();
                    byte[] routeRC31 = this.ToUTF8("{RC1" + i + "8;" + firstLine + "|}").getBytes();
                    int position3 = 0;
                    routeBuffer2 = new byte[routePC31.length + routeRC31.length];
                    System.arraycopy(routePC31, 0, routeBuffer2, position3, routePC31.length);
                    System.arraycopy(routeRC31, 0, routeBuffer2, position3 += routePC31.length, routeRC31.length);
                    position3 += routeRC31.length;
                    if (lenListBuffer2.add(routeBuffer2)) {
                        // empty if block
                    }
                }
                if (strLen == 3) {
                    firstLine = routName[i].substring(0, 2);
                    String secLine = routName[i].substring(2, strLen);
                    int pos = 200 + 400 * i;
                    String bufPos3 = this.autoGenericCode(pos, 4);
                    byte[] routePC31 = this.ToUTF8("{PC3" + i + ";" + bufPos3 + ",0360,25,25,r,00,B;01,02|}").getBytes();
                    byte[] routeRC31 = this.ToUTF8("{RC3" + i + ";" + firstLine + "|}").getBytes();
                    byte[] routePC32 = this.ToUTF8("{PC1" + i + "1;" + bufPos3 + ",0430,25,25,r,00,B;01,02|}").getBytes();
                    byte[] routeRC32 = this.ToUTF8("{RC1" + i + "1;" + secLine + "|}").getBytes();
                    int position3 = 0;
                    routeBuffer3 = new byte[routePC31.length + routePC32.length + routeRC31.length + routeRC32.length];
                    System.arraycopy(routePC31, 0, routeBuffer3, position3, routePC31.length);
                    System.arraycopy(routeRC31, 0, routeBuffer3, position3 += routePC31.length, routeRC31.length);
                    System.arraycopy(routePC32, 0, routeBuffer3, position3 += routeRC31.length, routePC32.length);
                    System.arraycopy(routeRC32, 0, routeBuffer3, position3 += routePC32.length, routeRC32.length);
                    position3 += routeRC32.length;
                    if (lenListBuffer3.add(routeBuffer3)) {
                        // empty if block
                    }
                }
                if (strLen == 4) {
                    int position4 = 0;
                    String firstLine2 = routName[i].substring(0, 2);
                    String secLine = routName[i].substring(2, strLen);
                    int pos = 200 + 400 * i;
                    bufPos = this.autoGenericCode(pos, 4);
                    byte[] routePC41 = this.ToUTF8("{PC4" + i + ";" + bufPos + ",0360,25,25,r,00,B;01,02|}").getBytes();
                    byte[] routeRC41 = this.ToUTF8("{RC4" + i + ";" + firstLine2 + "|}").getBytes();
                    byte[] routePC42 = this.ToUTF8("{PC1" + i + "2;" + bufPos + ",0430,25,25,r,00,B;01,02|}").getBytes();
                    byte[] routeRC42 = this.ToUTF8("{RC1" + i + "2;" + secLine + "|}").getBytes();
                    routeBuffer4 = new byte[routePC41.length + routeRC41.length + routePC42.length + routeRC42.length];
                    System.arraycopy(routePC41, 0, routeBuffer4, position4, routePC41.length);
                    System.arraycopy(routeRC41, 0, routeBuffer4, position4 += routePC41.length, routeRC41.length);
                    System.arraycopy(routePC42, 0, routeBuffer4, position4 += routeRC41.length, routePC42.length);
                    System.arraycopy(routeRC42, 0, routeBuffer4, position4 += routePC42.length, routeRC42.length);
                    position4 += routeRC42.length;
                    if (lenListBuffer4.add(routeBuffer4)) {
                        // empty if block
                    }
                }
                if (strLen == 5) {
                    String firstLine3 = routName[i].substring(0, 3);
                    String secLine = routName[i].substring(3, strLen);
                    int pos = 200 + 400 * i;
                    String bufPos4 = this.autoGenericCode(pos, 4);
                    byte[] routePC51 = this.ToUTF8("{PC5" + i + ";" + bufPos4 + ",0360,20,20,r,00,B;01,02|}").getBytes();
                    byte[] routeRC51 = this.ToUTF8("{RC5" + i + ";" + firstLine3 + "|}").getBytes();
                    byte[] routePC52 = this.ToUTF8("{PC1" + i + "3;" + bufPos4 + ",0430,25,20,r,00,B;01,02|}").getBytes();
                    byte[] routeRC52 = this.ToUTF8("{RC1" + i + "3;" + secLine + "|}").getBytes();
                    int position5 = 0;
                    routeBuffer5 = new byte[routePC51.length + routePC52.length + routeRC51.length + routeRC52.length];
                    System.arraycopy(routePC51, 0, routeBuffer5, position5, routePC51.length);
                    System.arraycopy(routePC52, 0, routeBuffer5, position5 += routePC51.length, routePC52.length);
                    System.arraycopy(routeRC51, 0, routeBuffer5, position5 += routePC52.length, routeRC51.length);
                    System.arraycopy(routeRC52, 0, routeBuffer5, position5 += routeRC51.length, routeRC52.length);
                    position5 += routeRC52.length;
                    if (lenListBuffer5.add(routeBuffer5)) {
                        // empty if block
                    }
                }
                if (strLen == 6) {
                    String firstLine4 = routName[i].substring(0, 2);
                    String secLine = routName[i].substring(2, 4);
                    String thirdLine = routName[i].substring(4, strLen);
                    int pos = 200 + 400 * i;
                    bufPos = this.autoGenericCode(pos, 4);
                    byte[] routePC61 = this.ToUTF8("{PC6" + i + ";" + bufPos + ",0350,25,20,r,00,B;01,02|}").getBytes();
                    byte[] routeRC61 = this.ToUTF8("{RC6" + i + ";" + firstLine4 + "|}").getBytes();
                    byte[] routePC62 = this.ToUTF8("{PC1" + i + "4;" + bufPos + ",0390,25,20,r,00,B;01,02|}").getBytes();
                    byte[] routeRC62 = this.ToUTF8("{RC1" + i + "4;" + secLine + "|}").getBytes();
                    byte[] routePC63 = this.ToUTF8("{PC1" + i + "5;" + bufPos + ",0430,25,20,r,00,B;01,02|}").getBytes();
                    byte[] routeRC63 = this.ToUTF8("{RC1" + i + "5;" + thirdLine + "|}").getBytes();
                    int position6 = 0;
                    routeBuffer6 = new byte[routePC61.length + routePC62.length + routeRC62.length + routeRC62.length + routePC63.length + routeRC63.length];
                    System.arraycopy(routePC61, 0, routeBuffer6, position6, routePC61.length);
                    System.arraycopy(routePC62, 0, routeBuffer6, position6 += routePC61.length, routePC62.length);
                    System.arraycopy(routeRC62, 0, routeBuffer6, position6 += routePC62.length, routeRC62.length);
                    System.arraycopy(routeRC61, 0, routeBuffer6, position6 += routeRC62.length, routeRC61.length);
                    System.arraycopy(routePC63, 0, routeBuffer6, position6 += routeRC61.length, routePC63.length);
                    System.arraycopy(routeRC63, 0, routeBuffer6, position6 += routePC63.length, routeRC63.length);
                    position6 += routeRC63.length;
                    if (lenListBuffer6.add(routeBuffer6)) {
                        // empty if block
                    }
                }
                if (strLen < 7) continue;
                String firstLine5 = routName[i].substring(0, 4);
                String secLine = routName[i].substring(4, strLen);
                int pos = 200 + 400 * i;
                String bufPos5 = this.autoGenericCode(pos, 4);
                byte[] routePC71 = this.ToUTF8("{PC7" + i + ";" + bufPos5 + ",0360,20,20,r,00,B;01,02|}").getBytes();
                byte[] routeRC71 = this.ToUTF8("{RC7" + i + ";" + firstLine5 + "|}").getBytes();
                byte[] routePC72 = this.ToUTF8("{PC1" + i + "6;" + bufPos5 + ",0420,25,20,r,00,B;01,02|}").getBytes();
                byte[] routeRC72 = this.ToUTF8("{RC1" + i + "6;" + secLine + "|}").getBytes();
                int position7 = 0;
                routeBuffer7 = new byte[routePC71.length + routePC72.length + routeRC71.length + routeRC72.length];
                System.arraycopy(routePC71, 0, routeBuffer7, position7, routePC71.length);
                System.arraycopy(routePC72, 0, routeBuffer7, position7 += routePC71.length, routePC72.length);
                System.arraycopy(routeRC72, 0, routeBuffer7, position7 += routePC72.length, routeRC72.length);
                System.arraycopy(routeRC71, 0, routeBuffer7, position7 += routeRC72.length, routeRC71.length);
                position7 += routeRC71.length;
                if (!lenListBuffer7.add(routeBuffer7)) continue;
            }
            cmdBuffer = new byte[routeBuffer3.length * lenListBuffer3.size() + routeBuffer4.length * lenListBuffer4.size() + routeBuffer5.length * lenListBuffer5.size() + routeBuffer6.length * lenListBuffer6.size() + routeBuffer7.length * lenListBuffer7.size() + routeBuffer2.length * lenListBuffer2.size()];
            for (byte[] bs : lenListBuffer2) {
                System.arraycopy(bs, 0, cmdBuffer, position, bs.length);
                position += bs.length;
            }
            for (byte[] bs : lenListBuffer3) {
                System.arraycopy(bs, 0, cmdBuffer, position, bs.length);
                position += bs.length;
            }
            for (byte[] bs : lenListBuffer4) {
                System.arraycopy(bs, 0, cmdBuffer, position, bs.length);
                position += bs.length;
            }
            for (byte[] bs : lenListBuffer5) {
                System.arraycopy(bs, 0, cmdBuffer, position, bs.length);
                position += bs.length;
            }
            for (byte[] bs : lenListBuffer6) {
                System.arraycopy(bs, 0, cmdBuffer, position, bs.length);
                position += bs.length;
            }
            for (byte[] bs : lenListBuffer7) {
                System.arraycopy(bs, 0, cmdBuffer, position, bs.length);
                position += bs.length;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return cmdBuffer;
    }

    private String ToUTF8(String content) {
        return content;
    }
}

