/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.components;

import com.simba.common.command.ICommand;
import com.simba.common.command.SQLCommandExecutor;
import com.simba.common.log.LogUtil;
import com.simba.server.commands.CommandCreator;
import com.simba.server.components.data.PackInfo;
import com.simba.server.components.task.PackInfoLoadTask;
import com.simba.server.printers.PrinterClient;
import com.simba.server.printers.PrinterManager;
import org.apache.log4j.Logger;

public class PackInfoManager {
    protected static final Logger logger = Logger.getLogger(PackInfoManager.class);
    private final PackInfoLoadTask packInfoFetchTask = new PackInfoLoadTask();

    public static PackInfoManager getInstance() {
        return PackInfoManagerHolder.INSTANCE;
    }

    private PackInfoManager() {
    }

    public void init() {
        this.initRunTask();
    }

    public void recordPrintPackInfo(PackInfo packInfo) {
        ICommand command = CommandCreator.getInstance().createCommand("RecordPrintPackCmd", packInfo);
        command.run(null);
    }

    public void renewPackInfoPrintFailed(PackInfo packInfo) {
        ICommand renewCommand = CommandCreator.getInstance().createCommand("RenewPackInfoFailedCmd", packInfo);
        SQLCommandExecutor.getInstance().executeCmd(renewCommand);
    }

    public void sendPackInfoToPrinter(PackInfo packInfo) {
        try {
            String printerIpMaster = packInfo.getPrinterIpMaster();
            String printerIpSlave = packInfo.getPrinterIpSlave();
            PrinterClient clientMaster = PrinterManager.getInstance().getClientPrinterByIP(printerIpMaster);
            PrinterClient clientSlave = PrinterManager.getInstance().getClientPrinterByIP(printerIpSlave);
            Boolean offerResult = false;
            if (clientMaster != null) {
                offerResult = clientMaster.offerPackInfoToPrint(packInfo);
                if (!offerResult.booleanValue()) {
                    this.renewPackInfoPrintFailed(packInfo);
                }
            } else if (clientSlave != null && !(offerResult = clientSlave.offerPackInfoToPrint(packInfo)).booleanValue()) {
                this.renewPackInfoPrintFailed(packInfo);
            }
        }
        catch (Exception ex) {
            LogUtil.LogError(logger, "[PackInfoManager.sendPackInfoToPrinter] Error : [" + ex.getMessage() + "]");
        }
    }

    private void initRunTask() {
        this.packInfoFetchTask.start();
    }

    private static class PackInfoManagerHolder {
        private static final PackInfoManager INSTANCE = new PackInfoManager();

        private PackInfoManagerHolder() {
        }
    }
}

