/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.commands.impl;

import com.simba.common.command.ICommand;
import com.simba.common.database.DbOperator;
import com.simba.server.components.data.PackInfo;
import java.sql.ResultSet;
import java.util.List;

public class FetchPacknfosCmd
implements ICommand {
    public static final String NAME = "FetchPacknfosCmd";
    private final List<PackInfo> packInfos;
    private final String sql = "select * from tt_slot_pack_info where printFlag=0 order by id asc limit 20";

    public FetchPacknfosCmd(List<PackInfo> packInfos) {
        this.packInfos = packInfos;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Boolean run(Object params) {
        Boolean ret = false;
        if (!(params instanceof DbOperator)) {
            return ret;
        }
        try {
            DbOperator dbOperator = (DbOperator)params;
            dbOperator.prepareStatement(this.sql);
            ResultSet rs = dbOperator.executeQuery();
            while (rs.next()) {
                PackInfo packInfo = new PackInfo();
                int id = rs.getInt("id");
                packInfo.setId(id);
                int slotId = rs.getInt("slotId");
                packInfo.setSlotId(String.valueOf(slotId));
                String count = String.valueOf(rs.getInt("mailCount"));
                packInfo.setPackCounts(count);
                String message = rs.getString("message");
                packInfo.setMessage(message);
                String boxCode = rs.getString("boxCode");
                packInfo.setBarcode(boxCode);
                String boxType = rs.getString("boxType");
                packInfo.setBoxType(boxType);
                String printerMaster = rs.getString("printerMaster");
                packInfo.setPrinterIpMaster(printerMaster);
                String printerSlave = rs.getString("printerSlave");
                packInfo.setPrinterIpSlave(printerSlave);
                this.packInfos.add(packInfo);
            }
            ret = true;
        }
        catch (Exception ex) {
            ret = false;
        }
        return ret;
    }
}

