/*
 * Decompiled with CFR 0.152.
 */
package com.simba.common.httpserver.netty;

import java.util.concurrent.ExecutorService;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.ChannelUpstreamHandler;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.handler.codec.http.HttpRequestDecoder;
import org.jboss.netty.handler.codec.http.HttpResponseEncoder;
import org.jboss.netty.handler.execution.ExecutionHandler;

public class HttpPipelineFactory
implements ChannelPipelineFactory {
    protected final ExecutorService executor;
    protected final ChannelUpstreamHandler handler;

    public HttpPipelineFactory(ExecutorService executor, ChannelUpstreamHandler handler) {
        this.executor = executor;
        this.handler = handler;
    }

    @Override
    public ChannelPipeline getPipeline() throws Exception {
        ChannelPipeline pipeline = Channels.pipeline();
        pipeline.addLast("decoder", new HttpRequestDecoder());
        pipeline.addLast("encoder", new HttpResponseEncoder());
        if (this.executor != null) {
            pipeline.addLast("executor", new ExecutionHandler(this.executor));
        }
        if (this.handler != null) {
            pipeline.addLast("handler", this.handler);
        }
        return pipeline;
    }
}

