/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.wcsclient.services.sys.json;

import com.simba.common.common.database.bean.DbPageData;
import com.simba.common.common.database.bean.ParamBean;
import com.simba.common.common.database.dao.IDaoBaseClass;
import com.simba.common.common.jsonserver.jsonservice.BaseJsonService;
import com.simba.common.common.jsonserver.jsonservice.IJsonRequest;
import com.simba.common.common.utils.StringUtil;
import com.simba.server.GlobalParam;
import com.simba.server.wcsclient.services.utils.ResponseUtil;
import com.simba.server.wcsclient.services.utils.TypeUtil;
import java.util.List;
import java.util.Map;
import javax.servlet.jsp.jstl.sql.Result;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.handler.codec.http.HttpRequest;

public class TableJsonService
extends BaseJsonService {
    public static final String NAME = "table";
    private static final Logger logger = Logger.getLogger(TableJsonService.class);

    @IJsonRequest(Url="get_all_data")
    public void GetAllData(Channel channel, Map<String, Object> map, HttpRequest request) {
        Map<String, ParamBean> maps = this.getMapByParam(map, "maps", TypeUtil.STRING_MAP_PARAMBEAN_TYPE);
        String condition = this.getStringByParam(map, "condition");
        String group = this.getStringByParam(map, "group");
        String having = this.getStringByParam(map, "having");
        String[] ignoreKeys = (String[])this.getArrayByParam(map, "ignoreKeys", TypeUtil.STRING_ARRAY_TYPE);
        boolean isOrderDesc = this.getBooleanByParam(map, "isOrderDesc", false);
        String userId = this.getStringByParam(map, "userId");
        String tableName = this.getStringByParam(map, "tableName");
        if (StringUtil.isNull(userId).booleanValue() || StringUtil.isNull(tableName).booleanValue()) {
            Map<String, Object> result = ResponseUtil.CreateResponseMap(false, "\u8eab\u4efd\u9a8c\u8bc1\u5931\u8d25");
            this.renderJson(channel, result, request);
            return;
        }
        IDaoBaseClass dao = GlobalParam.databases.getDatabase(tableName);
        Result data = dao.GetAllData(maps, condition, group, having, ignoreKeys, isOrderDesc);
        Map<String, Object> result = ResponseUtil.CreateResponseMap(true, "\u8bf7\u6c42\u6210\u529f");
        result.put("data", data.getRows());
        this.renderJson(channel, result, request);
    }

    @IJsonRequest(Url="get_data_by_page")
    public void GetDataByPage(Channel channel, Map<String, Object> map, HttpRequest request) {
        int pageSize = this.getIntegerByParam(map, "pageSize", 25);
        int currentPage = this.getIntegerByParam(map, "currentPage", 1);
        int count = this.getIntegerByParam(map, "count", 0);
        Map<String, ParamBean> maps = this.getMapByParam(map, "maps", TypeUtil.STRING_MAP_PARAMBEAN_TYPE);
        String keywords = this.getStringByParam(map, "keywords");
        String group = this.getStringByParam(map, "group");
        String having = this.getStringByParam(map, "having");
        String[] ignoreKeys = (String[])this.getArrayByParam(map, "ignoreKeys", TypeUtil.STRING_ARRAY_TYPE);
        boolean isOrderDesc = this.getBooleanByParam(map, "isOrderDesc", false);
        String userId = this.getStringByParam(map, "userId");
        String tableName = this.getStringByParam(map, "tableName");
        if (StringUtil.isNull(userId).booleanValue() || StringUtil.isNull(tableName).booleanValue()) {
            Map<String, Object> result = ResponseUtil.CreateResponseMap(false, "\u8eab\u4efd\u9a8c\u8bc1\u5931\u8d25");
            this.renderJson(channel, result, request);
            return;
        }
        IDaoBaseClass dao = GlobalParam.databases.getDatabase(tableName);
        DbPageData data = dao.GetDataByPage(pageSize, currentPage, count, maps, keywords, ignoreKeys, group, having, isOrderDesc);
        Map<String, Object> result = ResponseUtil.CreateResponseMap(true, "\u8bf7\u6c42\u6210\u529f");
        result.put("data", data);
        this.renderJson(channel, result, request);
    }

    @IJsonRequest(Url="delete_data_info_by_id")
    public void DeleteDataInfoById(Channel channel, Map<String, Object> map, HttpRequest request) {
        String value = this.getStringByParam(map, "value");
        String userId = this.getStringByParam(map, "userId");
        String tableName = this.getStringByParam(map, "tableName");
        if (StringUtil.isNull(userId).booleanValue() || StringUtil.isNull(tableName).booleanValue()) {
            Map<String, Object> result = ResponseUtil.CreateResponseMap(false, "\u8eab\u4efd\u9a8c\u8bc1\u5931\u8d25");
            this.renderJson(channel, result, request);
            return;
        }
        IDaoBaseClass dao = GlobalParam.databases.getDatabase(tableName);
        int data = dao.DeleteDataInfoById(value);
        Map<String, Object> result = ResponseUtil.CreateResponseMap(true, "\u8bf7\u6c42\u6210\u529f");
        result.put("data", data);
        this.renderJson(channel, result, request);
    }

    @IJsonRequest(Url="delete_data_info_by_Condition")
    public void DeleteDataInfoByCondition(Channel channel, Map<String, Object> map, HttpRequest request) {
        Map<String, ParamBean> maps = this.getMapByParam(map, "maps", TypeUtil.STRING_MAP_PARAMBEAN_TYPE);
        String condition = this.getStringByParam(map, "condition");
        String group = this.getStringByParam(map, "group");
        String having = this.getStringByParam(map, "having");
        String[] ignoreKeys = (String[])this.getArrayByParam(map, "ignoreKeys", TypeUtil.STRING_ARRAY_TYPE);
        String userId = this.getStringByParam(map, "userId");
        String tableName = this.getStringByParam(map, "tableName");
        if (StringUtil.isNull(userId).booleanValue() || StringUtil.isNull(tableName).booleanValue()) {
            Map<String, Object> result = ResponseUtil.CreateResponseMap(false, "\u8eab\u4efd\u9a8c\u8bc1\u5931\u8d25");
            this.renderJson(channel, result, request);
            return;
        }
        IDaoBaseClass dao = GlobalParam.databases.getDatabase(tableName);
        int data = dao.DeleteDataInfoByCondition(maps, condition, group, having, ignoreKeys);
        Map<String, Object> result = ResponseUtil.CreateResponseMap(true, "\u8bf7\u6c42\u6210\u529f");
        result.put("data", data);
        this.renderJson(channel, result, request);
    }

    @IJsonRequest(Url="get_count_by_condition")
    public void GetCountByCondition(Channel channel, Map<String, Object> map, HttpRequest request) {
        Map<String, ParamBean> maps = this.getMapByParam(map, "maps", TypeUtil.STRING_MAP_PARAMBEAN_TYPE);
        String keywords = this.getStringByParam(map, "keywords");
        String condition = this.getStringByParam(map, "condition");
        String[] ignoreKeys = (String[])this.getArrayByParam(map, "ignoreKeys", TypeUtil.STRING_ARRAY_TYPE);
        String userId = this.getStringByParam(map, "userId");
        String tableName = this.getStringByParam(map, "tableName");
        if (StringUtil.isNull(userId).booleanValue() || StringUtil.isNull(tableName).booleanValue()) {
            Map<String, Object> result = ResponseUtil.CreateResponseMap(false, "\u8eab\u4efd\u9a8c\u8bc1\u5931\u8d25");
            this.renderJson(channel, result, request);
            return;
        }
        IDaoBaseClass dao = GlobalParam.databases.getDatabase(tableName);
        int data = dao.GetCountByCondition(maps, keywords, condition, ignoreKeys);
        Map<String, Object> result = ResponseUtil.CreateResponseMap(true, "\u8bf7\u6c42\u6210\u529f");
        result.put("data", data);
        this.renderJson(channel, result, request);
    }

    @IJsonRequest(Url="add_new_data_info")
    public void AddNewDataInfo(Channel channel, Map<String, Object> map, HttpRequest request) {
        Map<String, ParamBean> maps = this.getMapByParam(map, "maps", TypeUtil.STRING_MAP_PARAMBEAN_TYPE);
        String userId = this.getStringByParam(map, "userId");
        String tableName = this.getStringByParam(map, "tableName");
        if (StringUtil.isNull(userId).booleanValue() || StringUtil.isNull(tableName).booleanValue()) {
            Map<String, Object> result = ResponseUtil.CreateResponseMap(false, "\u8eab\u4efd\u9a8c\u8bc1\u5931\u8d25");
            this.renderJson(channel, result, request);
            return;
        }
        IDaoBaseClass dao = GlobalParam.databases.getDatabase(tableName);
        int data = dao.AddNewDataInfo(maps);
        Map<String, Object> result = ResponseUtil.CreateResponseMap(true, "\u8bf7\u6c42\u6210\u529f");
        result.put("data", data);
        this.renderJson(channel, result, request);
    }

    @IJsonRequest(Url="add_ignore_data_info")
    public void AddIgnoreDataInfo(Channel channel, Map<String, Object> map, HttpRequest request) {
        Map<String, ParamBean> maps = this.getMapByParam(map, "maps", TypeUtil.STRING_MAP_PARAMBEAN_TYPE);
        boolean isIgnore = this.getBooleanByParam(map, "isIgnore", true);
        String userId = this.getStringByParam(map, "userId");
        String tableName = this.getStringByParam(map, "tableName");
        if (StringUtil.isNull(userId).booleanValue() || StringUtil.isNull(tableName).booleanValue()) {
            Map<String, Object> result = ResponseUtil.CreateResponseMap(false, "\u8eab\u4efd\u9a8c\u8bc1\u5931\u8d25");
            this.renderJson(channel, result, request);
            return;
        }
        IDaoBaseClass dao = GlobalParam.databases.getDatabase(tableName);
        int data = dao.AddIgnoreDataInfo(maps, isIgnore);
        Map<String, Object> result = ResponseUtil.CreateResponseMap(true, "\u8bf7\u6c42\u6210\u529f");
        result.put("data", data);
        this.renderJson(channel, result, request);
    }

    @IJsonRequest(Url="batch_add_data")
    public void BatchAddData(Channel channel, Map<String, Object> map, HttpRequest request) {
        List<Map<String, ParamBean>> list = this.getListByParam(map, "list", TypeUtil.STRING_LIST_MAP_PARAMBEAN_TYPE);
        int batchSize = this.getIntegerByParam(map, "batchSize", 500);
        int commitSize = this.getIntegerByParam(map, "commitSize", 1000);
        String userId = this.getStringByParam(map, "userId");
        String tableName = this.getStringByParam(map, "tableName");
        if (StringUtil.isNull(userId).booleanValue() || StringUtil.isNull(tableName).booleanValue()) {
            Map<String, Object> result = ResponseUtil.CreateResponseMap(false, "\u8eab\u4efd\u9a8c\u8bc1\u5931\u8d25");
            this.renderJson(channel, result, request);
            return;
        }
        IDaoBaseClass dao = GlobalParam.databases.getDatabase(tableName);
        int data = dao.BatchAddData(list, batchSize, commitSize);
        Map<String, Object> result = ResponseUtil.CreateResponseMap(true, "\u8bf7\u6c42\u6210\u529f");
        result.put("data", data);
        this.renderJson(channel, result, request);
    }

    @IJsonRequest(Url="truncation_data")
    public void TruncationData(Channel channel, Map<String, Object> map, HttpRequest request) {
        String userId = this.getStringByParam(map, "userId");
        String tableName = this.getStringByParam(map, "tableName");
        if (StringUtil.isNull(userId).booleanValue() || StringUtil.isNull(tableName).booleanValue()) {
            Map<String, Object> result = ResponseUtil.CreateResponseMap(false, "\u8eab\u4efd\u9a8c\u8bc1\u5931\u8d25");
            this.renderJson(channel, result, request);
            return;
        }
        IDaoBaseClass dao = GlobalParam.databases.getDatabase(tableName);
        boolean data = dao.TruncationData();
        Map<String, Object> result = ResponseUtil.CreateResponseMap(true, "\u8bf7\u6c42\u6210\u529f");
        result.put("data", data);
        this.renderJson(channel, result, request);
    }

    @IJsonRequest(Url="update_data_by_id")
    public void UpdateDataById(Channel channel, Map<String, Object> map, HttpRequest request) {
        Map<String, ParamBean> maps = this.getMapByParam(map, "maps", TypeUtil.STRING_MAP_PARAMBEAN_TYPE);
        String value = this.getStringByParam(map, "value");
        String userId = this.getStringByParam(map, "userId");
        String tableName = this.getStringByParam(map, "tableName");
        if (StringUtil.isNull(userId).booleanValue() || StringUtil.isNull(tableName).booleanValue()) {
            Map<String, Object> result = ResponseUtil.CreateResponseMap(false, "\u8eab\u4efd\u9a8c\u8bc1\u5931\u8d25");
            this.renderJson(channel, result, request);
            return;
        }
        IDaoBaseClass dao = GlobalParam.databases.getDatabase(tableName);
        int data = dao.UpdateDataById(maps, value);
        Map<String, Object> result = ResponseUtil.CreateResponseMap(true, "\u8bf7\u6c42\u6210\u529f");
        result.put("data", data);
        this.renderJson(channel, result, request);
    }

    @IJsonRequest(Url="update_data_by_condition")
    public void UpdateDataByCondition(Channel channel, Map<String, Object> map, HttpRequest request) {
        Map<String, ParamBean> maps = this.getMapByParam(map, "maps", TypeUtil.STRING_MAP_PARAMBEAN_TYPE);
        String key = this.getStringByParam(map, "key");
        String value = this.getStringByParam(map, "value");
        String userId = this.getStringByParam(map, "userId");
        String tableName = this.getStringByParam(map, "tableName");
        if (StringUtil.isNull(userId).booleanValue() || StringUtil.isNull(tableName).booleanValue()) {
            Map<String, Object> result = ResponseUtil.CreateResponseMap(false, "\u8eab\u4efd\u9a8c\u8bc1\u5931\u8d25");
            this.renderJson(channel, result, request);
            return;
        }
        IDaoBaseClass dao = GlobalParam.databases.getDatabase(tableName);
        int data = dao.UpdateDataByCondition(maps, key, value);
        Map<String, Object> result = ResponseUtil.CreateResponseMap(true, "\u8bf7\u6c42\u6210\u529f");
        result.put("data", data);
        this.renderJson(channel, result, request);
    }
}

